<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>All Bonus</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">All Bonus</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h4>Add New Bonus</h4>
                
              </div>
              <!-- /.card-header -->
              <?php echo form_open_multipart(base_url().'admin/product/add_new_product_bonus'); ?>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Select Product<span class="required">*</span></label>
                      <select type="text" name="bonus_prd_id" class="form-control" placeholder="Enter Title" required="">
                        <option value="">Select</option>
                        <?php foreach ($get_all_product as $key => $product): ?>
                            <option value="<?php echo $product->prd_id; ?>"><?php echo $product->prd_name  ; ?></option>
                        <?php endforeach ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Description<span class="required">*</span></label>
                      <textarea type="text" name="bonus_description" class="form-control" placeholder="Enter Description" required=""></textarea>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Image</label>
                      <input type="file" name="bonus_image" class="form-control" required>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <button class="btn btn-info" type="submit" style="float: right">Add</button>
                    </div>
                  </div>
                  <?php echo form_close(); ?>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h4>View All Bonus</h4>
                
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Image</th>    
                      <th>Description</th>                     
                      <th>Product</th>
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($all_bonus as $key => $bonus):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><img src="<?php echo base_url(); ?><?php echo $bonus->bonus_image ?>" width="50"></td>
                      <td><?php echo $bonus->bonus_description ?></td>
                      <td><?php echo $bonus->prd_name ?></td>
                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-lession<?php echo $bonus->bonus_id  ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/product/delete_product_bonus/<?php echo $bonus->bonus_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>

<?php $i=1; foreach ($all_bonus as $key => $bonus):?>
<div class="modal fade" id="update-lession<?php echo $bonus->bonus_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Update Bonus</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open_multipart(base_url().'admin/product/update_product_bonus/'.$bonus->bonus_id); ?>
        <div class="col-md-12">
            <div class="form-group">
              <label>Select Product<span class="required">*</span></label>
              <select type="text" name="bonus_prd_id" class="form-control" placeholder="Enter Title" required="">
                <option value="">Select</option>
                <?php foreach ($get_all_product as $key => $product): ?>
                    <option <?php if($bonus->bonus_prd_id == $product->prd_id){echo 'selected';}?> value="<?php echo $product->prd_id; ?>"><?php echo $product->prd_name; ?></option>
                <?php endforeach ?>
              </select>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label>Description<span class="required">*</span></label>
              <textarea type="text" name="bonus_description" class="form-control" placeholder="Enter Description" required=""><?php echo $bonus->bonus_description; ?></textarea>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label>Image</label>
              <input type="file" name="bonus_image" class="form-control">
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label>Image<span class="required">*</span></label>
              <img src="<?php echo base_url() ?><?php echo $bonus->bonus_image; ?>" width="100">
            </div>
          </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      <?php echo form_close(); ?>
    </div>
  </div>
</div>
 <?php endforeach; ?>