<?php $section = $sections['section_2'] ?? []; ?>
<form method="post" action="<?php echo site_url('admin/product/save_section'); ?>" enctype="multipart/form-data">

    <input type="hidden" name="prd_id" value="<?php echo $product['prd_id']; ?>">
    <input type="hidden" name="section_key" value="section_2">

    <!-- Main Title -->
    <div class="form-group">
        <label>Main Title</label>
        <input type="text" name="main_title" class="form-control"
            value="<?php echo $section['main_title'] ?? ''; ?>">
    </div>

    <hr>

    <h5>Feature Items</h5>

    <div id="feature-wrapper">

        <?php
        $items = $section['items'] ?? [];
        if (empty($items)) {
            $items = [
                ['image' => '', 'title' => '', 'description' => '']
            ];
        }

        foreach ($items as $index => $item):
        ?>

            <div class="feature-box border p-3 mb-3">

                <!-- ✅ FEATURE IMAGE -->
                <!-- ✅ FEATURE IMAGE -->
                <div class="form-group">
                    <label>Feature Image (200x200px)</label>
                    <input type="file" name="feature_image[<?php echo $index; ?>]" class="form-control">

                    <?php if (!empty($item['image'])): ?>
                        <img src="<?php echo base_url($item['image']); ?>" style="width:80px;margin-top:8px;">
                        <input type="hidden" name="old_feature_image[<?php echo $index; ?>]"
                            value="<?php echo $item['image']; ?>">
                    <?php endif; ?>
                </div>


                <!-- ✅ FEATURE TITLE -->
                <div class="form-group">
                    <label>Feature Title</label>
                    <input name="items[<?php echo $index; ?>][title]" class="form-control"
                        value="<?php echo $item['title'] ?? ''; ?>">
                </div>

                <!-- ✅ FEATURE DESCRIPTION -->
                <div class="form-group">
                    <label>Feature Description</label>
                    <textarea name="items[<?php echo $index; ?>][description]"
                        class="form-control" rows="2"><?php echo $item['description'] ?? ''; ?></textarea>
                </div>

                <button type="button" class="btn btn-danger remove-feature">Remove</button>
            </div>

        <?php endforeach; ?>

    </div>

    <button type="button" id="add-feature" class="btn btn-secondary mb-3">Add More Feature</button>

    <hr>

    <!-- ✅ Right Side Main Image -->
 <div class="form-group">
    <label>Right Side Image</label>
    <input type="file" name="main_image" class="form-control">

    <?php if (!empty($section['image'])): ?>
        <img src="<?php echo base_url($section['image']); ?>" style="max-width:200px;margin-top:10px;">
        <input type="hidden" name="old_main_image" 
               value="<?php echo $section['image']; ?>">
    <?php endif; ?>
</div>


    <button class="btn btn-success">Save Section</button>

</form>


<script>
    let featureIndex = <?php echo count($items); ?>;

    document.querySelector('#add-feature').addEventListener('click', function() {
        let html = `
        <div class="feature-box border p-3 mb-3">

            <div class="form-group">
                <label>Feature Image (200x200px)</label>
                <input type="file" name="feature_image_` + featureIndex + `" class="form-control">
            </div>

            <div class="form-group">
                <label>Feature Title</label>
                <input name="items[` + featureIndex + `][title]" class="form-control">
            </div>

            <div class="form-group">
                <label>Feature Description</label>
                <textarea name="items[` + featureIndex + `][description]" class="form-control" rows="2"></textarea>
            </div>

            <button type="button" class="btn btn-danger remove-feature">Remove</button>
        </div>
    `;
        document.querySelector('#feature-wrapper').insertAdjacentHTML('beforeend', html);
        featureIndex++;
    });

    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('remove-feature')) {
            e.target.closest('.feature-box').remove();
        }
    });
</script>