<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Working Hours Report</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item"><a href="#">Report</a></li>
              <li class="breadcrumb-item active">Working Hours Report</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
               <h3 class="card-title"><?php echo $title ?></h3>
              </div>
                <div class="card-body">
                  <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>Date</th>
                      <th>Login Time</th>
                      <th>Logout Time</th>
                      <th>Working Hours</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($all_report as $key => $report):?>
                    <tr>
                      <td><?php echo date("d M, Y", strtotime($report->working_report_date)) ?></td>
                      <td><?php echo date("h:i:s A", strtotime($report->main_data[0]->login_time)); ?>
                      <?php if($report->main_data[0]->login_time > $report->working_report_login_time_was) : ?>
                        <br/>
                        <small><span class="badge badge-danger"><i class="fa fa-arrow-down" aria-hidden="true"></i> &nbsp;
                          <?php 
                          $login_time_1 = new DateTime($report->main_data[0]->login_time);
                          $logout_time_1 = new DateTime($report->working_report_login_time_was);
                          $interval_1 = $logout_time_1->diff($login_time_1);
                          $days_1 = $interval_1->format('%d');
                          $hours_1 = 24 * $days_1 + $interval_1->format('%h');
                          echo $hours_1.' Hrs. '.$interval_1->format('%i').'Min.';
                          ?>
                        </span></small>
                      <?php endif;?>
                      </td>
                      <td><?php echo date("h:i:s A", strtotime($report->main_data[0]->logout_time)); ?>
                      <?php if($report->main_data[0]->logout_time < $report->working_report_log_out_time_was) : ?>
                        <br/>
                        <small><span class="badge badge-danger"><i class="fa fa-arrow-up" aria-hidden="true"></i> &nbsp;
                          <?php 
                          $login_time_2 = new DateTime($report->main_data[0]->logout_time);
                          $logout_time_2 = new DateTime($report->working_report_log_out_time_was);
                          $interval_2 = $logout_time_2->diff($login_time_2);
                          $days_2 = $interval_2->format('%d');
                          $hours_2 = 24 * $days_2 + $interval_2->format('%h');
                          echo $hours_2.' Hrs. '.$interval_2->format('%i').'Min.';
                          ?>
                        </span></small>
                      <?php endif;?>
                      </td>
                      <td><?php 
                          $login_time = new DateTime($report->main_data[0]->login_time);
                          $logout_time = new DateTime($report->main_data[0]->logout_time);
                          $interval = $logout_time->diff($login_time);
                          $days = $interval->format('%d');
                          $hours = 24 * $days + $interval->format('%h');
                          echo $hours.' Hrs. '.$interval->format('%i').'Min.';

                          $main_working_hrs = floor($report->working_report_working_hrs * 60);
                          $working_hrs =  floor($hours * 60) + $interval->format('%i');
                          $ttl_working_data =  $main_working_hrs - $working_hrs;
                          if($ttl_working_data > 0)
                          {
                          ?>
                          <small><span class="badge badge-danger"><i class="fa fa-arrow-down" aria-hidden="true"></i> &nbsp;<?php echo date('H', mktime(0,$ttl_working_data));?>Hrs. <?php echo date('i', mktime(0,$ttl_working_data));?>Min. </span></small>
                        <?php } ?>
                      </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>
