<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
   <section class="content-header">
      <div class="container-fluid">
         <div class="row mb-2">
            <div class="col-sm-6">
               <h4><?php echo htmlspecialchars($title) ?></h4>
            </div>
            <div class="col-sm-6">
               <ol class="breadcrumb float-sm-right">
                  <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>dashboard">Home</a></li>
                  <li class="breadcrumb-item active"><?php echo htmlspecialchars($title) ?></li>
               </ol>
            </div>
         </div>
      </div>
      <!-- /.container-fluid -->
   </section>
   <?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
   <section class="content">
      <div class="container">
         <div class="row"> 
            <div class="col-md-12 col-lg-12">
               <div class="card">
                  <div class="card-header">
                     <h3 class="card-title">All <?php echo $title?></h3>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body">
                     <table width="100%" id="example" class="table table-bordered table-striped">
                        <thead>
                           <tr>
                              <th width="10%">Sl.No.</th>
                              <th>Course</th>
                              <th>User Name</th>
                              <th>Rating</th>
                              <th>Comments</th>
                              <th>Status</th>
                              <th>Date</th>
                              <th></th>
                           </tr>
                        </thead>
                        <tbody>
                          <?php 
                          $i = 1;
                          foreach ($all_review as $key => $review){ ?>
                             <tr>
                              <td><?php echo $i ?></td>
                              <td><?php echo $review->title ?></td>
                              <td><?php echo $review->name ?></td>
                              <td><?php echo $review->rate ?></td>
                              <td><?php echo $review->comments ?></td>
                              <td><?php if($review->status == 1){echo 'Active';}else{echo 'Pending';}?></td>
                              <td><?php echo $review->date_time ?></td>
                              <td>
                                 <div class="input-group-prepend">
                                   <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                     Action
                                   </button>
                                   <div class="dropdown-menu" style="">
                                   <?php if($review->status == 1):?>
                                       <a class="dropdown-item" onclick="return confirm('Are you sure?')" href="<?php echo admin_url() ?>review/pending_course_review/<?php echo $review->review_id ?>"><i class="fa fa-ban" aria-hidden="true"></i> &nbsp;Pending</a>
                                    <?php else: ?>
                                       <a class="dropdown-item" onclick="return confirm('Are you sure?')" href="<?php echo admin_url() ?>review/active_course_review/<?php echo $review->review_id ?>"><i class="fa fa-check" aria-hidden="true"></i> &nbsp;Active</a>
                                    <?php endif;?>
                                   
                                     <a class="dropdown-item" onclick="return confirm('Are you sure?')" href="<?php echo admin_url() ?>review/delete_course_review/<?php echo $review->review_id ?>"><i class="fa fa-trash-o" aria-hidden="true"></i>
                                      &nbsp;Delect</a>
                                   </div>
                                 </div>
                              </td>
                           </tr>
                          <?php $i++;}; ?>
                        </tbody>
                     </table>
                  </div>
                  <!-- /.card-body -->
               </div>
               <!-- /.card -->
            </div>
         </div>
      </div>
   </div>
   
</section>
</div>
<!-- /.content-wrapper -->

<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Upload CSV For Email</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open_multipart('admin/admin_controller/import_email'); ?>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Upload:</label>
            <input type="file" name="file" class="form-control" id="recipient-name">
          </div>
        
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary" name="importSubmit" value="IMPORT">Import</button>
      </div>
    </div>
    <?php echo form_close(); ?>
  </div>
</div>