<div class="content-wrapper">
    <div class="container-full">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="d-flex align-items-center">
                <div class="me-auto">
                    <h3 class="page-title">Learner Report</h3>
                    <div class="d-inline-block align-items-center">
                        <nav>
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="#"><i class="mdi mdi-home-outline"></i></a></li>
                                <li class="breadcrumb-item" aria-current="page">Dashboard</li>
                                <li class="breadcrumb-item active" aria-current="page">Learner Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>

            </div>
        </div>

        <!-- Main content -->
        <section class="content">
            <div class="row d-flex justify-content-center">
                <div class="col-xl-12">
                    <div class="box">
                        <div class="box-body d-flex p-0">
                            <div class="flex-grow-1 bg-warning-light p-30 flex-grow-1 bg-img" style="background-position: 50px bottom; background-size: auto 80%; background-image: url(<?php echo student_lms_css(); ?>images/code.png)">
                                <div class="row">
                                    <div class="col-12 col-xl-3"></div>
                                    <div class="col-12 col-xl-9">
                                        <h4 class="text-warning fw-500">Hey <?php echo user()->name; ?>,</h4>
                                        <h5>Your Monthly Learner Report is in.</h5>
                                        <p class="text-dark my-10 fs-16">
                                            Check out your stats for the month, see how you're growing, and aim to achieve even more next month!
                                        </p>
                                        <?php
                                        $user_created = user()->created_at; // user created date
                                        $current_date = date('Y-m-d'); // today's date

                                        $start = new DateTime($user_created);
                                        $end = new DateTime($current_date);

                                        // Include the current month
                                        $end->modify('first day of next month');

                                        $current_month = date('F Y'); // Example: "April 2025"

                                        echo '<div>';
                                        echo '<select class="form-control select-month">';

                                        while ($start < $end) {
                                            $value = $start->format('F Y'); // Example: "August 2024"
                                            $selected = ($value == $current_month) ? 'selected' : '';
                                            echo '<option value="' . $value . '" ' . $selected . '>' . $value . '</option>';
                                            $start->modify('+1 month');
                                        }

                                        echo '</select>';
                                        echo '</div>';
                                        ?>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-12 col-xl-12 p-4 rounded-4" style="background-color: #e1eaf9;">
                    <h4 class="box-title text-dark pt-3 ps-3 pb-3">Learning Stats in <b><?php echo date('F') ?></b></h4>
                    <div class="row">
                        <div class="col-12 col-xl-5">
                            <div class="box">
                                <div class="box-body px-3 py-3  rounded-0">
                                    <div id="calendar" class="dask evt-cal"></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-xl-7">
                            <div class="row">
                                <div class="col-12 col-xl-6">
                                    <div class="box mb-15 pull-up">
                                        <div class="box-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-15 bg-warning h-50 w-50 l-h-60 rounded text-center">
                                                        <span class="fa fa-clock fs-24"><span class="path1"></span><span class="path2"></span></span>
                                                    </div>
                                                    <div class="d-flex flex-column fw-500">
                                                        <a href="#" class="text-dark hover-primary mb-1 fs-16"><?php echo convertSeconds($student_timing['total_timing']); ?></a>
                                                        <span class="text-fade">Total Time Learning</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-xl-6">
                                    <div class="box mb-15 pull-up">
                                        <div class="box-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-15 bg-warning h-50 w-50 l-h-60 rounded text-center">
                                                        <span class="icon-Book-open fs-24"><span class="path1"></span><span class="path2"></span></span>
                                                    </div>
                                                    <div class="d-flex flex-column fw-500">
                                                        <a href="#" class="text-dark hover-primary mb-1 fs-16"><?php echo getDayWithSuffix($student_timing['max_activity_date']) ?> <?php echo date('M', strtotime($student_timing['max_activity_date'])) ?> | <?php echo convertSeconds($student_timing['max_activity_timing']); ?></a>
                                                        <span class="text-fade">Best Learning Day</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-xl-12">
                                    <div class="box">
                                        <div class="box-body">
                                            <p class="text-fade fs-12">Average number of hours you learn on days of the week</p>
                                            <div id="charts_widget_2_chart"></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-xl-6">
                                    <div class="box mb-15 pull-up">
                                        <div class="box-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-15 bg-white h-50 w-50 l-h-60 rounded text-center">
                                                        <span class="fs-24"><img style="width: 55px;margin-top: -10px;" src="https://alison.com/html/site/img/angular-shop/learner-report/bestday@2x.png"></span>
                                                    </div>
                                                    <div class="d-flex flex-column fw-500">
                                                        <a href="#" class="text-dark hover-primary mb-1 fs-16"><?php echo date('l', strtotime($week_activity['max_activity_date'])); ?></a>
                                                        <span class="text-fade">are your best day</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-12 col-xl-6">
                                    <div class="box mb-15 pull-up">
                                        <div class="box-body">
                                            <div class="d-flex align-items-center justify-content-between">
                                                <div class="d-flex align-items-center">
                                                    <div class="me-15 bg-white h-50 w-50 l-h-60 rounded text-center">
                                                        <span class="fs-24"><img style="width: 45px;margin-top: -10px;" src="https://alison.com/html/site/img/angular-shop/learner-report/study-least@2x.png"></span>
                                                    </div>
                                                    <div class="d-flex flex-column fw-500">
                                                        <a href="#" class="text-dark hover-primary mb-1 fs-16"><?php echo date('l', strtotime($week_activity['min_activity_date'])); ?></a>
                                                        <span class="text-fade">you study the least</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col-12 col-xl-12 p-4 rounded-4" style="background-color: #e1eaf9;">
                    <h4 class="box-title text-dark pt-3 ps-3 pb-3">Goals and Achievements in <b><?php echo date('F') ?></b></h4>
                    <div class="row">
                        <div class="col-12 col-xl-7">
                           <div class="box pull-up medal-section">
                                <div class="box-body">
                                    <div class="d-flex align-items-center">
                                        <div class="d-flex flex-column flex-grow-1">
                                            <h5 class="mb-3">YOU EARNED <span class="text-primary fw-bold">1 MEDALS</span>
                                                <span class="text-success">● 1 medals more than last month</span>
                                            </h5>
                                        </div>
                                    </div>
                                    <?php echo $medal_report; ?>
                                </div>
                            </div>
                            
                        </div>
                        <style>
                            .medal-section .btn
                            {
                                display: none;
                            }
                        </style>

                        <div class="col-12 col-xl-5 counting">
                            <div class="row">

                                <div class="col-12 col-xl-6">
                                    <a class="box box-link-shadow text-center pull-up d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="stact-content">
                                            <p class="course-count mb-0">0</p>
                                            <p class="follow-text">Courses you completed</p>
                                        </div>
                                        <div class="stact-img">
                                            <img src="https://cdn01.alison-static.net/public/html/site/img/angular-shop/learner-report/courses-completed.png" class="img-fluid">
                                        </div>
                                    </a>
                                </div>
                                <div class="col-12 col-xl-6">
                                    <a class="box box-link-shadow text-center pull-up d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="stact-content">
                                            <p class="course-count mb-0">0</p>
                                            <p class="follow-text">Certificates you claimed</p>
                                        </div>
                                        <div class="stact-img">
                                            <img src="https://alison.com/html/site/img/angular-shop/learner-report/certs-claimed.png" class="img-fluid">
                                        </div>
                                    </a>
                                </div>
                                <div class="col-12 col-xl-6">
                                    <a class="box box-link-shadow text-center pull-up d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="stact-content">
                                            <p class="course-count mb-0">1</p>
                                            <p class="follow-text">Courses in progress</p>
                                        </div>
                                        <div class="stact-img">
                                            <img src="https://alison.com/html/site/img/angular-shop/learner-report/courses-in-progress.png" class="img-fluid">
                                        </div>
                                    </a>
                                </div>
                                <div class="col-12 col-xl-6">
                                    <a class="box box-link-shadow text-center pull-up d-flex justify-content-between" href="javascript:void(0)">
                                        <div class="stact-content">
                                            <p class="course-count mb-0">0%</p>
                                            <p class="follow-text ps-1">Average assessment score</p>
                                        </div>
                                        <div class="stact-img">
                                            <img src="https://alison.com/html/site/img/angular-shop/learner-report/avg_assessment_score.png" class="img-fluid">
                                        </div>
                                    </a>
                                </div>
                                <style>
                                    .course-count {
                                        font-size: 52px;
                                        font-weight: 700;
                                        text-align: left;
                                        padding-left: 20px;
                                    }


                                    .follow-text {
                                        max-width: 150px;
                                        width: 100%;
                                        color: #89959d;
                                        text-transform: uppercase;
                                        font-weight: 700;
                                        font-size: 12px;
                                    }
                                </style>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
    </div>
    </section>
</div>
<style>
    .counting .box {
        flex-direction: inherit;
    }

    .counting .box-body {
        padding: 10px;
    }

    .theme-violet .bg-info-light {
        background-color: #0f2449 !important;
        color: #fff;
    }

    .fc-left {
        display: none;
    }

    #calendar {
        height: 426px;
        overflow: hidden;
    }

    .medal-box {
        border-radius: 10px;
        background: #f9fcff;
        padding: 20px;
    }

    .medal-icon {
        width: 80px;
        height: 80px;
    }

    .medal-col {
        text-align: center;
    }

    .medal-number {
        position: absolute;
        top: 57%;
        left: 50%;
        transform: translate(-50%, -50%);
        font-size: 20px;
        font-weight: bold;
        color: #444;
    }

    .position-relative img {
        opacity: 0.5;
    }

    .earned img {
        opacity: 1;
    }

    .select-month {
        width: 100px;
    }
</style>
<script>
    var defaultEvents = <?php echo json_encode($week_event); ?>;
    var hours_spent = <?php echo $week_hrs_spent; ?>;
</script>