<div class="content-wrapper">
    <div class="container-full">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="d-flex align-items-center">
                <div class="me-auto">
                    <h3 class="page-title">My Courses</h3>
                    <div class="d-inline-block align-items-center">
                        <nav>
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="#"><i class="mdi mdi-home-outline"></i></a></li>
                                <li class="breadcrumb-item" aria-current="page">Dashboard</li>
                                <li class="breadcrumb-item active" aria-current="page">My Courses</li>
                            </ol>
                        </nav>
                    </div>
                </div>

            </div>
        </div>

        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xl-12 col-12">

                    <div class="row">
                        <div class="col-lg-12 col-12">
                            <div class="box">
                                <?php foreach ($enrolments as $enrolment):
                                    $course_details = $this->course_model->get_course_by_id_for_lms($enrolment->course_id)->row_array();
                                    // $instructor_details = $this->user_model->get_all_user($course_details['creator'])->row_array();
                                    $course_duration = $this->course_model->get_total_duration_of_lesson_by_course_id($course_details['course_id']);
                                    $lectures = $this->db->get_where('lesson', ['course_id' => $course_details['course_id'], 'lesson_type !=' => 'quiz']);
                                    $quizzes = $this->db->get_where('lesson', ['course_id' => $course_details['course_id'], 'lesson_type' => 'quiz']);
                                    $watch_history = $this->course_model->get_watch_histories(user()->id, $course_details['course_id'])->row_array();
                                    $course_progress = isset($watch_history['course_progress']) ? $watch_history['course_progress'] : 0;
                                ?>
                                    <div class="box-body">
                                        <div
                                            class="d-flex align-items-center justify-content-between">
                                            <div class="d-flex align-items-center">
                                                <div
                                                    class="me-15 bg-primary-light h-50 w-50 l-h-40 rounded text-center">
                                                    <img
                                                        src="<?php echo student_lms_css(); ?>images/front-end-img/courses/lesson.png"
                                                        alt=""
                                                        class="align-self-end h-50 w-50" />
                                                </div>
                                                <div class="d-flex flex-column fw-500">
                                                    <a href="<?php echo site_url('admin/admin/lesson/' . $course_details['course_slug'] . '/' . $course_details['course_id'])
                                                                ?>" class="text-dark hover-primary mb-1 fs-16"><?php echo $course_details['course_heading']; ?></a>
                                                    <span class="text-fade"><?php echo get_phrase('Lectures') . ' ' . $lectures->num_rows(); ?> | <?php echo get_phrase('Quizzes') . ' ' . $quizzes->num_rows(); ?></span>
                                                </div>
                                            </div>
                                            <div>
                                                <p class="m-0 text-fade">Time</p>
                                                <h5 class="m-0"><?php echo $course_duration; ?></h5>
                                            </div>
                                            <div class="d-none d-md-block">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div class="w-100">
                                                        <div class="progress progress-sm mb-0">
                                                            <div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="<?php echo $course_progress; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $course_progress; ?>%">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="ps-3">
                                                        <div><?php echo $course_progress; ?>%</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="d-none d-md-block">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <a href="<?php echo site_url('admin/admin/lesson/' . $course_details['course_slug'] . '/' . $course_details['course_id'])
                                                                ?>" class="btn " style="background-color:#0f2449; color:#fff">Continue Learning</a>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <!-- /. box -->
                        </div>

                    </div>
                </div>

            </div>
        </section>
        <!-- /.content -->
    </div>
</div>