<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Administrator Log in | <?php echo $app_setting->application_name ?></title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>css/adminlte.min.css">
 <script src="<?php echo admin_css() ?>plugins/sweetalert/sweetalert2.all.min.js"></script>

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>

<body class="hold-transition login-page">
  <?php
$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
   <script>
      swal("Oops", "<?php echo $errors ?>", "error")
   </script>
   <?php echo $errors ?>
<?php
   $this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
   <script>
      swal("Oops", "<?php echo $error ?>", "error")
   </script>
<?php
   $this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
   <script>
      swal({
         title: "Done!",
         text: "<?php echo $success ?>",
         icon: "success",
      });
   </script>
<?php
   $this->session->unset_userdata('success');
}
?>
<div class="login-box">
  <!-- /.login-logo -->
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="<?php echo base_url() ?>" class="h1"><b><?php echo $app_setting->application_name ?></b></a>
    </div>
    
    <div class="card-body">
      <?php echo form_open(base_url().'login/admin_login'); ?>
        <div id="email_login_form">
          <p class="login-box-msg">Sign in with Email ID & Password</p>
            <div class="input-group mb-3">
              <input type="number" name="mobile" class="form-control" placeholder="Enter Mobile No" id="inputEmail" required="">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-phone"></span>
                </div>
              </div>
            </div>
            <div class="input-group mb-3">
              <input type="password" class="form-control" placeholder="Enter Password" name="password" id="inputPassword" required="">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-lock"></span>
                </div>
              </div>
            </div>
          <div class="social-auth-links text-center mt-2 mb-3">
            <button type="submit" name="sign_in" class="btn btn-primary btn-block">Sign In</button>
          </div>
        </div>
      <!-- /.social-auth-links -->
      </form>
      <p class="mb-1">
        <a href="forgot-password.html">I forgot my password</a>
      </p>
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</div>

<!-- /.login-box -->
<!-- jQuery -->
<script src="<?php echo admin_css() ?>plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo admin_css() ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo admin_css() ?>js/adminlte.min.js"></script>
</body>
</html>
