<div class="container bg-light course_details_nav">
    <div class="row">
        <div class="col-lg-12 col-md-12 mt-5">
            <div class="section-title text-center">
                <h2><?php echo $heading['title']; ?></h2>
                <p class="fs-22 lead"><?php echo $heading['sub_title']; ?></p>
            </div>
        </div>
        <div class="col-xl-12 col-lg-12 col-md-12">
            <div class="border-0 mb-5 br-7 course-details">
                <!-- Tabs Menu -->
                <div class="wideget-user-tab wideget-user-tab3 br-7 mb-3">
                    <div class="tab-menu-heading bg-white">
                        <div class="tabs-menu1">
                            <ul class="nav mx-3" role="tablist">
                                <?php
                                $all_course_faq = json_decode($course->course_faq, true);
                                $firstActive = true;
                                $tabIndex = 1;

                                foreach ($all_course_faq as $category) : ?>
                                    <li class="ms-0" role="presentation">
                                        <a href="#faq-tab-<?php echo $tabIndex; ?>" class="nav-link <?php echo $firstActive ? 'active' : ''; ?>" id="faq-tab-<?php echo $tabIndex; ?>-tab" data-bs-toggle="tab" role="tab" aria-controls="faq-tab-<?php echo $tabIndex; ?>" aria-selected="<?php echo $firstActive ? 'true' : 'false'; ?>">
                                            <?php echo $category['category']; ?>
                                        </a>
                                    </li>
                                <?php
                                    $firstActive = false;
                                    $tabIndex++;
                                endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Tabs Content -->
                <div class="tab-content details-tab-content pt-5">
                    <?php
                    $firstActive = true;
                    $tabIndex = 1;

                    foreach ($all_course_faq as $category) : ?>
                        <div class="tab-pane fade <?php echo $firstActive ? 'show active' : ''; ?>" id="faq-tab-<?php echo $tabIndex; ?>" role="tabpanel" aria-labelledby="tab-<?php echo $tabIndex; ?>-tab">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="panel-group1" id="accordion<?php echo $tabIndex; ?>">
                                        <?php
                                        $faqIndex = 1;
                                        foreach ($category['faqs'] as $faq) : ?>
                                            <div class="panel panel-default mb-4 border p-0">
                                                <div class="panel-heading1">
                                                    <h4 class="panel-title1">
                                                        <a class="accordion-toggle collapsed" data-bs-toggle="collapse" data-parent="#accordion<?php echo $tabIndex; ?>" href="#faq_<?php echo $tabIndex . '_' . $faqIndex; ?>" aria-expanded="false">
                                                            <?php echo $faqIndex . '. ' . $faq['qns']; ?>
                                                        </a>
                                                    </h4>
                                                </div>
                                                <div id="faq_<?php echo $tabIndex . '_' . $faqIndex; ?>" class="panel-collapse collapse" role="tabpanel">
                                                    <div class="panel-body bg-white">
                                                        <p><?php echo $faq['ans']; ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php
                                            $faqIndex++;
                                        endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php
                        $firstActive = false;
                        $tabIndex++;
                    endforeach; ?>
                </div>
            </div>
        </div>

    </div>
</div>

<style>
    .course-details .wideget-user-tab.wideget-user-tab3 .tabs-menu1 ul li a {
  border-radius: 7px 7px 0 0;
  color: #000;
}
</style>