<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<?php
$is_purchased = false;
$is_session  = false;
if ($this->session->userdata('bcount_sess_logged_in') === true) {
    $is_purchased = $this->course_model->course_is_purchased($this->session->userdata('bcount_sess_id'), $course->course_id);
    $is_session  = true;
}

if ($is_session) {
    $url_fbt = base_url('course/fbt_buy/' . $course->course_id);
} else {
    $url_fbt = base_url() . 'register/fbt_course/' . $course->course_slug . '/' . $course->course_id;
}

$this->db->where('id', $course->course_category);
$cat_details_main_course = $this->db->get('category')->row();

?>
<!-- Section For Desktop Version Start-->
<div>
    <div class="course-header" style="background-color: #10264f ;">
        <div class="header-text1 mb-0">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 col-lg-7 col-md-12">
                        <div class="text-center">
                            <h4 class="display-7 font-weight-semibold text-white mb-5 main-sub-heading"><?php echo $course->course_sub_heading; ?></h4>

                            <h1 class="text-white display-5 font-weight-semibold"><?php echo $course->course_heading; ?></h1>
                            <p class="text-white lead"> <?php echo $course->course_sub_heading_2; ?></p>
                            <div class="d-block d-md-flex align-items-center mb-5 justify-content-center">

                                <a href="javascript:void(0)" class="text-white">
                                    <i class="fe fe-clock text-dark-50 me-2"></i>
                                    <?php echo date('d-M-Y', strtotime($course->course_added_date)); ?></a>

                                <a href="javascript:void(0)" class="text-white ms-3">
                                    <i class="fa fa-refresh text-dark-50 me-1"></i>
                                    <?php echo date('d-M-Y', strtotime($course->course_update_date)); ?></a>

                                <span class="text-white ms-3">
                                    <i class="fe fe-user text-white"></i>
                                    <?php echo $this->course_model->enrol_history($course->course_id)->num_rows(); ?> Enrolled
                                </span>
                                <span class="ms-4">
                                    <?php
                                    $total_rating = $this->course_model->get_ratings('course', $course->course_id, true)->row()->rating;
                                    $number_of_ratings = $this->course_model->get_ratings('course', $course->course_id)->num_rows();
                                    if ($number_of_ratings > 0) {
                                        $average_ceil_rating = ceil($total_rating / $number_of_ratings);
                                    } else {
                                        $average_ceil_rating = 0;
                                    }

                                    for ($i = 1; $i <= 5; $i++) {
                                        if ($i <= $average_ceil_rating) {
                                            echo '<i class="fa fa-star text-warning"></i>';
                                        } else {
                                            echo '<i class="fa fa-star text-secondary"></i>';
                                        }
                                    }
                                    ?>
                                    <span class="text-white">(<?= $number_of_ratings ?>)</span>
                                </span>


                                <span class="text-white ms-3">
                                    <i class="fe fe-book text-white"></i>
                                    <?php echo $this->course_model->get_lessons('course', $course->course_id)->num_rows(); ?> Lectures
                                </span>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div><!-- /header-text -->
    </div>
</div>
<div class="relative">
    <div class="shape overflow-hidden text-white shape-inner"> <svg viewBox="0 0 2880 48" fill="none" xmsns="http://www.w3.org/2000/svg">
            <path d="M0 48H1437.5H2880V0H2160C1442.5 52 720 0 720 0H0V48Z" fill="#f5f4f9"></path>
        </svg>
    </div>
</div>
<!-- Section For Desktop Version End-->

<section class="sptb" id="get_certified">
    <div class="container">
        <div class="row" data-sticky-container style="position: relative;">
            <div class="col-xl-8 col-lg-8 col-md-12 order-2 order-md-1">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Description</h3>
                    </div>
                    <div class="card-body">
                        <?php echo $course->course_theme_heading; ?>
                    </div>
                </div>
                <style>
                    .bundle-course-card {
                        display: flex;
                        border-radius: 15px;
                        overflow: hidden;
                        background: #fff;
                        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
                        margin-bottom: 20px;
                    }

                    .bundle-course-card .course-icon {
                        background: linear-gradient(170deg,rgba(235, 9, 9, 1) 0%, rgba(16, 38, 79, 1) 100%);
                        color: #fff;
                        width: 100px;
                        display: flex;
                        justify-content: center;
                        align-items: center;
                        font-size: 2rem;
                        flex-shrink: 0;
                    }

                    .bundle-course-card .course-content {
                        padding: 20px;
                        flex: 1;
                    }

                    .bundle-course-card .course-title {
                        font-weight: 600;
                        font-size: 1.2rem;
                    }

                    .bundle-course-card .duration {
                        color: #666;
                        font-size: 0.9rem;
                        margin-bottom: 15px;
                    }

                    .bundle-course-card .btn-curriculum {
                        border: 1px solid #EB0909;
                        border-radius: 25px;
                        color: #EB0909;
                        padding: 6px 18px;
                        font-weight: 500;
                        text-decoration: none;
                        transition: 0.3s;
                    }

                    .bundle-course-card .btn-curriculum:hover {
                        background: #10264F;
                        color: #fff;
                        border: 1px solid #10264F;
                    }
                </style>

                <?php if ($course->course_fbt):
                    $fbt_course = json_decode($course->course_fbt);
                    if (is_array($fbt_course)): ?>

                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Curriculum</h3>
                            </div>
                        </div>
                        <div class="container">
                            <div class="row">
                                <?php
                                $total_lession = 0;
                                $aa = 1;
                                foreach ($fbt_course as $key => $fbt):
                                    $this->db->where('course_id', $fbt);
                                    $fbtCourse = $this->db->get('course_new')->row();

                                    $this->db->where('id', $fbtCourse->course_category);
                                    $cat_details = $this->db->get('category')->row();

                                    $total_lession = 0;
                                    $sections = $this->course_model->get_section('course', $fbt)->result_array();
                                    foreach ($sections as $key => $section) {
                                        $total_lession += $this->course_model->get_lessons('section', $section['id'])->num_rows();
                                    }

                                ?>
                                    <div class="col-md-6">
                                        <div class="bundle-course-card">
                                            <div class="course-icon"><?php echo $aa; ?></div>
                                            <div class="course-content">
                                                <div class="course-title"><?php echo $fbtCourse->course_heading; ?></div>
                                                <div class="duration"><i class="far fa-clock"></i> Lession : <?php echo $total_lession; ?></div>
                                                <a href="javascript:void(0)" onclick="open_model_curriculum_model('<?php echo $fbt; ?>', '<?php echo $fbtCourse->course_heading; ?>')" class="btn-curriculum"><i class="fas fa-eye"></i> Curriculum</a>
                                            </div>
                                        </div>
                                    </div>
                                <?php $aa++; endforeach; ?>
                            </div>
                        </div>
                <?php endif;
                endif; ?>

                <script>
                    function open_model_curriculum_model(id, name) {

                        $.ajax({
                            type: "GET",
                            url: "<?php echo base_url(); ?>home/get_course_curriculum/" + id,
                            success: function(response) {
                                $('#fullScreenModalLabel').html(name);
                                $('#cur_data').html(response);
                                $('#fullScreenModal').modal('show');
                            }
                        });


                    }
                </script>
                <style>
                    .modal-dialog.modal-fullscreen {
                        width: 100%;
                        max-width: 100%;
                        height: 100%;
                        margin: 0;
                        padding: 0;
                    }

                    .btn-modal-close {
                        background: #fff;
                        border: 0;
                        font-size: 30px;
                        color: red;
                        line-height: 0;

                    }

                    .panel-colored {
                        box-shadow: rgba(128, 0, 128, 0.12) 0px 1.5px 7px;
                        background: #7530e40d;
                        border-radius: 5px;
                        box-shadow: 0 1.5px 7px #0000001f;
                        box-sizing: border-box;
                        cursor: pointer;
                        flex-direction: column;
                        height: fit-content;
                        justify-content: space-between;
                    }
                </style>

                <div class="modal fade" id="fullScreenModal" tabindex="-1" aria-labelledby="fullScreenModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-fullscreen">
                        <div class="modal-content">
                            <div class="modal-header" style="box-shadow: 0 4px 5px #00000040;">
                                <h5 class="modal-title" id="fullScreenModalLabel"></h5>
                                <span type="button" class="btn-modal-close" data-bs-dismiss="modal" aria-label="Close"><i class="fa fa-times"></i></span>
                            </div>
                            <div class="modal-body">
                                <div class="container">
                                    <div class="row justify-content-center">
                                        <div class="col-sm-9" id="cur_data">

                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Outcome</h3>
                    </div>
                    <div class="card-body pt-0">
                        <ul class="step-down">
                            <?php
                            $who_this_for_data = json_decode($course->course_who_this_for, true);
                            foreach ($who_this_for_data as $who_this_for) : ?>
                                <li><?php echo $who_this_for; ?></li>
                            <?php endforeach; ?>

                        </ul>
                    </div>
                </div>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Requirements</h3>
                    </div>
                    <div class="card-body">
                        <ul class="course-description requirements">
                            <?php
                            $who_this_for_data = json_decode($course->course_who_this_for, true);
                            foreach ($who_this_for_data as $who_this_for) : ?>
                                <li><?php echo $who_this_for; ?></li>
                            <?php endforeach; ?>

                        </ul>
                    </div>
                </div>




                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Ratings</h3>
                    </div>
                    <div class="card-body">
                        <?php
                        $total_rating =  $this->course_model->get_ratings('course', $course->course_id, true)->row()->rating;
                        $number_of_ratings = $this->course_model->get_ratings('course', $course->course_id)->num_rows();
                        $average_ceil_rating = ($number_of_ratings > 0) ? ceil($total_rating / $number_of_ratings) : 0;

                        $five_star = $this->course_model->get_percentage_of_specific_rating(5, 'course', $course->course_id);
                        $four_star = $this->course_model->get_percentage_of_specific_rating(4, 'course', $course->course_id);
                        $three_star = $this->course_model->get_percentage_of_specific_rating(3, 'course', $course->course_id);
                        $two_star = $this->course_model->get_percentage_of_specific_rating(2, 'course', $course->course_id);
                        $one_star = $this->course_model->get_percentage_of_specific_rating(1, 'course', $course->course_id);
                        ?>

                        <div class="row">
                            <div class="col-xl-4 text-center my-auto border-end">
                                <div class="ratings-view">
                                    <h1 class="text-view mb-0 font-weight-semibold fs-60"><?php echo number_format($total_rating / ($number_of_ratings ?: 1), 1); ?></h1>
                                    <p class="mb-0 font-weight-bold">Out Of 5.0</p>
                                    <p class="text-warning mb-0">
                                        <?php for ($i = 1; $i <= 5; $i++): ?>
                                            <?php if ($i <= $average_ceil_rating): ?>
                                                <i class="fa fa-star"></i>
                                            <?php else: ?>
                                                <i class="fa fa-star-o"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </p>
                                </div>
                            </div>
                            <div class="col-xl-8 my-auto">
                                <div class="ps-0 ps-md-5">
                                    <?php
                                    $ratings = [
                                        ['label' => '5stars', 'value' => $five_star],
                                        ['label' => '4stars', 'value' => $four_star],
                                        ['label' => '3stars', 'value' => $three_star],
                                        ['label' => '2stars', 'value' => $two_star],
                                        ['label' => '1stars', 'value' => $one_star],
                                    ];
                                    foreach ($ratings as $rating):
                                    ?>
                                        <div class="row">
                                            <div class="col-sm-2 col-4"> <span class="font-weight-semibold"><?php echo $rating['label']; ?></span> </div>
                                            <div class="col-sm-8 col-4">
                                                <div class="progress mb-2 mt-2 h-2">
                                                    <div class="progress-bar bg-primary" style="width: <?php echo $rating['value']; ?>%;"></div>
                                                </div>
                                            </div>
                                            <div class="col-sm-2 col-4"> <span>(<?php echo $rating['value']; ?>%)</span> </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Reviews</h3>
                    </div>
                    <div class="card-body">
                        <?php $ratingsData = $this->course_model->get_ratings('course', $course->course_id)->result_array();
                        if ($ratingsData) : ?>
                            <?php foreach ($ratingsData as $rating) :
                                $this->db->where('id', $rating['user_id']);
                                $rating_student = $this->db->get('users')->row();
                            ?>
                                <div class="media mt-0 p-5 border br-7 review-media">
                                    <div class="d-flex me-3">
                                        <a href="javascript:void(0)">
                                            <img class="media-object brround avatar-lg" alt="<?php echo $rating_student->user_name; ?>" src="<?php echo base_url() . $rating_student->user_photo; ?>">
                                        </a>
                                    </div>
                                    <div class="media-body">
                                        <h4 class="mt-0 mb-1 font-weight-semibold">
                                            <?php echo $rating_student->user_name; ?>
                                            <small class="text-muted fs-14 float-end">
                                                <?php echo date('d M Y', $rating['date_added']); ?>
                                            </small>
                                        </h4>
                                        <span class="fs-14">
                                            <?php
                                            $fullStars = floor($rating['rating']);
                                            $hasHalfStar = ($rating['rating'] - $fullStars) >= 0.5;

                                            for ($i = 1; $i <= 5; $i++) {
                                                if ($i <= $fullStars) {
                                                    echo '<i class="fa fa-star text-yellow"></i>';
                                                } elseif ($hasHalfStar && $i == $fullStars + 1) {
                                                    echo '<i class="fa fa-star-half-o text-yellow"></i>';
                                                } else {
                                                    echo '<i class="fa fa-star-o text-yellow"></i>';
                                                }
                                            }
                                            ?>
                                        </span>
                                        <p class="font-13 fs-15 mb-2 mt-2">
                                            "<?php echo $rating['review']; ?>"
                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="media mt-0 p-5 review-media">
                                <div class="d-flex me-3">
                                    <h4>No Review Found</h4>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>



                <?php if ($course->course_fbt):
                    $fbt_course = json_decode($course->course_fbt);
                    if (is_array($fbt_course) && $course->course_fbt_price): ?>
                        <div class="card">
                            <div class="card-header">
                                <h3 class="card-title">Frequently Bought Together</h3>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12 mb-4">
                                        <div class="d-flex">
                                            <div>
                                                <?php if ($course->course_small_image): ?>
                                                    <img src="<?= base_url($course->course_small_image); ?>" alt="<?= $course->course_heading; ?>" class="img-fluid mb-2" style="max-height: 100px;">
                                                <?php else: ?>
                                                    <img src="<?= base_url($course->course_image); ?>" alt="<?= $course->course_heading; ?>" class="img-fluid mb-2" style="max-height: 100px;">
                                                <?php endif; ?>

                                            </div>
                                            <div class="ms-3 d-flex">
                                                <div>
                                                    <h5><strong><?= $course->course_heading; ?></strong></h5>
                                                    <p class="mb-1"><?php echo mb_strimwidth($course->course_sub_heading_2, 0, 50, "...") ?></p>
                                                    <?php
                                                    if ($cat_details_main_course->price) {
                                                        $course_main_price = $cat_details_main_course->price; ?>
                                                        <div class="mt-1">
                                                            <strong>₹<?= $cat_details_main_course->price; ?></strong>
                                                            <del class="text-muted">₹<?= $course->course_online_main_price; ?></del>
                                                        </div>
                                                    <?php } elseif ($course->course_onine_dicount_price) {
                                                        $course_main_price = $course->course_onine_dicount_price; ?>
                                                        <div class="mt-1">
                                                            <strong>₹<?= $course->course_onine_dicount_price; ?></strong>
                                                            <del class="text-muted">₹<?= $course->course_online_main_price; ?></del>
                                                        </div>
                                                    <?php } else {
                                                        $course_main_price = $course->course_online_main_price; ?>
                                                        <div class="mt-1">
                                                            <strong>₹<?= $course->course_online_main_price; ?></strong>
                                                        </div>
                                                    <?php }; ?>

                                                    <div class="mt-1">
                                                        <?php
                                                        $total_rating_fbt = $this->course_model->get_ratings('course', $course->course_id, true)->row()->rating;
                                                        $number_of_ratings_fbt = $this->course_model->get_ratings('course', $course->course_id)->num_rows();
                                                        if ($number_of_ratings_fbt > 0) {
                                                            $average_ceil_rating_fbt = ceil($total_rating_fbt / $number_of_ratings_fbt);
                                                        } else {
                                                            $average_ceil_rating_fbt = 0;
                                                        }

                                                        for ($i = 1; $i <= 5; $i++) {
                                                            if ($i <= $average_ceil_rating_fbt) {
                                                                echo '<i class="fa fa-star text-warning"></i>';
                                                            } else {
                                                                echo '<i class="fa fa-star text-secondary"></i>';
                                                            }
                                                        }
                                                        ?>
                                                        <span class="mt-1">(<?= $number_of_ratings_fbt ?>)</span>
                                                    </div>
                                                </div>
                                                <div class="join-button"><i class="fa fa-plus"></i></div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                    $total_price = 0;
                                    $original_price = 0;
                                    $cat_price = 0;
                                    foreach ($fbt_course as $key => $fbt):
                                        $this->db->where('course_id', $fbt);
                                        $fbtCourse = $this->db->get('course_new')->row();

                                        $this->db->where('id', $fbtCourse->course_category);
                                        $cat_details = $this->db->get('category')->row();

                                        if ($cat_details->price) {
                                            $cat_price += $cat_details->price;
                                            $total_price += $fbtCourse->course_online_main_price;
                                        } elseif ($fbtCourse->course_onine_dicount_price) {
                                            $total_price += $fbtCourse->course_onine_dicount_price;
                                        } else {
                                            $total_price += $fbtCourse->course_online_main_price;
                                        }
                                    ?>
                                        <div class="col-md-12 <?php if ($key !== array_key_last($fbt_course)): ?> mb-4 <?php endif; ?>">
                                            <div class="d-flex">
                                                <div>
                                                    <?php if ($fbtCourse->course_small_image): ?>
                                                        <img src="<?= base_url($fbtCourse->course_small_image); ?>" alt="<?= $fbtCourse->course_heading; ?>" class="img-fluid mb-2" style="max-height: 100px;">
                                                    <?php else: ?>
                                                        <img src="<?= base_url($fbtCourse->course_image); ?>" alt="<?= $fbtCourse->course_heading; ?>" class="img-fluid mb-2" style="max-height: 100px;">
                                                    <?php endif; ?>

                                                </div>
                                                <div class="ms-3 d-flex">
                                                    <div>
                                                        <h5><strong><?= $fbtCourse->course_heading; ?></strong></h5>
                                                        <p class="mb-1"><?php echo mb_strimwidth($fbtCourse->course_sub_heading_2, 0, 50, "...") ?></p>
                                                        <?php
                                                        if ($cat_details->price) { ?>
                                                            <div class="mt-1">
                                                                <strong>₹<?= $cat_details->price; ?></strong>
                                                                <del class="text-muted">₹<?= $fbtCourse->course_online_main_price; ?></del>
                                                            </div>
                                                        <?php } elseif ($fbtCourse->course_onine_dicount_price) { ?>
                                                            <div class="mt-1">
                                                                <strong>₹<?= $fbtCourse->course_onine_dicount_price; ?></strong>
                                                                <del class="text-muted">₹<?= $fbtCourse->course_online_main_price; ?></del>
                                                            </div>
                                                        <?php } else { ?>
                                                            <div class="mt-1">
                                                                <strong>₹<?= $fbtCourse->course_online_main_price; ?></strong>
                                                            </div>
                                                        <?php }; ?>

                                                        <div class="mt-1">
                                                            <?php
                                                            $total_rating_fbt = $this->course_model->get_ratings('course', $fbtCourse->course_id, true)->row()->rating;
                                                            $number_of_ratings_fbt = $this->course_model->get_ratings('course', $fbtCourse->course_id)->num_rows();
                                                            if ($number_of_ratings_fbt > 0) {
                                                                $average_ceil_rating_fbt = ceil($total_rating_fbt / $number_of_ratings_fbt);
                                                            } else {
                                                                $average_ceil_rating_fbt = 0;
                                                            }

                                                            for ($i = 1; $i <= 5; $i++) {
                                                                if ($i <= $average_ceil_rating_fbt) {
                                                                    echo '<i class="fa fa-star text-warning"></i>';
                                                                } else {
                                                                    echo '<i class="fa fa-star text-secondary"></i>';
                                                                }
                                                            }
                                                            ?>
                                                            <span class="mt-1">(<?= $number_of_ratings_fbt ?>)</span>
                                                        </div>
                                                    </div>

                                                    <?php if ($key !== array_key_last($fbt_course)): ?>
                                                        <div class="join-button"><i class="fa fa-plus"></i></div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>

                                <hr>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h4>
                                            <?php if ($cat_price): ?>
                                                <strong>Total: ₹<?= $cat_price + $course_main_price; ?></strong>
                                            <?php else: ?>
                                                <strong>Total: ₹<?= $course->course_fbt_price; ?></strong>
                                            <?php endif; ?>

                                            <del class="text-muted">₹<?= $total_price; ?></del>
                                        </h4>
                                    </div>
                                    <a href="javascript:void(0)" onclick="add_to_all_cart()" class="btn btn-primary"><i class="fa fa-shopping-cart"></i> Add all to cart</a>
                                </div>
                            </div>
                        </div>
                <?php endif;
                endif; ?>


            </div> <!--Right Side Content-->

            <div class="col-xl-4 col-lg-4 col-md-12order-1 mt-lg-n23  order-md-2 ">
                <!-- <div class="col-xl-4 col-lg-4 col-md-12order-1 order-md-2 " > -->
                <!-- <div class="sticky"> -->
                <div class="card " data-margin-top="100" data-sticky-class="is-sticky">
                    <div class="card-body mb-0">

                        <div class="product-slider">
                            <ul class="list-unstyled video-list-thumbs">
                                <li class="mb-0">
                                    <a data-bs-toggle="modal" data-bs-target="#homeVideo" class="class-video p-0">
                                        <img src="<?php echo base_url(); ?><?php echo $course->course_image; ?>" alt="img" class="img-responsive  border br-7">
                                        <span class="video-icon" href="javascript:void(0)">
                                        </span>
                                    </a>
                                </li>
                            </ul>
                        </div>


                        <?php
                        $main_price = 0;
                        if (!$is_purchased): ?>
                            <div class="mt-4 mb-4 text-center">
                                <?php if ($course->course_is_free == 1):
                                    $main_price = 0; ?>
                                    <!-- Free Course -->
                                    <div class="mb-2">
                                        <span class="font-weight-semibold h2 mb-0 text-success">
                                            Free
                                            <span class="ms-1 font-weight-normal fs-16 strike-text text-default">
                                                ₹<?php echo number_format($course->course_online_main_price); ?>
                                            </span>
                                        </span>
                                    </div>
                                    <span class="d-block">
                                        <p class="mb-0 fs-14">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fa fa-star<?php echo $i <= 4 ? ' text-yellow me-0' : '-o text-yellow me-2'; ?>"></i>
                                            <?php endfor; ?>
                                            <a href="javascript:void(0)" class="icons h4 font-weight-semibold text-dark">
                                                <span>4.0</span>
                                            </a>
                                        </p>
                                    </span>
                                    <p class="text-success font-weight-semibold mb-0 mt-1">
                                        Save ₹<?php echo number_format($course->course_online_main_price); ?>/-
                                    </p>
                                    <?php
                                    // if ($is_session) {
                                    //     $url = base_url() . 'course/enrolement/' . $course->course_slug . '/' . $course->course_id;
                                    // } else {
                                    //     $url = base_url() . 'register/course/' . $course->course_slug . '/' . $course->course_id;
                                    // }
                                    ?>
                                    <div class="mt-3">
                                        <a href="javascript:void(0)" class="btn btn-block btn-secondary">
                                            <span>Add To Cart</span>
                                            <i class="fe fe-arrow-right mt-1 ms-2 fs-14"></i>
                                        </a>
                                    </div>
                                <?php

                                elseif (!empty($cat_details_main_course) && $cat_details_main_course->price):
                                    $main_price = number_format($cat_details_main_course->price); ?>

                                    <div class="mb-2">
                                        <span class="font-weight-semibold h2 text-default-dark mb-0">
                                            ₹<?php echo number_format($cat_details_main_course->price); ?>
                                            <span class="ms-1 font-weight-normal fs-16 strike-text text-default">
                                                ₹<?php echo number_format($course->course_online_main_price); ?>
                                            </span>
                                        </span>
                                    </div>
                                    <span class="d-block">
                                        <p class="mb-0 fs-14">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fa fa-star<?php echo $i <= 4 ? ' text-yellow me-0' : '-o text-yellow me-2'; ?>"></i>
                                            <?php endfor; ?>
                                            <a href="javascript:void(0)" class="icons h4 font-weight-semibold text-dark">
                                                <span>4.0</span>
                                            </a>
                                        </p>
                                    </span>
                                    <p class="text-success font-weight-semibold mb-0 mt-1">
                                        Save ₹<?php echo number_format($course->course_online_main_price - $cat_details->price); ?>/-
                                    </p>
                                    <?php
                                    // if ($is_session) {
                                    //     $url = 'javascript:void(0)';
                                    //     $java_code = 'onclick="add_to_cart(' . $course->course_id . ')"';
                                    // } else {
                                    //     $url = base_url() . 'register/course/' . $course->course_slug . '/' . $course->course_id;
                                    //     $java_code = '';
                                    // }
                                    ?>
                                    <div class="mt-3">
                                        <a href="javascript:void(0)" onclick="add_to_cart(<?php echo $course->course_id; ?>)" class="btn btn-block btn-primary">
                                            <span>Add To Cart</span>
                                            <i class="fe fe-shopping-cart mt-1 ms-2 fs-14"></i>
                                        </a>
                                    </div>

                                <?php elseif ($course->course_onine_dicount_price > 0):
                                    $main_price = number_format($course->course_onine_dicount_price); ?>
                                    <!-- Discounted Course -->
                                    <div class="mb-2">
                                        <span class="font-weight-semibold h2 text-default-dark mb-0">
                                            ₹<?php echo number_format($course->course_onine_dicount_price); ?>
                                            <span class="ms-1 font-weight-normal fs-16 strike-text text-default">
                                                ₹<?php echo number_format($course->course_online_main_price); ?>
                                            </span>
                                        </span>
                                    </div>
                                    <span class="d-block">
                                        <p class="mb-0 fs-14">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fa fa-star<?php echo $i <= 4 ? ' text-yellow me-0' : '-o text-yellow me-2'; ?>"></i>
                                            <?php endfor; ?>
                                            <a href="javascript:void(0)" class="icons h4 font-weight-semibold text-dark">
                                                <span>4.0</span>
                                            </a>
                                        </p>
                                    </span>
                                    <p class="text-success font-weight-semibold mb-0 mt-1">
                                        Save ₹<?php echo number_format($course->course_online_main_price - $course->course_onine_dicount_price); ?>/-
                                    </p>
                                    <?php
                                    // if ($is_session) {
                                    //     $url = 'javascript:void(0)';
                                    //     $java_code = 'onclick="add_to_cart(' . $course->course_id . ')"';
                                    // } else {
                                    //     $url = base_url() . 'register/course/' . $course->course_slug . '/' . $course->course_id;
                                    //     $java_code = '';
                                    // }
                                    ?>
                                    <div class="mt-3">
                                        <a href="javascript:void(0)" onclick="add_to_cart(<?php echo $course->course_id; ?>)" class="btn btn-block btn-primary">
                                            <span>Add To Cart</span>
                                            <i class="fe fe-shopping-cart mt-1 ms-2 fs-14"></i>
                                        </a>
                                    </div>

                                <?php else:
                                    $main_price = number_format($course->course_online_main_price); ?>
                                    <!-- Regular Paid Course -->
                                    <div class="mb-2">
                                        <span class="font-weight-semibold h2 text-default-dark mb-0">
                                            ₹<?php echo number_format($course->course_online_main_price); ?>
                                        </span>
                                    </div>
                                    <span class="d-block">
                                        <p class="mb-0 fs-14">
                                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                                <i class="fa fa-star<?php echo $i <= 4 ? ' text-yellow me-0' : '-o text-yellow me-2'; ?>"></i>
                                            <?php endfor; ?>
                                            <a href="javascript:void(0)" class="icons h4 font-weight-semibold text-dark">
                                                <span>4.0</span>
                                            </a>
                                        </p>
                                    </span>
                                    <?php
                                    // if ($is_session) {
                                    //     $url = 'javascript:void(0)';
                                    //     $java_code = 'onclick="add_to_cart(' . $course->course_id . ')"';
                                    // } else {
                                    //     $url = base_url() . 'register/course/' . $course->course_slug . '/' . $course->course_id;
                                    //     $java_code = '';
                                    // }
                                    ?>
                                    <div class="mt-3">
                                        <a href="javascript:void(0)" onclick="add_to_cart(<?php echo $course->course_id; ?>)" class="btn btn-block btn-primary">
                                            <span>Add To Cart</span>
                                            <i class="fe fe-shopping-cart mt-1 ms-2 fs-14"></i>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>

                        <?php else: ?>
                            <!-- Already Purchased -->
                            <div class="mt-4 mb-4 text-center">
                                <div class="mb-2">
                                    <span class="font-weight-semibold h2 text-success mb-0">Already Purchased</span>
                                </div>
                                <div class="mt-3">
                                    <a href="<?php echo base_url(); ?>admin/admin/lesson/<?php echo $course->course_slug; ?>/<?php echo $course->course_id; ?>" class="btn btn-block btn-success">
                                        <span>Go to My Courses</span>
                                        <i class="fe fe-check-circle mt-1 ms-2 fs-14"></i>
                                    </a>
                                </div>
                            </div>
                        <?php endif; ?>


                    </div>

                </div>
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Course Info</h3>
                    </div>
                    <div class="card-body ">
                        <table style="line-height:2.5">
                            <tbody>
                                <tr>
                                    <td><span class="fs-14 font-weight-bold text-default-dark">Video</span></td>
                                    <td class="w-10 text-center"><span class="">:</span></td>
                                    <td><span class="fs-14 font-weight-normal"><?php echo $this->course_model->get_total_duration_of_lesson_by_course_id($course->course_id); ?></span></td>
                                </tr>
                                <tr>
                                    <td><span class="fs-14 font-weight-bold text-default-dark">Lession</span></td>
                                    <td class="w-10 text-center"><span class="">:</span></td>
                                    <td><span class="fs-14 font-weight-normal"><?php echo $this->course_model->get_lessons('course', $course->course_id)->num_rows(); ?></span></td>
                                </tr>
                                <tr>
                                    <td><span class="fs-14 font-weight-bold text-default-dark">Course Level</span></td>
                                    <td class="w-10 text-center"><span class="">:</span></td>
                                    <td><span class="fs-14 font-weight-normal"><?php echo ucfirst($course->course_level); ?></span></td>
                                </tr>
                                <tr>
                                    <td><span class="fs-14 font-weight-bold text-default-dark">Course Validity</span></td>
                                    <td class="w-10 text-center"><span class="">:</span></td>
                                    <td><span class="fs-14 font-weight-normal">
                                            <?php if ($course->course_validity == 1) {
                                                echo 'Lifetime';
                                            }
                                            if ($course->course_validity == 2) {
                                                echo '1 Year';
                                            } ?>
                                        </span></td>
                                </tr>
                                <tr>
                                    <td><span class="fs-14 font-weight-bold text-default-dark">Access On Mobile And Tv</span></td>
                                    <td class="w-10 text-center"><span class="">:</span></td>
                                    <td><span class="fs-14 font-weight-normal">Yes</span></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if ($course->course_fbt):
                    if (is_array($fbt_course) && $course->course_fbt_price): ?>
                        <div class="card">
                            <div class="card-header text-center" style="display: grid;">
                                <h3 class="card-title">Frequently Bought Together</h3>
                            </div>
                            <div class="card-body mt-1 pt-1 pb-1">
                                <div class="afternoon-bottom-validity">
                                    <div><i class="fa fa-chart-line" aria-hidden="true"></i> Perfect Combo for Smart Marketers</div>
                                </div>
                            </div>


                            <div class="card-body pt-2">
                                <div class="afternoon-card-middle">
                                    <div class="afternoon-card-company">
                                        <div class="afternoon-card-company-img">
                                            <?php if ($course->course_small_image): ?>
                                                <img src="<?= base_url($course->course_small_image); ?>" alt="<?= $course->course_heading; ?>">
                                            <?php else: ?>
                                                <img src="<?= base_url($course->course_image); ?>" alt="<?= $course->course_heading; ?>">
                                            <?php endif; ?>
                                        </div>
                                        <div>
                                            <h6 class="mt-2"><strong><?= $course->course_heading; ?></strong></h6>
                                        </div>
                                    </div>
                                    <?php
                                    $total_price_fbt_2_category = 0;
                                    $total_price_fbt_2 = 0;
                                    $fbt_course = json_decode($course->course_fbt);
                                    foreach ($fbt_course as $key => $fbt):
                                        $this->db->where('course_id', $fbt);
                                        $fbtCourse = $this->db->get('course_new')->row();

                                        $this->db->where('id', $fbtCourse->course_category);
                                        $cat_details = $this->db->get('category')->row();

                                        if ($cat_details->price) {
                                            $total_price_fbt_2_category += $cat_details->price;
                                            $original_price += $fbtCourse->course_online_main_price;
                                        } else {
                                            $total_price_fbt_2 += $fbtCourse->course_onine_dicount_price;
                                            $original_price += $fbtCourse->course_online_main_price;
                                        }
                                    ?>

                                        <div class="afternoon-card-company">
                                            <div class="afternoon-card-company-img">
                                                <?php if ($fbtCourse->course_small_image): ?>
                                                    <img src="<?= base_url($fbtCourse->course_small_image); ?>" alt="<?= $fbtCourse->course_heading; ?>">
                                                <?php else: ?>
                                                    <img src="<?= base_url($fbtCourse->course_image); ?>" alt="<?= $fbtCourse->course_heading; ?>">
                                                <?php endif; ?>
                                            </div>
                                            <div>
                                                <h6 class="mt-2"><strong><?= $fbtCourse->course_heading; ?></strong></h6>
                                            </div>
                                        </div>

                                    <?php endforeach; ?>
                                </div>
                                <div style="border-top:1px solid #ccc"></div>
                                <div class="text-center border-top-1 mt-3">
                                    <div class="mb-3">
                                        <h4>
                                            <?php if ($cat_price): ?>
                                                <strong>Total: ₹<?= $cat_price + $course_main_price; ?></strong>
                                            <?php else: ?>
                                                <strong>Total: ₹<?= $course->course_fbt_price; ?></strong>
                                            <?php endif; ?>

                                            <del class="text-muted">₹<?= $total_price; ?></del>
                                        </h4>
                                    </div>

                                    <a href="javascript:void(0)" onclick="add_to_all_cart()" class="btn btn-primary w-100">
                                        <i class="fa fa-shopping-cart"></i> Add All To Cart
                                    </a>
                                </div>
                            </div>
                        </div>
                <?php endif;
                endif; ?>
            </div> <!--/Right Side Content-->
        </div>
    </div>
</section>

<style>
    @media screen and (max-width: 768px) {
        .float-s-inner-cont {
            padding: 0px !important;
            gap: 35px !important;
        }

        .flc-course-cont,
        .flc-price-cont {
            font-size: 28px !important;
        }

        .flc-course-cont span,
        .flc-price-cont span {
            font-size: 12px !important;
        }

        .flc-cta {
            font-size: 14px !important;
            padding: 15px 20px !important;
        }

        .stocky_footer_bar {
            padding-right: 0 !important;
            padding-left: 0 !important;
        }
    }

    .flc-cta {
        align-items: center;
        background: #0f2449;
        border-radius: 16px;
        box-sizing: border-box;
        color: #fff;
        display: flex;
        font-size: 24px;
        font-style: normal;
        font-weight: 500;
        gap: 10px;
        justify-content: center;
        letter-spacing: -1.2px;
        line-height: normal;
        padding: 22px 40px;
        text-align: center;
        text-transform: capitalize;
    }

    .float-s-inner-cont {
        display: flex;
        justify-content: space-between;
        gap: 50px;
    }

    .flc-price-cont {
        align-items: center;
        color: #eb0909;
        display: flex;
        flex-direction: column;
        font-size: 42px;
        font-weight: 700;
        letter-spacing: -2.1px;
        line-height: 98%;
    }

    .flc-price-cont span {
        color: #000;
        font-size: 20px;
        font-weight: 400;
        letter-spacing: -1px;
        line-height: normal;
    }

    .flc-course-cont {
        align-items: center;
        color: #000;
        display: flex;
        flex-direction: column;
        font-size: 42px;
        font-weight: 700;
        letter-spacing: -2.1px;
        line-height: 98%;
    }

    .flc-course-cont span {
        color: #000;
        font-size: 20px;
        font-weight: 400;
        letter-spacing: -1px;
        line-height: normal;
    }

    .footer_sticky {
        display: flex;
        justify-content: center;
    }

    .stocky_footer_bar {
        align-items: center;
        background: #fff;
        border-radius: 24px;
        box-shadow: 0 0 10px 5px #455a6440;
        box-sizing: border-box;
        display: flex;
        justify-content: space-between;
        padding: 20px;
        width: 90%;
        max-width: 644px;
        justify-content: center;
        margin-bottom: 20px;
    }

    .pointer:hover {
        color: #fff;
        background: #bc1502;
    }

    #sticky-bar {
        position: fixed;
        bottom: 0;
        z-index: 999;
        width: 100%;
        display: none;
    }
</style>
<?php $this->load->library('cart'); ?>
<div class="customization_popup" role="alert">
    <div class="customization_popup_container">
        <div class="alert alert-success mb-0" role="alert">
            <i class="fa fa-check-circle" aria-hidden="true"></i> Added to your cart!
        </div>
        <a href="javascript:void(0)" class="customization_popup_close img-replace"></a>
        <div class="product-short-cart" id="cartModal_short">
            <table class="table table-image" style="text-align: left;">
                <tbody>
                    <?php
                    $discount = 0;
                    foreach ($this->cart->contents() as $item):
                        // Handle discount separately
                        if (isset($item['options']['type']) && $item['options']['type'] === 'fbt_discount') {
                            $discount += abs($item['price']);
                            continue;
                        }
                    ?>
                        <tr>
                            <td class="w-25">
                                <img src="<?php echo base_url($item['options']['thumbnail']); ?>" class="img-fluid img-thumbnail" alt="Image">
                            </td>
                            <td><?php echo $item['name'] ?><br /> <b>₹<?php echo number_format($item['price'], 2); ?></b></td>

                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <div style="bottom: 0;position: absolute;width: 50^;margin-bottom: 10px;margin-left: 20px;">
            <a href="<?php echo base_url(); ?>cart" class="btn btn-dark btn-md" style="width: 150px;">Checkout</a>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/sticky-js@1.3.0/dist/sticky.min.js"></script>
<script>
    $(document).ready(function() {
        var $stickyBar = $('#sticky-bar');
        var $keyHighlights = $('#get_certified');
        var keyHighlightsOffset = $keyHighlights.offset().top;

        $(window).scroll(function() {
            if ($(window).scrollTop() > keyHighlightsOffset) {
                $stickyBar.fadeIn();
                $('#sticky-wrapper').hide();
            } else {
                $stickyBar.fadeOut();
                $('#sticky-wrapper').show();
            }
        });
    });
    jQuery(document).ready(function($) {
        $('.customization_popup').on('click', function(event) {
            if ($(event.target).is('.customization_popup_close') || $(event.target).is('.customization_popup')) {
                event.preventDefault();
                $(this).removeClass('is-visible');

                // Remove class from body when popup is closed
                $('body').removeClass('popup-open');
            }
        });
        $(document).keyup(function(event) {
            if (event.which == '27') {
                $('.customization_popup').removeClass('is-visible');

                // Remove class from body when popup is closed using keyboard
                $('body').removeClass('popup-open');
            }
        });
    });
    document.addEventListener('DOMContentLoaded', function() {
        var sticky = new Sticky('.sticky');
    });
    <?php if ($course->course_fbt):
        if (is_array($fbt_course) && $course->course_fbt_price): ?>
            let course_ids = <?php echo json_encode($fbt_course); ?>;
            course_ids.push("<?php echo $course->course_id; ?>");

            <?php if ($cat_price): ?>
                let bundle_price = <?= $cat_price + $course_main_price; ?>;
            <?php else: ?>
                let bundle_price = <?= $course->course_fbt_price; ?>;
    <?php endif;
        endif;
    endif;  ?>


    function add_to_all_cart() {
        $.post("<?= base_url('cart/add_fbt_to_cart') ?>", {
            course_ids,
            bundle_price
        }, function(res) {
            let response = JSON.parse(res);
            if (response.status === 'success') {
                swal(
                    "Added to Cart",
                    "Courses Successfully Added in Cart",
                    "success"
                );
                $("#cart_count").load(window.location.href + " #cart_count");
                $('#cartModal_short').load(location.href + ' #cartModal_short');
                $('.customization_popup').addClass('is-visible');
            } else {
                Swal.fire('Error', 'Could not add to cart.', 'error');
            }
        });
    }

    function add_to_cart(id) {
        $.ajax({
            url: '<?= base_url("home/add_to_cart"); ?>',
            type: 'POST',
            data: {
                id: id
            },
            success: function(response) {
                if (response == 1) {
                    swal('Wow!', "Product Successfully Added in Cart", 'success');
                    $("#cart_count").load(window.location.href + " #cart_count");
                    $('#cartModal_short').load(location.href + ' #cartModal_short');
                    $('.customization_popup').addClass('is-visible');
                } else {
                    swal('Oops', "Course Already On Cart", 'error');
                }
            },
            error: function(e) {
                console.log(e.responseText);
                swal('Oops', "Something went wrong. Please try again.", 'error');
            }
        });
    }
</script>



<style>
    .join-button {
        display: flex;
        justify-content: center;
        align-items: center;
        position: absolute;
        inset-inline-start: 75px;
        inset-block-start: 95px;
        block-size: 40px;
        inline-size: 40px;
        box-shadow: 0 4px 8px rgba(6, 17, 118, 0.08), 0 4px 12px rgba(6, 17, 118, 0.24);
        background-color: #0f2449;
        border: 1px solid #0f2449;
        border-radius: 100%;
        z-index: 99;
        color: #fff;
        font-size: 20px;

    }

    .afternoon-bottom-validity {
        border: 1px solid #EB0909;
        border-radius: 10px;
        padding: 8px;
        width: 100%;
        color: #EB0909;
        font-weight: 700;
        text-align: center;
    }

    .afternoon-card-middle {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        /* 2 columns */
        gap: 16px;
        /* spacing between items */
        /* justify-content: center; */
        padding: 10px;
    }

    .afternoon-card-company {
        /* display: flex; */
        align-items: center;
        gap: 12px;
        padding: 8px;
        margin: 0;
        text-align: center;
    }

    .afternoon-card-company-img {
        height: 45px;
        width: 45px;
        overflow: hidden;
        border-radius: 8px;
        background: #fff;
        box-shadow: 0 5.189px 45.795px #3b3b3b2e;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: auto;

    }

    .afternoon-card-company-img>img {
        height: 100%;
        width: 100%;
        object-fit: cover;
        object-position: center;
    }

    @media only screen and (max-width: 600px) {
        .sticky-div {
            display: none;
        }
    }

    #sticky-card {
        position: sticky;
        top: 100px;
        z-index: 99;
    }

    /*  */
    .active,
    .aboutlink a i {
        color: inherit !important;
    }

    ul.requirements {
        list-style: inside !important;
    }

    .course-description {
        line-height: 2;
        font-size: 15px;
    }

    ul.step-down li::before {
        content: "";
        position: absolute;
        width: 1.5px;
        height: calc(100% + 28px);
        background-color: #754ffe58;
        left: -14px;
        top: 8px;
    }

    ul.step-down li::after {
        content: "";
        position: absolute;
        width: 10px;
        height: 10px;
        border-radius: 50%;
        background-color: var(--theme-color-3);
        left: -18px;
        top: 6px;
    }

    ul.step-down li {
        position: relative;
        margin: 20px 10px;
    }

    ul.step-down {
        margin: 0px 8px;
    }

    .ac-lecture li a {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 7px 10px;
        border-radius: 5px;
    }

    .project-count-number {
        background: #0f2449;
        width: 20px;
        height: 20px;
        border-radius: 100%;
        display: flex;
        align-content: center;
        justify-content: center;
        align-items: center;
        color: #fff;
        font-weight: 700;
    }

    @media (max-width: 991.98px) {
        .sticky-element {
            position: static !important;
            top: auto !important;
        }
    }

    .course-header {
        padding-top: 80px;
        padding-bottom: 80px;
    }

    @media only screen and (max-width: 600px) {
        .join-button {
            inset-inline-start: 35px;
            inset-block-start: 85px;
            box-shadow: none;
        }
    }

    .panel-title1 a.collapsed {
        color: #151515;
    }
</style>