<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-12 text-center">
            <div class="demo-buttons">

                <a href="#" class="demo-btn btn-frontend">
                    <span class="btn-glow"></span>
                    <i class="fa fa-desktop"></i> Frontend Demo
                </a>

                <a href="#" class="demo-btn btn-admin"  data-bs-toggle="modal" data-bs-target="#open_model_demo">
                    <span class="btn-glow"></span>
                    <i class="fa fa-cogs"></i> Admin Demo
                </a>

                <a href="#video-section" class="demo-btn btn-video">
                    <span class="btn-glow"></span>
                    <i class="fa fa-play-circle"></i> Video Demo
                </a>

            </div>
        </div>
    </div>
</div>
<style>
    .demo-buttons {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 18px;
    flex-wrap: wrap;
    padding: 10px 0;
}

/* BASE BUTTON */
.demo-btn {
    position: relative;
    display: inline-flex;
    align-items: center;
    gap: 10px;
    padding: 14px 28px;
    border-radius: 50px;
    font-weight: 700;
    text-decoration: none;
    color: #fff;
    font-size: 16px;
    letter-spacing: 0.4px;
    overflow: hidden;
    border: 2px solid rgba(255,255,255,0.25);

    background: rgba(255,255,255,0.08);
    backdrop-filter: blur(6px);

    box-shadow:
        0 10px 25px rgba(0,0,0,0.35),
        inset 0 0 0 1px rgba(255,255,255,0.15);

    transition: all 0.35s ease;
    z-index: 1;
}

/* GRADIENT BORDER SHINE */
.demo-btn::before {
    content: "";
    position: absolute;
    inset: 0;
    background: linear-gradient(120deg, transparent, rgba(255,255,255,0.4), transparent);
    opacity: 0;
    transition: opacity 0.3s ease;
}

/* MOVING GLOW */
.demo-btn .btn-glow {
    position: absolute;
    inset: 0;
    background: radial-gradient(circle at top left, rgba(255,255,255,0.35), transparent 60%);
    opacity: 0.4;
    z-index: -1;
}

/* INDIVIDUAL THEMES */
.btn-frontend {
    background-image: linear-gradient(135deg, #ff0000, #141d39);
}

.btn-admin {
    background-image: linear-gradient(135deg, #141d39, #ff0000);
}

.btn-video {
    background-image: linear-gradient(135deg, #ff0000, #b30000);
}

/* HOVER MAGIC */
.demo-btn:hover {
    transform: translateY(-5px) scale(1.04);
    box-shadow:
        0 18px 40px rgba(0,0,0,0.6),
        0 0 25px rgba(255, 0, 0, 0.45);
}

.demo-btn:hover::before {
    opacity: 1;
}

/* ICON STYLE */
.demo-btn i {
    font-size: 18px;
    filter: drop-shadow(0 2px 6px rgba(0,0,0,0.4));
}

/* ACTIVE CLICK EFFECT */
.demo-btn:active {
    transform: scale(0.98);
}

/* MOBILE */
@media (max-width: 768px) {
    .demo-btn {
        font-size: 14px;
        padding: 12px 22px;
    }
}

</style>