<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Landing Page</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Quicksand:wght@300..700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
</head>

<body>

    <?php include 'slider.php'; ?>
    <?php include 'section_1.php'; ?>
    <?php include 'section_2.php'; ?>
    <?php include 'section_3.php'; ?>
    <?php include 'section_4.php'; ?>
    <?php include 'section_5.php'; ?>
    <?php include 'section_6.php'; ?>
    <?php include 'section_7.php'; ?>
    <?php include 'section_8.php'; ?>
    <?php include 'section_9.php'; ?>

    <div class="modal fade" id="open_model_demo" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content modern-modal">

                <!-- Close Button -->
                <button type="button" class="btn-close modal-close-btn" data-bs-dismiss="modal"></button>

                <div class="modal-body p-4 text-center">

                    <h4 class="modal-title-main mb-1">🎉 Congrats, You're In!</h4>
                    <p class="modal-subtitle mb-4">Complete registration to unlock your Admin Demo</p>

                    <?php echo form_open(base_url() . 'home/request_for_product_admin_demo'); ?>

                    <div class="row g-3 text-start">

                        <div class="col-sm-6">
                            <input type="text" class="form-control modern-input" name="f_name" required placeholder="First Name *">
                        </div>

                        <div class="col-sm-6">
                            <input type="text" class="form-control modern-input" name="l_name" required placeholder="Last Name *">
                        </div>

                        <div class="col-sm-12">
                            <input type="email" class="form-control modern-input" name="prd_adm_email" required placeholder="Email Address *">
                        </div>

                        <div class="col-sm-12">
                            <input type="tel" class="form-control modern-input" name="prd_adm_mobile" required placeholder="Mobile Number *">
                        </div>

                        <input type="hidden" name="prd_adm_prd_id" value="<?php echo $product['prd_id'] ?>">

                        <div class="col-12 mt-3">
                            <button type="submit" class="btn submit-btn w-100">Get Demo Access</button>
                        </div>

                    </div>

                    <?php echo form_close(); ?>

                </div>
            </div>
        </div>
    </div>
    <script>
document.addEventListener("DOMContentLoaded", function () {

    const form = document.querySelector("#open_model_demo form");

    form.addEventListener("submit", function (e) {
        e.preventDefault(); // Stop form submission first

        // Get input values
        const f_name = form.querySelector("input[name='f_name']").value.trim();
        const l_name = form.querySelector("input[name='l_name']").value.trim();
        const email  = form.querySelector("input[name='prd_adm_email']").value.trim();
        const mobile = form.querySelector("input[name='prd_adm_mobile']").value.trim();

        // Remove existing alerts
        const oldAlert = document.querySelector(".form-alert");
        if (oldAlert) oldAlert.remove();

        // Helper: show alert message
        function showAlert(msg) {
            const alertDiv = document.createElement("div");
            alertDiv.className = "alert alert-danger form-alert mt-2 text-start";
            alertDiv.innerHTML = msg;
            form.prepend(alertDiv);

            // Scroll to alert
            alertDiv.scrollIntoView({ behavior: "smooth" });
        }

        // Validation rules
        if (f_name === "") {
            showAlert("⚠️ First Name is required.");
            return;
        }

        if (l_name === "") {
            showAlert("⚠️ Last Name is required.");
            return;
        }

        // Email validation
        const emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        if (!emailPattern.test(email)) {
            showAlert("⚠️ Please enter a valid email address.");
            return;
        }

        // Indian Mobile Validation (starts 6–9, 10 digits)
        const mobilePattern = /^[6-9][0-9]{9}$/;
        if (!mobilePattern.test(mobile)) {
            showAlert("⚠️ Please enter a valid 10-digit Indian mobile number starting with 6-9.");
            return;
        }

        // If all good → submit form
        form.submit();
    });


    // LIVE MOBILE INPUT RESTRICTION
    const mobileField = document.querySelector("input[name='prd_adm_mobile']");
    mobileField.addEventListener("input", function () {
        this.value = this.value.replace(/[^0-9]/g, '').substring(0, 10);
    });

});
</script>



    <style>
        /* ✅ FIXED BACKDROP */
.modal-backdrop.show {
    opacity: 0.85;
    background: radial-gradient(circle, #000 20%, #0a0a1a 80%);
}

/* ✅ FORCE MODAL ON TOP */
.modal {
    z-index: 2000;
}

.modal-dialog {
    max-width: 480px;
    margin: auto;
}

/* ✅ MODAL CARD */
.modern-modal {
    background: linear-gradient(145deg, #101a36, #0b132b);
    border-radius: 20px;
    padding: 25px 22px 35px;
    border: 1px solid rgba(255,255,255,0.12);
    box-shadow: 0 30px 80px rgba(0,0,0,0.65);
    position: relative;
    overflow: hidden;
}

/* ✅ CLOSE BUTTON */
.modal-close-btn {
    position: absolute;
    top: 14px;
    right: 14px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    padding: 6px;
    z-index: 10;
}

/* ✅ TITLE */
.modal-title-main {
    font-size: 24px;
    font-weight: 800;
    color: #ffffff;
}

/* ✅ SUBTITLE */
.modal-subtitle {
    font-size: 15px;
    color: #c3ccff;
}

/* ✅ INPUT FIELDS */
.modern-input {
    background: rgba(255,255,255,0.08) !important;
    border: 1px solid rgba(255,255,255,0.15);
    border-radius: 10px;
    color: #fff;
    padding: 12px 14px;
}

.modern-input::placeholder {
    color: #bfc7ff;
}

.modern-input:focus {
    border-color: #ff0000;
    box-shadow: 0 0 12px rgba(255,0,0,0.6);
    background: rgba(255,255,255,0.12) !important;
    color: #fff;
}

/* ✅ SUBMIT BUTTON */
.submit-btn {
    background: linear-gradient(145deg, #ff0000, #b30000);
    border-radius: 35px;
    padding: 12px 18px;
    font-size: 17px;
    font-weight: 700;
    color: #fff;
    border: none;
    box-shadow: 0 10px 25px rgba(255,0,0,0.5);
    transition: 0.3s ease;
}

.submit-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 16px 40px rgba(255,0,0,0.7);
}

/* ✅ MOBILE FIX */
@media (max-width: 576px) {
    .modal-dialog {
        max-width: 95%;
    }
}

        .btn {
            position: relative;
            font-size: 1rem;
            font-weight: 600;
            color: #fff;
            line-height: 1;
            text-align: center;
            padding: 16px 34px;
            border: 0 none;
            border-radius: 100px;
            outline: 0 none;
            cursor: pointer;
            z-index: 1;
            background: #f00;
        }

        .avatar-lg {
            height: 5rem;
            width: 5rem;
        }

        .pricing-table {
            position: relative;
            padding: 45px;
            background-color: #141d39;
            border-radius: 1rem;
            border: 2px solid #fff;
        }

        .sub-heading {
            font-size: 19px;
        }

        .package-list li {
            color: #fff;
            border: 1px solid rgba(255, 245, 245, 0.13);
            font-size: 19px;
        }

        .package-price {
            color: #fff;
        }

        .package-type {
            color: #fff;
            background-color: red;
            font-size: 25px;
            font-weight: 700;
            border-radius: 20px;
        }

        .intro .title:not(.layout-2) {
            position: relative;
        }

        .intro .title:not(.layout-2)::after {
            position: absolute;
            content: "";
            height: 3px;
            width: 50px;
            background-color: #fff;
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
        }

        body {
            font-family: 'Poppins', sans-serif;
            color: #333;
        }

        /* fallback */
        @font-face {
            font-family: 'Material Symbols Outlined';
            font-style: normal;
            font-weight: 400;
            src: url(https://fonts.gstatic.com/s/materialsymbolsoutlined/v290/kJF1BvYX7BgnkSrUwT8OhrdQw4oELdPIeeII9v6oDMzByHX9rA6RzaxHMPdY43zj-jCxv3fzvRNU22ZXGJpEpjC_1v-p_4MrImHCIJIZrDCvHOej.woff2) format('woff2');
        }

        .material-symbols-outlined {
            font-family: 'Material Symbols Outlined';
            font-weight: normal;
            font-style: normal;
            font-size: 24px;
            line-height: 1;
            letter-spacing: normal;
            text-transform: none;
            display: inline-block;
            white-space: nowrap;
            word-wrap: normal;
            direction: ltr;
            -moz-font-feature-settings: 'liga';
            -moz-osx-font-smoothing: grayscale;
        }

        /* Slider Section */
        .hero-section {
            background: linear-gradient(90deg, #eb0909, #141d39);
            color: white;
            padding-top: 40px;
            text-align: left;
        }

        .hero-section h1 {
            font-size: 3rem;
            font-weight: 800;
            font-family: 'Montserrat', sans-serif;
            text-align: center;
        }

        .hero-section p {
            font-size: 1.8rem;
            margin-bottom: 20px;
            text-align: center;
            font-weight: 700;
        }

        .hero-section .description {
            border: 2px solid #000;
            background: #000;
            padding: 20px;
            border-radius: 10px;
        }

        .hero-btn {
            background: #ff6b00;
            border: none;
            font-weight: 600;
            color: #fff;
            padding: 10px 25px;
            border-radius: 50px;
            transition: 0.3s;
        }

        .hero-btn:hover {
            background: #ff8b2d;
        }

        /* Description Section */
        .desc-section {
            background: #fff;
            padding: 60px 0;
        }

        .desc-section ul {
            list-style: none;
            padding: 0;
        }

        .desc-section li::before {
            content: "✔";
            color: #28a745;
            font-weight: bold;
            margin-right: 10px;
        }

        /* Benefits Section */
        .benefit-section {
            background: #f9f9f9;
            padding: 60px 0;
        }

        .benefit-box {
            background: #fff;
            border-radius: 15px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            transition: 0.3s;
        }

        .benefit-box:hover {
            transform: translateY(-5px);
        }

        .benefit-icon {
            font-size: 2.5rem;
            color: #5a00e0;
            margin-bottom: 15px;
        }

        h2 {
            margin: 1.5rem 0;
            margin-top: 1.5rem;
            font-size: 3rem;
            font-weight: 600;
            line-height: 1.2;
            font-family: "Poppins", sans-serif;
            color: #000;
            -ms-word-wrap: break-word;
            word-wrap: break-word;
        }

        .list-group .list-group-item .icon {
            font-size: 1.5rem;
            color: #7c4fe0;
        }

        .list-group .list-group-item .icon {
            /* font-size: 1.5rem; */
            color: #eb0909 !important;
        }

        .list-group .list-group-item .icon {
            display: flex;
            justify-content: center;
            align-items: center;
            /* height: 3.5rem; */
            width: 3.5rem;
            background-color: #fff;
            border-radius: 0.5rem;
            font-size: 1.5rem;
            color: #7c4fe0;
        }

        .primary-bg {
            background: linear-gradient(135deg, #e60000, #b30000);
        }

        .second-bg {
            background-color: #141d39;
        }

        .content-section {
            width: 100%;
            padding: 30px 0;
            background-size: cover;
            background-attachment: fixed;
            background-position: center;
        }

        .list-group-item {
            background-color: inherit;
        }

        .list-group .list-group-item {
            margin: 0.25rem 0;
        }

        .tech-feature .material-symbols-outlined {
            line-height: 2.2;
        }

        .header-wave {
            --size: 10px;
            --m: 0.5;
            --p: calc(var(--m)*var(--size));
            --R: calc(var(--size)*sqrt(var(--m)*var(--m) + 1));
            height: 20px;
            mask: radial-gradient(var(--R) at left 50% var(--d, top) calc(var(--size) + var(--p)), #000 99%, #0000 101%) calc(50% - 2*var(--size)) 0/calc(4*var(--size)) 100%, radial-gradient(var(--R) at left 50% var(--d, top) calc(-1*var(--p)), #0000 99%, #000 101%) left 50% var(--d, top) var(--size)/calc(4*var(--size)) 100% repeat-x;
            background: linear-gradient(90deg, #680ce1, #680ce1);
            margin-bottom: -0px;
        }

        .footer-wave-section {
            --size: 10px;
            --m: 0.5;
            --p: calc(var(--m)*var(--size));
            --R: calc(var(--size)*sqrt(var(--m)*var(--m) + 1));
            height: 20px;
            mask: radial-gradient(var(--R) at left 50% var(--d, top) calc(var(--size) + var(--p)), #000 99%, #0000 101%) calc(50% - 2*var(--size)) 0/calc(4*var(--size)) 100%, radial-gradient(var(--R) at left 50% var(--d, top) calc(-1*var(--p)), #0000 99%, #000 101%) left 50% var(--d, top) var(--size)/calc(4*var(--size)) 100% repeat-x;
            background: linear-gradient(90deg, #680ce1, #680ce1);
            margin-top: -1px;
            transform: rotate(180deg);
        }

        img {
            max-width: 100%;
            height: auto;
            vertical-align: middle;
        }

        h4 {
            margin: 1.5rem 0;
            font-size: 1.5rem;
            font-weight: 600;
            line-height: 1.2;
            font-family: "Poppins", sans-serif;
            color: #000;
            -ms-word-wrap: break-word;
            word-wrap: break-word;
        }

        .section-1-li {
            border: 2px solid #fff !important;
            padding: 5px !important;
            background: #141d39;
            border-radius: 20px !important;
        }

        .section-1-li span {
            color: #fff;
            font-size: 19px;
            font-weight: 600;
            text-align: center;
            padding: 15px;
            padding-left: 50px;
        }

        .section-2 .section-2-li {
            /* border: 2px solid #fff !important; */
            background-color: #141d39 !important;
            border-radius: 20px;
        }

        .section-2 .section-2-li p {
            font-weight: 600;
        }

        .image-frame {
            background-color: #fff;
            /* border-radius: 20px; */
            padding: 10px;
        }

        .image-frame img {}

        .section-3 li {
            background: linear-gradient(135deg, rgba(30, 41, 82, 0.95), rgba(18, 26, 54, 0.95));
            border-radius: 14px;
            padding: 22px 25px !important;
            margin-bottom: 18px !important;

            /* PREMIUM 3D SHADOW */
            box-shadow:
                0 20px 40px rgba(0, 0, 0, 0.45),
                inset 0 0 0 1px rgba(255, 255, 255, 0.08);

            display: flex;
            align-items: center;
            gap: 14px;

            color: #ffffff;
            font-size: 17px;
            font-weight: 500;
            letter-spacing: 0.3px;

            transition: all 0.35s ease;
            border-left: 4px solid #ffd200;
        }

        /* ✅ HOVER EFFECT */
        .section-3 li:hover {
            transform: translateY(-4px) scale(1.01);
            box-shadow:
                0 30px 60px rgba(0, 0, 0, 0.6),
                0 0 20px rgba(255, 210, 0, 0.4);
            border-left-color: #ff9f00;
        }

        /* ✅ ICON STYLE */
        .section-3 .icon span,
        .section-3 .material-symbols-outlined {
            background: radial-gradient(circle, #ffd500, #ffb300);
            color: #000;
            font-size: 20px;
            padding: 6px;
            border-radius: 50%;
            box-shadow:
                0 0 10px rgba(255, 213, 0, 0.7),
                0 0 20px rgba(255, 213, 0, 0.4);
        }

        /* ✅ TEXT LOOK STRONGER */
        .section-3 li span {
            color: #ffffff;
            line-height: 1.6;
        }

        /* ✅ MOBILE POLISH */
        @media (max-width: 768px) {
            .section-3 li {
                font-size: 15px;
                padding: 18px 18px !important;
            }
        }


        .section-3 li span {
            font-size: 19px;
        }

        .section-4 li {
            /* border: 2px solid #eb0909!important; */
            background-color: #fff;
            padding: 20px !important;
            box-shadow: rgba(0, 0, 0, 0.35) 0px 5px 15px;
        }

        .section-4 li span {
            font-size: 19px;
            color: #eb0909 !important;
            text-align: center;
            font-weight: 700;
        }

        .section-5 li {
            border: 2px solid #000 !important;
            padding: 10px !important;
        }

        .section-5 li span {
            font-size: 19px;
            font-weight: 600;
        }

        @media (max-width: 600px) {
            section h2 {
                font-size: 30px;
                text-align: center;
            }

            .hero-section h1 {
                font-size: 30px;
            }

            .hero-section p {
                font-size: 20px;
            }
        }

        @media (max-width: 600px) {
            .image-frame {
                margin-bottom: 20px;
            }
        }

        a:hover {
            color: #fff;
        }
    </style>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</body>

</html>