<?php
$section = $sections['section_1'] ?? [];

$title  = $section['title'] ?? 'Section Title';
$points = $section['points'] ?? [];

// Convert simple text into numbered items with subtitle
$formattedPoints = [];
foreach ($points as $p) {
    $formattedPoints[] = [
        'title' => $p,
        'subtitle' => 'Lorem ipsum short description goes here explaining the feature.'
    ];
}

?>
<section class="feature-list-section">
    <div class="container">

        <h2 class="text-center text-white mb-5"><?= $title; ?></h2>

        <?php $i = 1;
        foreach ($formattedPoints as $item): ?>

            <div class="feature-card">
                <div class="feature-num"><?= $i++; ?></div>

                <div class="feature-text">
                    <h4><?= $item['title']; ?></h4>
                    <p><?= $item['subtitle']; ?></p>
                </div>
            </div>

        <?php endforeach; ?>

    </div>
</section>
<style>
    /* MAIN SECTION */
    .feature-list-section {
        background: #0b1226;
        padding: 10px 0;
    }

    /* CARD */
    .feature-card {
        display: flex;
        align-items: flex-start;
        gap: 22px;
        background: rgba(255, 255, 255, 0.04);
        padding: 28px;
        border-radius: 18px;
        margin-bottom: 22px;
        border: 1px solid rgba(255, 255, 255, 0.05);
        transition: .3s;
    }

    /* CARD HOVER */
    .feature-card:hover {
        transform: translateY(-4px);
        box-shadow: 0 30px 60px rgba(0, 0, 0, 0.6), 0 0 20px rgba(255, 210, 0, 0.4);
    }

    /* NUMBER BADGE */
    .feature-num {
        background: linear-gradient(145deg, #FFD700, #FFB700);
        color: #4a2e00;
        font-size: 22px;
        width: 45px;
        height: 45px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 700;
        box-shadow: 0 0 12px rgba(255, 215, 0, 0.7);
    }

    /* TEXT */
    .feature-text h4 {
        color: #fff;
        font-size: 19px;
        font-weight: 600;
        margin: 0 0 6px;
    }

    .feature-text p {
        color: #9da9bf;
        font-size: 15px;
        margin: 0;
    }

    /* MOBILE */
    @media (max-width: 768px) {
        .feature-card {
            padding: 22px;
        }

        .feature-num {
            width: 40px;
            height: 40px;
            font-size: 18px;
        }

        .feature-text h4 {
            font-size: 17px;
        }
    }
</style>