<?php
$section = $sections['section_2'] ?? [];

$main_title = $section['main_title'] ?? 'Make your Device Manage Everything For you';
$items      = $section['items'] ?? [];
$image      = $section['image'] ?? 'uploads/sections/default.png';

// Split items into 2 equal columns
$columns = array_chunk($items, ceil(count($items) / 2));
?>

<section class="content-section primary-bg">
    <div class="container">
        <div class="row justify-content-between">

            <div class="col-sm-12 text-center">
                <h2 class="mt-0 text-white"><?= $main_title; ?></h2>
            </div>

            <!-- LEFT CONTENT -->
            <div class="col-12 col-lg-8">
                <div class="content">


                    <div class="row">

                        <!-- LEFT LIST -->
                        <div class="col-sm-6">
                            <ul class="list-group list-group-flush section-2">

                                <?php if (!empty($columns[0])): ?>
                                    <?php foreach ($columns[0] as $item): ?>
                                        <li class="list-group-item section-2-li d-flex border-0 p-4">

                                            <?php
                                            $feature_img = $item['image'] ?? 'uploads/sections/feature-default.png';
                                        ?>
                                           <div class="icon-box me-3">
                                                <div class="icon shadow-sm bg-white">
                                                    <img src="<?= base_url($feature_img); ?>"
                                                         alt="<?= $item['title'] ?? ''; ?>"
                                                         style="width:40px;height:40px;object-fit:contain;">
                                                </div>
                                            </div>

                                            <span class="text-white">
                                                <h4 class="text-white mb-2 mt-0">
                                                    <?= $item['title'] ?? ''; ?>
                                                </h4>
                                                <p class="mb-0">
                                                    <?= $item['description'] ?? ''; ?>
                                                </p>
                                            </span>

                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                            </ul>
                        </div>

                        <!-- RIGHT LIST -->
                        <div class="col-sm-6">
                            <ul class="list-group list-group-flush section-2">

                                <?php if (!empty($columns[1])): ?>
                                    <?php foreach ($columns[1] as $item): ?>
                                        <li class="list-group-item section-2-li d-flex border-0 p-4">

                                            <?php
                                            $feature_img = $item['image'] ?? 'uploads/sections/feature-default.png';
                                        ?>
                                           <div class="icon-box me-3">
                                                <div class="icon shadow-sm bg-white">
                                                    <img src="<?= base_url($feature_img); ?>"
                                                         alt="<?= $item['title'] ?? ''; ?>"
                                                         style="width:40px;height:40px;object-fit:contain;">
                                                </div>
                                            </div>

                                            <span class="text-white">
                                                <h4 class="text-white mb-2 mt-0">
                                                    <?= $item['title'] ?? ''; ?>
                                                </h4>
                                                <p class="mb-0">
                                                    <?= $item['description'] ?? ''; ?>
                                                </p>
                                            </span>

                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                            </ul>
                        </div>

                    </div>
                </div>
            </div>

            <!-- RIGHT IMAGE -->
            <div class="col-12 col-lg-4 d-none d-md-block">
                <img src="<?= base_url($image); ?>" alt="Section Image" class="img-fluid">
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>

<style>
    .section-2.list-group .list-group-item .icon
    {
        height: 50px;
  width: 50px;
    }

.section-2 .section-2-li {
    background: linear-gradient(145deg, #0f1b3d, #0b1530);
    border-radius: 18px;
    margin-bottom: 22px !important;
    box-shadow:
        0 12px 30px rgba(0, 0, 0, 0.45),
        inset 0 0 0 1px rgba(255, 255, 255, 0.06);

    transition: all 0.35s ease;
    position: relative;
    overflow: hidden;
}

/* GOLD GLOW STRIP */
.section-2 .section-2-li::before {
    content: "";
    position: absolute;
    left: 0;
    top: 0;
    width: 5px;
    height: 100%;
    background: linear-gradient(#ffd500, #ff9f00);
}

/* HOVER EFFECT */
.section-2 .section-2-li:hover {
    transform: translateY(-6px) scale(1.01);
    box-shadow:
        0 24px 50px rgba(0, 0, 0, 0.65),
        0 0 30px rgba(255, 214, 0, 0.35);
}

/* ICON BOX */
.section-2 .icon-box {
    width: 56px;
    height: 56px;
    border-radius: 14px;
    background: linear-gradient(145deg, #ffffff, #e9e9e9);
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow:
        0 0 14px rgba(255, 214, 0, 0.5),
        inset 0 0 0 1px rgba(0, 0, 0, 0.1);
}

.section-2 .icon img {
    width: 34px;
    height: 34px;
    object-fit: contain;
}

/* TEXT STYLE */
.section-2 .section-2-li h4 {
    font-size: 20px;
    font-weight: 700;
    letter-spacing: 0.4px;
    margin-bottom: 6px;
}

.section-2 .section-2-li p {
    font-size: 15.5px;
    line-height: 1.6;
    color: #d6ddff;
}

/* RIGHT IMAGE POLISH */
.primary-bg img.img-fluid {
    border-radius: 22px;
    box-shadow:
        0 20px 50px rgba(0,0,0,0.45);
}

/* MOBILE OPTIMIZATION */
@media (max-width: 768px) {
    .section-2 .section-2-li {
        padding: 18px !important;
    }

    .section-2 .section-2-li h4 {
        font-size: 18px;
    }

    .section-2 .icon-box {
        width: 48px;
        height: 48px;
    }

    .section-2 .icon img {
        width: 28px;
        height: 28px;
    }
}

</style>