<?php
$section = $sections['section_3'] ?? [];

$title  = $section['title'] ?? 'Easily communicate with clients using sApp.';
$points = $section['points'] ?? [];
$image  = $section['image'] ?? 'uploads/default.png';
?>

<section class="content-section section-3-div">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-sm-12 text-center">
                <h2 class="mt-0 text-white"><?= $title; ?></h2>
            </div>
            <!-- LEFT IMAGE -->
            <div class="col-12 col-lg-6">
                <div class="image-frame">
                    <img src="<?= base_url($image); ?>" alt="Section Image" class="img-fluid">
                </div>

            </div>

            <!-- RIGHT CONTENT -->
            <div class="col-12 col-lg-6">
                <div class="content">
                    <!-- POINTS LIST -->
                    <ul class="list-group list-group-flush section-3">

                        <?php if (!empty($points)): ?>
                            <?php foreach ($points as $point): ?>
                                <li class="list-group-item d-flex border-0 p-0">
                                    <span class="text-white"><?= $point; ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>

                    </ul>

                </div>
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>

<style>
    .section-3 span {
        padding-left: 40px;
    }

    .section-3 span::before {
        content: "✔";
        width: 26px;
        height: 26px;
        background: linear-gradient(145deg, #FFD700, #FFB700);
        color: #4a2e00;
        border-radius: 50%;
        font-size: 13px;
        font-weight: bold;
        display: flex;
        align-items: center;
        justify-content: center;
        position: absolute;
        left: 20px;
        top: 25px;
        box-shadow: 0 0 12px rgba(255, 215, 0, 0.7);
    }

    .section-3-div {
        background: radial-gradient(circle at top, #1c2749 0%, #141d39 60%);
    }
</style>