<?php 
$section = $sections['section_4'] ?? [];

$title  = $section['title']  ?? 'Easily communicate with clients using sApp.';
$points = $section['points'] ?? [];
$image  = $section['image']  ?? 'uploads/default.png';
?>

<section class="content-section primary-bg tech-feature">
    <div class="container">
        <div class="row justify-content-between">

            <div class="col-sm-12 text-center">
                <h2 class="mt-0 text-white"><?= $title; ?></h2>
            </div>
            <!-- LEFT CONTENT -->
            <div class="col-12 col-lg-6">
                <div class="content">
                    <!-- POINTS LIST -->
                    <ul class="list-group list-group-flush content-section-1">

                        <?php if (!empty($points)): ?>
                            <?php foreach ($points as $point): ?>
                                <li class="list-group-item d-flex border-0 p-0 section-1-li">
                                    <span class="text-white"><?= $point; ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>

                    </ul>

                </div>
            </div>

            <!-- RIGHT IMAGE -->
            <div class="col-12 col-lg-6">
                <div class="image-frame">
                <img src="<?= base_url($image); ?>" alt="Section Image" class="img-fluid">
                </div>
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>
