<?php
$section = $sections['pricing_section'] ?? [];

$title = $section['title'] ?? 'Unlock Full Power Of sApp';
$plans = $section['plans'] ?? [];
?>

<section id="pricing" class="price-plan-area primary-bg pb-5">

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-10 col-lg-7">
                <!-- Intro -->
                <div class="intro text-center mb-4 mt-5">
                    <h2 class="title mt-0 text-white"><?= $title; ?></h2>
                </div>
            </div>
        </div>
        <!-- PRICING PLANS -->
        <div class="row justify-content-center mt-4 mb-5">
            <div class="col-12 col-sm-12 col-lg-12">
                <div class="row items">

                    <?php if (!empty($plans)): ?>
                        <?php foreach ($plans as $plan): ?>

                            <?php
                            // Skip empty plans safely
                            if (empty($plan['name']) || empty($plan['price'])) continue;
                            ?>

                            <div class="col-12 col-md-4 item">
                                <div class="pricing-table text-center wow fadeInLeft" data-aos-duration="2s" data-wow-delay="0.4s">

                                    <!-- PLAN NAME -->
                                    <span class="package-type d-block mt-3"><?= $plan['name']; ?></span>
                                    <h2 class="package-price clip-text text-effect my-3"><small>₹</small><?= number_format($plan['price']); ?></h2>

                                    <!-- FEATURES -->
                                    <ul class="package-list list-group list-group-flush">
                                        <?php if (!empty($plan['features'])): ?>
                                            <?php foreach ($plan['features'] as $feature): ?>
                                                <li class="list-group-item">
                                                    <?= $feature; ?>
                                                </li>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>

                                    <!-- BUTTON -->
                                    <a href="#" class="btn btn-primary">
                                        Choose Plan
                                    </a>

                                </div>
                            </div>

                        <?php endforeach; ?>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>

<style>
    /* ================================
   PREMIUM PRICING SECTION
================================ */

.price-plan-area.primary-bg {
    background: linear-gradient(135deg, #e60000, #b30000);
}

/* PRICING CARD */
.pricing-table {
    background: linear-gradient(145deg, #0f1b3d, #0b1530);
    border-radius: 22px;
    padding: 40px 30px;
    box-shadow:
        0 20px 50px rgba(0, 0, 0, 0.5),
        inset 0 0 0 1px rgba(255, 255, 255, 0.08);
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.35s ease;
    position: relative;
    overflow: hidden;
}

/* GOLD LEFT STRIP */
.pricing-table::before {
    content: "";
    position: absolute;
    left: 0;
    top: 0;
    width: 6px;
    height: 100%;
    background: linear-gradient(#ffd500, #ff9f00);
}

/* HOVER EFFECT */
.pricing-table:hover {
    transform: translateY(-10px) scale(1.02);
    box-shadow:
        0 35px 70px rgba(0, 0, 0, 0.7),
        0 0 35px rgba(255, 214, 0, 0.35);
}

/* PLAN NAME TAG */
.package-type {
    display: inline-block;
    background: linear-gradient(145deg, #ff0000, #c40000);
    padding: 10px 35px;
    border-radius: 30px;
    font-size: 18px;
    font-weight: 700;
    color: #fff;
    letter-spacing: 0.6px;
    box-shadow: 0 6px 20px rgba(255, 0, 0, 0.6);
}

/* PRICE */
.package-price {
    font-size: 48px;
    font-weight: 800;
    color: #ffffff;
    margin-bottom: 18px;
}

.package-price small {
    font-size: 24px;
    vertical-align: super;
}

/* FEATURE LIST */
.package-list li {
    background: transparent !important;
    border-bottom: 1px solid rgba(255,255,255,0.15);
    color: #e4e9ff;
    font-size: 16px;
    padding: 14px 0;
}

.package-list li:last-child {
    border-bottom: none;
}

/* CTA BUTTON */
.pricing-table .btn {
    margin-top: 25px;
    background: linear-gradient(145deg, #ff0000, #c40000);
    border-radius: 40px;
    padding: 12px 36px;
    font-size: 16px;
    font-weight: 700;
    border: none;
    box-shadow: 0 8px 25px rgba(255, 0, 0, 0.6);
    transition: all 0.3s ease;
}

.pricing-table .btn:hover {
    transform: translateY(-3px);
    background: linear-gradient(145deg, #ff1a1a, #ff0000);
}

/* FEATURED (CENTER PLAN BOOST) */
.price-plan-area .item:nth-child(2) .pricing-table {
    border: 2px solid rgba(255, 215, 0, 0.6);
}


/* MOBILE */
@media (max-width: 768px) {

    .price-plan-area .title {
        font-size: 30px;
    }

    .pricing-table {
        padding: 30px 22px;
        margin-bottom: 30px;
    }

    .package-price {
        font-size: 36px;
    }
}

</style>