<?php 
$faq = $sections['faq_section'] ?? [];

$heading = $faq['heading'] ?? 'Frequently Asked Questions';
$items   = $faq['items'] ?? [];
?>

<section class="faq pt-5 pb-5 faq-dark second-bg">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-12 col-md-10 col-lg-7">
				<div class="intro text-center">
					<h2 class="title mt-0 text-white"><?= $heading; ?></h2>
				</div>
			</div>
		</div>

		<div class="row justify-content-center">
			<div class="col-12 col-md-10">
				<div class="accordion" id="faqAccordion">

					<?php if (!empty($items)): ?>
						<?php foreach ($items as $key => $item): 
							$collapseId = 'faq' . ($key + 1);
						?>

					<!-- Item -->
					<div class="faq-item">
						<button class="faq-question <?= $key == 0 ? '' : 'collapsed'; ?>" data-bs-toggle="collapse" data-bs-target="#<?= $collapseId; ?>">
							<?= $item['question'] ?? ''; ?>
							<span class="icon">+</span>
						</button>
						<div id="<?= $collapseId; ?>" class="collapse <?= $key == 0 ? 'show' : ''; ?>" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								<?= $item['answer'] ?? ''; ?>
							</div>
						</div>
					</div>

						<?php endforeach; ?>
					<?php endif; ?>

				</div>
			</div>
		</div>
	</div>
	<?php include 'cta_button.php'; ?>
</section>

<style>
/* ===== PREMIUM FAQ DARK DESIGN ===== */

.faq-dark {
    background: radial-gradient(circle at top, #162447 0%, #0b132b 70%);
}

/* FAQ CARD */
.faq-dark .faq-item {
    margin-bottom: 18px;
    border-radius: 14px;
    overflow: hidden;
    background: linear-gradient(145deg, rgba(255,255,255,0.05), rgba(255,255,255,0.02));
    box-shadow: 
        0 15px 40px rgba(0,0,0,0.4),
        inset 0 0 0 1px rgba(255,255,255,0.06);
    transition: all 0.35s ease;
}

/* HOVER GLOW */
.faq-dark .faq-item:hover {
    transform: translateY(-3px);
    box-shadow:
        0 25px 60px rgba(0,0,0,0.6),
        0 0 22px rgba(0, 140, 255, 0.25);
}

/* QUESTION BUTTON */
.faq-dark .faq-question {
    width: 100%;
    background: linear-gradient(135deg, #16213e, #0f3460);
    color: #fff;
    border: none;
    padding: 20px 24px;
    text-align: left;
    font-size: 18px;
    font-weight: 600;
    display: flex;
    justify-content: space-between;
    align-items: center;
    cursor: pointer;
    border-radius: 14px;
    letter-spacing: 0.4px;
    transition: all 0.3s ease;
}

/* ACTIVE QUESTION */
.faq-dark .faq-question:not(.collapsed) {
    background: linear-gradient(135deg, #0f3460, #16213e);
    box-shadow: inset 0 -2px 0 rgba(255,255,255,0.1);
}

/* ICON + BUTTON */
.faq-dark .faq-question .icon {
    width: 38px;
    height: 38px;
    background: radial-gradient(circle, #ffd500, #ffb300);
    color: #000;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 22px;
    font-weight: bold;
    box-shadow:
        0 0 10px rgba(255, 213, 0, 0.7),
        0 0 25px rgba(255, 213, 0, 0.4);
    transition: all 0.3s ease;
}

/* ROTATE + TO × */
.faq-dark .faq-question:not(.collapsed) .icon {
    transform: rotate(45deg) scale(1.1);
    background: radial-gradient(circle, #ff4d4d, #ff0000);
    color: #fff;
    box-shadow:
        0 0 10px rgba(255, 0, 0, 0.7),
        0 0 25px rgba(255, 0, 0, 0.5);
}

/* ANSWER PANEL */
.faq-dark .faq-answer {
    padding: 20px 24px;
    background: linear-gradient(145deg, #ffffff, #eef2f7);
    color: #000;
    font-size: 16px;
    line-height: 1.7;
    border-radius: 0 0 14px 14px;
    animation: fadeInFAQ 0.4s ease;
}

/* FADE ANIMATION */
@keyframes fadeInFAQ {
    from {
        opacity: 0;
        transform: translateY(-5px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* TITLE LOOK */
.faq-dark .title {
    font-size: 40px;
    font-weight: 700;
    letter-spacing: 1px;
    text-transform: uppercase;
}

/* MOBILE OPTIMIZATION */
@media (max-width: 768px) {
    .faq-dark .faq-question {
        font-size: 16px;
        padding: 16px 18px;
    }

    .faq-dark .faq-answer {
        font-size: 15px;
        padding: 16px 18px;
    }

    .faq-dark .title {
        font-size: 28px;
    }
}


</style>