<?php $section = $sections['hero_section'] ?? []; ?>

<section id="home" class="hero-sec">
    <div class="container">
        <div class="row justify-content-center text-center">

            <!-- TITLE -->
            <div class="col-12">
                <?php if (!empty($section['title'])): ?>
                    <h1 class="hero-title">
                        <?= $section['title']; ?>
                    </h1>
                <?php endif; ?>

                <?php if (!empty($section['subtitle'])): ?>
                    <p class="hero-subtitle">
                        <?= $section['subtitle']; ?>
                    </p>
                <?php endif; ?>
            </div>

            <!-- BADGE -->
            <?php if (!empty($section['description'])): ?>
                <div class="col-12 mt-3">
                    <div class="hero-badge">
                        <?= $section['description']; ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- VIDEO FRAME -->
            <?php if (!empty($section['button_url'])): ?>
                <div class="col-12 col-md-10 mt-4">
                    <div class="video-frame" data-aos="zoom-in" data-aos-duration="800">
                        <iframe width="100%" height="480" 
                            src="<?= youtube_embed_url($section['button_url']); ?>"
                            allowfullscreen
                            frameborder="0">
                        </iframe>
                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>

<style>
    /* ================================
   PREMIUM HERO SECTION
================================ */

.hero-sec {
    padding: 40px 0 40px;
    background: linear-gradient(135deg, #e60000, #131c39);
}

/* TITLE */
.hero-title {
    font-size: 48px;
    font-weight: 900;
    color: #ffffff;
    letter-spacing: 1px;
    text-transform: capitalize;
    margin-bottom: 15px;
}

/* SUBTITLE */
.hero-subtitle {
    font-size: 22px;
    font-weight: 600;
    color: #f5f5f5;
}

/* BLACK BADGE BAR */
.hero-badge {
    background: #000;
    padding: 14px 34px;
    border-radius: 12px;
    color: #fff;
    display: inline-block;
    font-weight: 600;
    font-size: 20px;
    box-shadow: 0 8px 25px rgba(0,0,0,0.35);
}

/* VIDEO CARD WRAPPER */
.video-frame {
    position: relative;
    padding: 14px;
    border-radius: 22px;
    background: linear-gradient(180deg, #ffffff, #eef2f7);
    box-shadow: 0 20px 60px rgba(0,0,0,0.25);
    border: 3px solid rgba(255, 255, 255, 0.65);
}

/* VIDEO RADIUS */
.video-frame iframe {
    border-radius: 16px;
}

/* HOVER EFFECT */
.video-frame:hover {
    transform: translateY(-6px);
    transition: 0.3s ease-in-out;
    box-shadow: 0 30px 70px rgba(0,0,0,0.4);
}

/* MOBILE */
@media(max-width:768px){
    .hero-title { font-size: 32px; }
    .hero-subtitle { font-size: 18px; }
    .hero-badge { font-size: 16px; padding: 10px 22px; }
    .video-frame iframe { height: 260px; }
}

</style>