<section class="thankyou-premium">
    <div class="thankyou-inner">

        <h1 class="ty-title">Thank You for Registering!</h1>
        <p class="ty-subtitle">
            Your form has been submitted successfully. Click below to access the Admin Demo Panel.
        </p>

        <a href="https://ecom.sitelively.in/public/admin" class="ty-button">🚀 Go to Admin Panel Demo</a>

    </div>
</section>

<style>
/* ================================
   PREMIUM THANK-YOU PAGE DESIGN
   Colors: #b30000 + #141d39
================================ */

.thankyou-premium {
    background: radial-gradient(circle at top left, rgba(255, 0, 0, 0.15), transparent 50%),
                radial-gradient(circle at bottom right, rgba(20, 29, 57, 0.6), #0c1226);
    height: 100vh;
    display: flex;
    justify-content: center;
    align-items: center;
    padding: 40px;
    position: relative;
    overflow: hidden;
}

/* Soft Glow Background */
.thankyou-premium::before {
    content: "";
    position: absolute;
    width: 650px;
    height: 650px;
    background: rgba(255, 0, 0, 0.25);
    border-radius: 50%;
    top: -120px;
    left: -120px;
    filter: blur(120px);
    opacity: 0.7;
}

.thankyou-premium::after {
    content: "";
    position: absolute;
    width: 500px;
    height: 500px;
    background: rgba(20, 29, 57, 0.55);
    border-radius: 50%;
    bottom: -120px;
    right: -120px;
    filter: blur(110px);
}

/* Content Box */
.thankyou-inner {
    text-align: center;
    position: relative;
    z-index: 10;
    animation: floatUp 1.2s ease-out;
}

/* Animation */
@keyframes floatUp {
    from { transform: translateY(40px); opacity: 0; }
    to   { transform: translateY(0); opacity: 1; }
}

/* Heading */
.ty-title {
    font-size: 52px;
    font-weight: 800;
    color: #ffffff;
    text-shadow: 0 6px 35px rgba(0,0,0,0.45);
    letter-spacing: 1px;
}

/* Subtitle */
.ty-subtitle {
    font-size: 20px;
    color: #e3e3e3;
    max-width: 760px;
    margin: 20px auto 45px auto;
    line-height: 1.6;
}

/* Premium Glass Button */
.ty-button {
    display: inline-block;
    padding: 18px 46px;
    border-radius: 50px;
    font-size: 20px;
    font-weight: 700;
    color: #fff;
    text-decoration: none;

    background: rgba(255, 255, 255, 0.05);
    backdrop-filter: blur(12px);

    border: 2px solid rgba(255, 255, 255, 0.15);
    box-shadow:
        0 6px 25px rgba(179,0,0,0.45),
        inset 0 0 12px rgba(255,255,255,0.2);

    transition: 0.35s ease;
}

.ty-button:hover {
    background: #b30000;
    color: #fff;
    border-color: #ffb3b3;
    transform: translateY(-4px);
    box-shadow: 0 12px 28px rgba(0,0,0,0.55), 0 0 18px #b30000;
}

/* Responsive */
@media(max-width: 768px){
    .ty-title { font-size: 34px; }
    .ty-subtitle { font-size: 16px; padding: 0 10px; }
    .ty-button { padding: 14px 32px; font-size: 18px; }
}
</style>
