<div class="cover-image bg-background" data-bs-image-src="<?php echo base_url()?>uploads/banner1.jpg" style="background: url(&quot;<?php echo base_url()?>uploads/banner1.jpg&quot;) center center;">
				<!--Section-->
	<div>
		<div class="sptb-1">
			<div class="header-text1 mb-0">
				<div class="container">
					<div class="row">
						<h1 class="text-center text-white"><b>XML Sitemap Generator</b></h1>
						<p class="text-center text-white">Generate an XML sitemap online by submitting your website URLs. We also have options to add last modification date, change frequency and priority.</p>
					</div>
				</div>
			</div><!-- /header-text -->
		</div>
	</div><!--/Section-->
</div>
<!--Breadcrumb-->
<div class="relative">
	<div class="shape overflow-hidden text-white">
		<svg viewBox="0 0 2880 48" fill="none" xmsns="http://www.w3.org/2000/svg">
			<path d="M0 48H1437.5H2880V0H2160C1442.5 52 720 0 720 0H0V48Z" fill="<?php echo $visual_setting->color_2?>"></path>
		</svg>
	</div>
</div>
<section class="sptb">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="card border-0 shadow-none bg-transparent">
					<div class="row justify-content-center">
						
						<div class="col-lg-8 col-xl-8 col-md-12 mx-auto mt-5">
							<div class="card mb-0 single-page customerpage contact">
								<div class="card-body wrapper wrapper2 box-shadow-0" style="border :2px dotted #be1502">
									
									<div class="name">
										<label>Paste your URLs list here</label>
										<textarea rows="6" cols="8" id="url" class="form-control descriptionchar description" ></textarea>
									</div>
									<div class="name mt-5">
										<label>Last Modification</label>
										<input type="date" class="form-control" id="last_modification" placeholder="" value="<?php echo date('Y-m-d') ?>" />
									</div>
									<div class="name mt-5">
										<label>Change Frequency</label>
										<select name="changefreq" id="changefreq" class="form-control"><option value="always">Always</option> <option value="hourly">Hourly</option> <option value="daily">Daily</option> <option value="weekly" selected="selected">Weekly</option> <option value="monthly">Monthly</option> <option value="yearly">Yearly</option> <option value="never">Never</option></select>
									</div>
									<div class="name mt-5">
										<label>Priority</label>
										<select name="priority" id="priority" class="form-control"><option value="0">0.0</option> <option value=".1">0.1</option> <option value=".2">0.2</option> <option value=".3">0.3</option> <option value=".4">0.4</option> <option value=".5">0.5</option> <option value=".6">0.6</option> <option value=".7">0.7</option> <option value=".8">0.8</option> <option value=".9">0.9</option> <option value="1" selected="selected">1.0</option></select>
									</div>
									<div class="name mt-5">
										<button class="btn btn-secondary" onclick="generate_sitemap()" id="gen_btn">Generate Sitemap</button>
									</div>

									<div class="name mt-5">
										<label>Copy your Generated XML Sitemap from here</label>
										<textarea rows="10" cols="8" class="form-control descriptionchar description" name="description" id="main_sitemap" placeholder=""></textarea>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</section><!--Section-->
<script type="text/javascript">
	function generate_sitemap() 
	{
		var url 				= $('#url').val();
		var last_modification 	= $('#last_modification').val();
		var changefreq 			= $('#changefreq').val();
		var priority 			= $('#priority').val();
		if(!validURL(url))
		{
			alert("please Enter Valid Url");
			return false;
		}
		if(url == '')
		{
			alert("please Enter Url");
			return false;
		}
		if(last_modification == '')
		{
			alert("please Enter Last modification Date");
			return false;
		}
		if(changefreq == '')
		{
			alert("please Enter changefreq");
			return false;
		}
		if(priority == '')
		{
			alert("please Enter priority");
			return false;
		}
		$.ajax({
          	beforeSend: function() {
          		$('#gen_btn').prop('disabled', true);
                $("#gen_btn").html('loading.......');
            },
          	url: "<?php echo base_url() ?>/home/generate_sitemap",
          	method: "POST",
          	data:{url:url, last_modification:last_modification, changefreq:changefreq, priority:priority},
          	success: function(data) {
            if(data)
            {
                $('#main_sitemap').val(data);
                $("#gen_btn").html('Generate Sitemap');
                $('#gen_btn').prop('disabled', false);
            }
            else
            {
                alert("data Not Found")
                $(".loader").hide();
            }
            
          }
       });
	}
	function validURL(str) {
	  var pattern = new RegExp('^(https?:\\/\\/)?'+ // protocol
	    '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|'+ // domain name
	    '((\\d{1,3}\\.){3}\\d{1,3}))'+ // OR ip (v4) address
	    '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*'+ // port and path
	    '(\\?[;&a-z\\d%_.~+=-]*)?'+ // query string
	    '(\\#[-a-z\\d_]*)?$','i'); // fragment locator
	  return !!pattern.test(str);
	}
</script>
