<?php
$this->load->model('addons/noticeboard_model', 'noticeboard_model');
$notifications = $this->noticeboard_model->get_notice_by_course_id($course_id);
?>
<div class="row justify-content-center">
	<div class="col-md-7 p-0 text-center py-4">
		<h6 class="text-start"><?php echo site_phrase('total') . ' ' . $notifications->num_rows() . ' ' . site_phrase('notifications');; ?></h6>
		<hr>
		<?php foreach ($notifications->result_array() as $notification): ?>
			<div class="card mt-3">
				<div class="card-body">
					<p class="text-left text-start">

						<b><i class="far fa-clipboard pr-2"></i>
							<?php echo htmlspecialchars_decode($notification['title']); ?></b>

						<small class="pl-3 text-muted text-12 float-end"><i class="text-dark far fa-clock"></i> <?php echo date('d M Y', $notification['date_added']); ?></small>
					</p>
					<div class="description text-start"><?php echo htmlspecialchars_decode($notification['description']); ?></div>
				</div>
			</div>
		<?php endforeach; ?>
	</div>
</div>
<style>
	.text-start {
		text-align: left !important;
	}

	.float-end {
		float: right !important;
	}
</style>