<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Log in | <?php echo $app_setting->application_name ?></title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>css/adminlte.min.css">
 <script src="<?php echo admin_css() ?>plugins/sweetalert/sweetalert2.all.min.js"></script>

 <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
</head>

<body class="hold-transition login-page">
<div class="login-box">
  <!-- /.login-logo -->
  <div class="card card-outline card-primary">
    <div class="card-header text-center">
      <a href="<?php echo base_url() ?>" class="h1"><b><?php echo $app_setting->application_name ?></b></a>
    </div>
    
    <div class="card-body">
      <form action="#" method="post">
        

        <div id="mobile_login_form">
          <p class="login-box-msg">Sign in with Mobile No & OTP</p>
            <div class="input-group mb-3">
              <input type="text" name="mobile" class="form-control" placeholder="Enter Mobile Number" id="inputmobile" >
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-phone"></span>
                </div>
              </div>
            </div>

            <div class="input-group mb-3">
              <div id="recaptcha-container"></div>
            </div>

            
          <div class="social-auth-links text-center mt-2 mb-3" id="login_otp_btn_id">
            <button type="button" id="login_otp_btn" name="sign_in" class="btn btn-primary btn-block">Send OTP</button>
          </div>
        </div>

        <div id="inputOtp_id" style="display: none">
          <div class="input-group mb-3">
            <input type="number" name="otp" class="form-control" placeholder="Enter OTP" id="inputOtp" >
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-key"></span>
              </div>
            </div>
          </div>


          <div class="social-auth-links text-center mt-2 mb-3" id="verifyotp_id">
            <button type="button" id="verifyotp" name="sign_in" class="btn btn-primary btn-block">Verify OTP</button>
          </div>
        </div>
        


      
      <!-- /.social-auth-links -->
      </form>
      <style type="text/css">
        #mobile_login_form, #login_otp_btn_id
        {
          /*display: none;
        }
      </style>
     
    </div>
    <!-- /.card-body -->
  </div>
  <!-- /.card -->
</div>

<!-- /.login-box -->
<!-- jQuery -->
<script src="<?php echo admin_css() ?>plugins/jquery/jquery.min.js"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo admin_css() ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo admin_css() ?>js/adminlte.min.js"></script>
</body>
</html>
<script src="https://www.gstatic.com/firebasejs/8.2.9/firebase-app.js"></script>
<script src="https://www.gstatic.com/firebasejs/8.2.9/firebase-analytics.js"></script>
<script defer src="https://www.gstatic.com/firebasejs/7.19.0/firebase-auth.js"></script>
<script>
  var apiKey = "<?= $app_setting->apiKey ?>";
  var authDomain = "<?= $app_setting->authDomain ?>";
  var projectId = "<?= $app_setting->projectId ?>";
  var storageBucket = "<?= $app_setting->storageBucket ?>";
  var messagingSenderId = "<?= $app_setting->messagingSenderId ?>";
  var appId = "<?= $app_setting->appId ?>";
  var measurementId = "<?= $app_setting->measurementId ?>";
  var base_url = "<?= base_url() ?>";
</script>
<script src="<?php echo admin_css() ?>js/main.js"></script>
