<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Registration | <?php echo $app_setting->application_name ?></title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/fontawesome-free/css/all.min.css">
  <!-- icheck bootstrap -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>plugins/icheck-bootstrap/icheck-bootstrap.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="<?php echo admin_css() ?>css/adminlte.min.css">
  <script src="<?php echo admin_css() ?>plugins/sweetalert/sweetalert2.all.min.js"></script>


</head>

<body class="hold-transition register-page">
  <div class="register-box">
    <div class="card card-outline card-primary">
      <div class="card-header text-center">
        <a href="<?php echo base_url() ?>" class="h1"><b><?php echo $app_setting->application_name ?></b></a>
      </div>
      <div class="card-body">
        <p class="login-box-msg">Register a new membership</p>

        <form id="registerForm" method="post">
          <div class="input-group mb-3">
            <input type="text" class="form-control" placeholder="Full Name" name="name" id="userName" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input type="number" class="form-control" placeholder="Mobile" name="mobile" id="userMobile" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-phone"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input type="password" class="form-control" placeholder="Password" name="password" id="userPass" required>
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
          </div>
          <div class="row mb-3">
            <div class="col-12">
              <div class="icheck-primary">
                <input type="checkbox" id="agreeTerms" name="terms" value="agree" required>
                <label for="agreeTerms">I agree to the <a href="#">terms</a></label>
              </div>
            </div>
          </div>
          <div class="text-center">
            <button type="submit" class="btn btn-primary btn-block">Register</button>
          </div>
          <div id="message" class="mt-2 text-center text-danger"></div>
        </form>

        <a href="<?php echo base_url() ?>login" class="text-center">I already have a membership</a>
      </div>
      <!-- /.form-box -->
    </div><!-- /.card -->
  </div>
  <!-- /.register-box -->

  <!-- jQuery -->
  <script src="<?php echo admin_css() ?>plugins/jquery/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="<?php echo admin_css() ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE App -->
  <script src="<?php echo admin_css() ?>js/adminlte.min.js"></script>


<script>
  $('#registerForm').on('submit', function(e) {
    e.preventDefault();

    // var id = <?php //echo $course->course_id; ?>;

    $.ajax({
      url: '<?= base_url("register/student_registration"); ?>',
      type: 'POST',
      data: $(this).serialize(),
      dataType: 'json',
      success: function(response) {
        if (response.status === 'success') {

          $('#message').removeClass('text-danger').addClass('text-success').text(response.message);
          swal('Wow', response.message, 'success');
          $('#registerForm')[0].reset();

          location.href = "<?php echo base_url(); ?>course_buy";
          
          <?php //if ($course->course_is_free == 1): ?>
            // location.href = "<?php echo base_url(); ?>course/enrolement/<?php //echo $course->course_slug; ?>/<?php //echo $course->course_id; ?>";
          <?php //else: ?>
          
          <?php //endif; ?>
        } else {
          $('#message').removeClass('text-success').addClass('text-danger').text(response.message);
          swal('Oops', response.message, 'error');
        }
      },
      error: function(e) {
        console.log(e.responseText);
        $('#message').text('Something went wrong. Please try again.');
        swal('Oops', "Something went wrong. Please try again.", 'error');
      }
    });
  });
</script>

</body>
</html>
