<section class="faq pt-5 pb-5 faq-dark">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-12 col-md-10 col-lg-7">
				<div class="intro text-center">
					<h2 class="title mt-0">Frequently Asked Questions</h2>
					<p class="sub-heading">Find answers to the most common questions below.</p>
				</div>
			</div>
		</div>

		<div class="row justify-content-center">
			<div class="col-12 col-md-10">
				<div class="accordion" id="faqAccordion">

					<!-- Item 1 -->
					<div class="faq-item">
						<button class="faq-question" data-bs-toggle="collapse" data-bs-target="#faq1">
							Who is this boot camp designed for?
							<span class="icon">+</span>
						</button>
						<div id="faq1" class="collapse show" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								This bootcamp is perfect for beginners, students, developers, and professionals who want practical hands-on learning.
							</div>
						</div>
					</div>

					<!-- Item 2 -->
					<div class="faq-item">
						<button class="faq-question collapsed" data-bs-toggle="collapse" data-bs-target="#faq2">
							What do I need to prepare before the workshop starts?
							<span class="icon">+</span>
						</button>
						<div id="faq2" class="collapse" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								A laptop, stable internet connection, and basic computer knowledge are enough.
							</div>
						</div>
					</div>

					<!-- Item 3 -->
					<div class="faq-item">
						<button class="faq-question collapsed" data-bs-toggle="collapse" data-bs-target="#faq3">
							Will I receive recordings of the workshop sessions?
							<span class="icon">+</span>
						</button>
						<div id="faq3" class="collapse" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								Yes, all enrolled students will receive session recordings.
							</div>
						</div>
					</div>

					<!-- Item 4 -->
					<div class="faq-item">
						<button class="faq-question collapsed" data-bs-toggle="collapse" data-bs-target="#faq4">
							How long is the bootcamp and what is the schedule?
							<span class="icon">+</span>
						</button>
						<div id="faq4" class="collapse" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								The bootcamp runs for 4–6 weeks with weekend live sessions.
							</div>
						</div>
					</div>

					<!-- Item 5 -->
					<div class="faq-item">
						<button class="faq-question collapsed" data-bs-toggle="collapse" data-bs-target="#faq5">
							What if I need support outside live sessions?
							<span class="icon">+</span>
						</button>
						<div id="faq5" class="collapse" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								You get full WhatsApp and email support outside live sessions.
							</div>
						</div>
					</div>

					<!-- Item 6 -->
					<div class="faq-item">
						<button class="faq-question collapsed" data-bs-toggle="collapse" data-bs-target="#faq6">
							I made the payment but did not receive any update?
							<span class="icon">+</span>
						</button>
						<div id="faq6" class="collapse" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								Please contact support with your transaction ID for instant help.
							</div>
						</div>
					</div>

				</div>
			</div>
		</div>
	</div>
	<?php include 'cta_button.php'; ?>
</section>
<style>
	.faq-dark .faq-item {
	margin-bottom: 15px;
	border-radius: 8px;
	overflow: hidden;
}

.faq-dark .faq-question {
	width: 100%;
	background: #132c4b;
	color: #fff;
	border: none;
	padding: 18px 20px;
	text-align: left;
	font-size: 19px;
	font-weight: 500;
	display: flex;
	justify-content: space-between;
	align-items: center;
	cursor: pointer;
	border-radius: 6px;
}

.faq-dark .faq-question .icon {
	font-size: 24px;
	font-weight: bold;
	transition: 0.3s;
}

.faq-dark .faq-question:not(.collapsed) {
	background: #0f2340;
}

.faq-dark .faq-question:not(.collapsed) .icon {
	transform: rotate(45deg); /* turns + into × */
}

.faq-dark .faq-answer {
	padding: 18px 20px;
	background: #f5f7fa;
	color: #000;
	font-size: 16px;
	border-radius: 0 0 6px 6px;
}

</style>