<!-- <link href="<?php echo base_url(); ?>assets/3d_generator/bower_components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet"> -->
<!-- <link href="<?php echo base_url(); ?>assets/3d_generator/css/bootstrap.cerulean.css" rel="stylesheet"> -->
<link href="<?php echo base_url(); ?>assets/3d_generator/css/style.css" rel="stylesheet">
<script src="<?php echo base_url(); ?>assets/3d_generator/bower_components/jquery/dist/jquery.min.js"></script>
<link href="<?php echo base_url(); ?>assets/3d_generator/bower_components/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet">

<section class="margin-top-xs-55" style="position: relative;
">
    <div class="header-text mb-0">
        <div>
            <div class="row ">
                <div class="col-lg-12 col-md-12 col-sm-12 text-center">
                    <svg style="width:100%;height: 450px;" viewBox="0 0 1280 679" preserveAspectRatio="none" width="100%" height="100%">
                        <defs>
                            <g id="shape">
                                <path d="M0 0H1280V544.882C1280 544.882 1115 679 640 679C165 679 0 544.882 0 544.882V0Z" fill="#D9D9D9"></path>
                                <path d="M0 0H1280V544.882C1280 544.882 1115 679 640 679C165 679 0 544.882 0 544.882V0Z" fill="url(#gradient)"></path>
                            </g>
                            <radialGradient id="gradient" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(640 -261.197) rotate(90) scale(815.683 664.92)">
                                <stop stop-color="#4169E1"></stop>
                                <stop offset="1" stop-color="#071A34"></stop>
                            </radialGradient>
                        </defs>
                        <use href="#shape"></use>
                    </svg>
                    <div class="frame-image">
                        <div style="position: absolute; border-radius: inherit; inset: 0px;" data-framer-background-image-wrapper="true"><img decoding="async" sizes="100vw" src="<?php echo base_url(); ?>assets/lSHGuRrPALnsNPFyY1JslN8so.png" alt="" style="display: block; width: 100%; height: 100%; border-radius: inherit; object-position: center center; object-fit: cover;"></div>
                    </div>
                    <div class="text-body main-header-text">
                        <h1 class="text-center text-white"><b>The #1 3D Image Generator</b></h1>
                        <h4 class="text-center text-white">A free tool that lets you quickly create high-quality 3D box mockups for your digital products.</h4>
                    </div>
                </div>
                <!-- 
                <div class="floating-icons">
                    <i class="icon-facebook"></i>
                    <i class="icon-adwords"></i>
                    <i class="icon-seo"></i>
                    <i class="icon-instagram"></i>
                    <i class="icon-activecampaign"></i>
                    <i class="icon-wordpress"></i>
                    <i class="icon-shopify"></i>
                    <i class="icon-youtube"></i>
                    <i class="icon-analytics"></i>
                    <i class="icon-kk"></i>
                </div> -->
            </div>
        </div>
    </div>

    <section class="sptb">
        <div class="container">
            <div class="row justify-content-center align-items-center">
                <div class="col-md-8">
                    <div class="card border-0 shadow-none bg-transparent">
                        <div class="card-body pb-0">
                            <div class="card single-page size customerpage contact mb-0 box-shadow-0">
                                <div class="card-body mb-0">
                                    <ul class="nav nav-tabs nav-fill" role="tablist">
                                        <li class="nav-item">
                                            <a class="nav-link active" data-bs-toggle="tab" href="#sectionTextures">Textures</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#sectionBackground">Background</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#sectionLighting">Lighting</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#sectionBox">Box Settings</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#sectionCamera">Camera</a>
                                        </li>
                                        <li class="nav-item">
                                            <a class="nav-link" data-bs-toggle="tab" href="#sectionSave">Save Image</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <div class="card border-0 shadow-none bg-transparent">
                        <div class="card-body pt-1 pb-0">
                            <div class="card single-page size customerpage contact mb-0 box-shadow-0">
                                <div class="card-body">
                                    <div class="tab-content">

                                        <!-- Textures menu -->
                                        <div id="sectionTextures" class="tab-pane option-tab fade in active sectionTexturesClass">
                                            <h3>Textures</h3>
                                            <p>Select textures for your product box.</p>


                                            <div class="cover-container" id="product-textures">

                                                <!-- front cover -->
                                                <div class="cover-item">
                                                    <label class="control-label">Front cover</label>
                                                    <input id="texture-front" name="texture-front[]" type="file" class="box-texture file file-loading" data-allowed-file-extensions='["bmp", "gif", "jpg", "jpeg", "png"]'>
                                                </div>

                                                <!-- back cover -->
                                                <div class="cover-item">
                                                    <label class="control-label">Back cover</label>
                                                    <input id="texture-back" name="texture-side[]" type="file" class="box-texture file file-loading" data-allowed-file-extensions='["bmp", "gif", "jpg", "jpeg", "png"]'>
                                                </div>

                                                <!-- top cover -->
                                                <div class="cover-item">
                                                    <label class="control-label">Top</label>
                                                    <input id="texture-top" name="texture-top[]" type="file" class="box-texture file file-loading" data-allowed-file-extensions='["bmp", "gif", "jpg", "jpeg", "png"]'>
                                                </div>

                                                <!-- left side cover -->
                                                <div class="cover-item">
                                                    <label class="control-label">Left side</label>
                                                    <input id="texture-left" name="texture-side[]" type="file" class="box-texture file file-loading" data-allowed-file-extensions='["bmp", "gif", "jpg", "jpeg", "png"]'>
                                                </div>

                                                <!-- right side cover -->
                                                <div class="cover-item">
                                                    <label class="control-label">Right side</label>
                                                    <input id="texture-right" name="texture-side[]" type="file" class="box-texture file file-loading" data-allowed-file-extensions='["bmp", "gif", "jpg", "jpeg", "png"]'>
                                                </div>

                                                <script>
                                                    // when texture is loaded re-render product box
                                                    var product_texture_images = {};
                                                    $('.box-texture').change(function(e) {

                                                        e.preventDefault();
                                                        var f = e.target.files[0];

                                                        if (f) {
                                                            var reader = new FileReader();
                                                            reader.scope = this;
                                                            reader.onload = function(evt) {
                                                                var image = document.createElement('img');
                                                                image.src = evt.target.result;
                                                                product_texture_images[this.scope.id] = image;
                                                                renderProductBox();
                                                            }
                                                            reader.readAsDataURL(f);
                                                        }
                                                    });
                                                </script>

                                            </div>

                                            <div style="clear:both"></div>
                                        </div>

                                        <!-- Background menu -->
                                        <div id="sectionBackground" class="tab-pane option-tab fade">
                                            <h3>Background</h3>
                                            <p>Select rendering background color.</p>
                                            <p>Color: <input id="background-color" class="jscolor {onFineChange:'updateBackground(this)'}" value="6A9AAB"></p>
                                            <button id="transparent-back-button" type="button" style="background:#ccc" class="btn">Transparent</button>
                                            <button type="button" class="btn" style="background:#9999aa">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#000000">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#FFFFFF">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#888888">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#CCCCCC">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#FFF056">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#C63D0F">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#3B3738">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#7E8F7C">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#005A31">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#A8CD1B">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#F3FAB6">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#6A9AAB">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#DE1B1B">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#E9E581">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#7D1935">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#4A96AD">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#67BCDB">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#E44424">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#404040">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#B71427">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#118C4E">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#FF9009">&nbsp;</button>
                                            <button type="button" class="btn" style="background:#DF3D82">&nbsp;</button>

                                            <script>
                                                // set all color button actions
                                                $("#sectionBackground").find("button").on("click", function() {
                                                    var picker = document.getElementById('background-color');
                                                    picker.jscolor.fromString(this.style.background);
                                                    updateBackground(picker.jscolor);
                                                });

                                                // special case - the transparent background
                                                $("#transparent-back-button").on("click", function() {
                                                    setBackground("none");
                                                });

                                                // when the background color picker is used
                                                function updateBackground(picker) {
                                                    setBackground(picker.toHEXString());
                                                }
                                            </script>
                                        </div>

                                        <!-- Lighting menu -->
                                        <div id="sectionLighting" class="tab-pane option-tab fade">
                                            <h3>Lighting</h3>

                                            <div class="row">
                                                <!-- ambient light -->
                                                <div class="col-md-4 col-xs-12">
                                                    <h4>Ambient light</h4>
                                                    <p>Ambient light is the general light of the scene.</p>
                                                    <p>Color: <input id="ambient-color" class="jscolor {onFineChange:'updateAmbientLight(this)'}" value="D6D6D6"></p>
                                                </div>

                                                <!-- directional light -->
                                                <div class="col-md-4 col-xs-12">
                                                    <h4>Directional light</h4>
                                                    <p>Directional light is a light that goes from the camera position straight forward, like a flashlight. <br /><br />
                                                        If you want a different source use the camera to set position and lock it via the "lock position" checkbox.</p>
                                                    <p>Directional light: <input id="directional-color" class="jscolor {onFineChange:'updateDirectionalLight(this)'}" value="FFFFFF"></p>
                                                    <label><input id="directional-lock" type="checkbox" value=""> Lock position</label>
                                                </div>

                                                <!-- point -->
                                                <div class="col-md-4 col-xs-12">
                                                    <h4>Point light</h4>
                                                    <p>A point light that floats in a position relative to the camera. You can set its position, color and strength to add special effects.</p>
                                                    <p>Color: <input id="point-color" class="jscolor {onFineChange:'updatePointLight()'}" value="000000"></p>

                                                    <p>Intensity
                                                        <input style="width:50%; display:inline;" id="point-intensity" type="range" class="form-control" value="1" min="0.5" max="10" step="0.5" onchange="updatePointLight();">
                                                    </p>

                                                    <p>Offset
                                                        <input style="width:20%; display:inline;" id="point-x" type="number" class="form-control" value="150" min="-5000" max="5000" step="50" onchange="updatePointLight();">
                                                        <input style="width:20%; display:inline;" id="point-y" type="number" class="form-control" value="150" min="-5000" max="5000" step="50" onchange="updatePointLight();">
                                                        <input style="width:20%; display:inline;" id="point-z" type="number" class="form-control" value="150" min="-5000" max="5000" step="50" onchange="updatePointLight();">
                                                    </p>
                                                </div>
                                            </div>

                                            <script>
                                                // return if the directional light is currently locked
                                                function isDirectionalLightLocked() {
                                                    return document.getElementById("directional-lock").checked;
                                                }

                                                // when the ambient light color picker is used
                                                function updateAmbientLight(picker) {
                                                    setAmbientLight(picker.toHEXString());
                                                }

                                                // update point light
                                                function updatePointLight() {
                                                    picker = document.getElementById("point-color").jscolor;
                                                    setPointLight({
                                                            x: parseFloat($("#point-x").val()),
                                                            y: parseFloat($("#point-y").val()),
                                                            z: parseFloat($("#point-z").val())
                                                        },
                                                        picker.toHEXString(),
                                                        parseFloat($("#point-intensity").val()));
                                                }

                                                // when the directional light color picker is used
                                                function updateDirectionalLight(picker) {
                                                    setDirectionalLight(picker.toHEXString());
                                                }
                                            </script>
                                        </div>

                                        <!-- Box settings menu -->
                                        <div id="sectionBox" class="tab-pane option-tab fade">
                                            <h3>Box Settings</h3>
                                            <div class="row">

                                                <!-- material -->
                                                <div class="col-md-6 col-xs-12">
                                                    <h4>Material</h4>
                                                    <p>Here you can configure the material of the box.</p>
                                                    <p>Shininess
                                                        <input style="width:80%;" id="material-shine" type="range" class="form-control" value="2" min="0.5" max="25" step="0.5" onchange="renderProductBox();">
                                                    </p>
                                                    <p>Shine color: <input id="specular-color" class="jscolor {onFineChange:'renderProductBox()'}" value="FFFFFF"></p>
                                                </div>

                                                <!-- size -->
                                                <div class="col-md-6 col-xs-12">
                                                    <h4>Size</h4>
                                                    <p>Set box size and propotions.</p>
                                                    <p>Box width:
                                                        <input style="width:30%; display:inline;" id="size-x" type="number" class="form-control" value="500" min="50" max="1000" step="10" onchange="renderProductBox();">
                                                    </p>
                                                    <p>Box height:
                                                        <input style="width:30%; display:inline;" id="size-y" type="number" class="form-control" value="800" min="50" max="1000" step="10" onchange="renderProductBox();">
                                                    </p>
                                                    <p>Box depth:
                                                        <input style="width:30%; display:inline;" id="size-z" type="number" class="form-control" value="200" min="50" max="1000" step="10" onchange="renderProductBox();">
                                                    </p>
                                                </div>

                                            </div>
                                        </div>

                                        <!-- Camera menu -->
                                        <div id="sectionCamera" class="tab-pane option-tab fade">
                                            <h3>Camera</h3>
                                            <p>Select pre-defined camera position & angle:</p>
                                            <button class="btn btn-default" onclick="setCamera(-1000, 540, 780);">
                                                <img src="<?php echo base_url(); ?>assets/3d_generator/img/camera_default.png" width="80" />
                                            </button>
                                            <button class="btn btn-default" onclick="setCamera(1000, 540, 780);">
                                                <img src="<?php echo base_url(); ?>assets/3d_generator/img/camera_default2.png" width="80" />
                                            </button>
                                            <button class="btn btn-default" onclick="setCamera(0, 0, 1500);">
                                                <img src="<?php echo base_url(); ?>assets/3d_generator/img/camera_front.png" width="80" />
                                            </button>
                                            <button class="btn btn-default" onclick="setCamera(-1000, -250, 780);">
                                                <img src="<?php echo base_url(); ?>assets/3d_generator/img/camera_default3.png" width="80" />
                                            </button>
                                            <button class="btn btn-default" onclick="setCamera(1000, -250, 780);">
                                                <img src="<?php echo base_url(); ?>assets/3d_generator/img/camera_default5.png" width="80" />
                                            </button>
                                            <button class="btn btn-default" onclick="setCamera(0, 700, 1300);">
                                                <img src="<?php echo base_url(); ?>assets/3d_generator/img/camera_front2.png" width="80" />
                                            </button>

                                            <!-- camera position and rotation input -->
                                            <hr />
                                            <div class="form-group">
                                                <label for="camera-position">Position: </label>
                                                <input class="form-control" id="camera-position" aria-describedby="camera-position" placeholder="0,0,0" style="width:220px; display:inline-block">
                                                <label for="camera-lookat"> Look at: </label>
                                                <input class="form-control" id="camera-lookat" aria-describedby="camera-lookat" placeholder="0,0,0" style="width:220px; display:inline-block">
                                                <label for="camera-lookat"> Camera FOV: </label>
                                                <input class="form-control" id="camera-fov" onchange="updateCameraFov(this.value);" aria-describedby="camera-fov" type="number" value="50" min="1" max="360" style="width:220px; display:inline-block">
                                            </div>
                                            <script>
                                                // function to set camera position
                                                function setCamera(x, y, z) {
                                                    controls.center.set(0, 0, 0);
                                                    camera.position.set(x, y, z);
                                                    controls.update();
                                                }

                                                // are we setting camera position?
                                                var settingCameraPosition = false;
                                                $("#camera-position").focusin(function() {
                                                    settingCameraPosition = true;
                                                    $(this).css('background', '#aaffaa');
                                                });
                                                $("#camera-position").focusout(function() {
                                                    settingCameraPosition = false;
                                                });

                                                // are we setting camera lookat?
                                                var settingCameraLookat = false;
                                                $("#camera-lookat").focusin(function() {
                                                    settingCameraLookat = true;
                                                    $(this).css('background', '#aaffaa');
                                                });
                                                $("#camera-lookat").focusout(function() {
                                                    settingCameraLookat = false;
                                                });

                                                // set camera position from input
                                                $("#camera-position").keyup(function() {
                                                    $(this).css('background', '#ffaaaa');
                                                    var vals = $(this).val().split(',');
                                                    var x = Number(vals[0]);
                                                    var y = Number(vals[1]);
                                                    var z = Number(vals[2]);
                                                    if (!isNaN(x) && !isNaN(y) && !isNaN(z)) {
                                                        camera.position.set(x, y, z);
                                                        controls.update();
                                                        $(this).css('background', '#aaffaa');
                                                    }
                                                });

                                                // set camera rotation from input
                                                $("#camera-lookat").keyup(function() {
                                                    $(this).css('background', '#ffaaaa');
                                                    var vals = $(this).val().split(',');
                                                    var x = Number(vals[0]);
                                                    var y = Number(vals[1]);
                                                    var z = Number(vals[2]);
                                                    if (!isNaN(x) && !isNaN(y) && !isNaN(z)) {
                                                        controls.target.set(x, y, z);
                                                        controls.update();
                                                        $(this).css('background', '#aaffaa');
                                                    }
                                                });

                                                // update camera position and lookat input
                                                function updateCameraInputs() {
                                                    if (!window.camera) {
                                                        return;
                                                    }
                                                    var round2 = function(num) {
                                                        return Math.round((num + Number.EPSILON) * 100) / 100;
                                                    }

                                                    if (!settingCameraPosition) {
                                                        $("#camera-position").val(String(Math.round(camera.position.x)) + ', ' + String(Math.round(camera.position.y)) + ', ' + String(Math.round(camera.position.z))).css('background', 'white');
                                                    }

                                                    if (!settingCameraLookat) {
                                                        $("#camera-lookat").val(String(Math.round(controls.target.x)) + ', ' + String(Math.round(controls.target.y)) + ', ' + String(Math.round(controls.target.z))).css('background', 'white');
                                                    }
                                                }

                                                // auto update camera inputs
                                                setInterval(updateCameraInputs, 50);
                                            </script>
                                        </div>

                                        <!-- Save image menu -->
                                        <div id="sectionSave" class="tab-pane option-tab fade">
                                            <h3>Save Image</h3>
                                            <p>Here you can save your final product image and start using it!<br />
                                                Click on 'Generate Image' to create your image in the desired size.</p>

                                            <label>Image Width (height is set automatically): &nbsp;</label><input type="number" id="result-img-size-x" value="1400" name="img-size-x" min="200" max="10000"> <br /><br />
                                            <button class="btn btn-success btn-lg" onclick="toImage();">
                                                Generate Image!
                                            </button>
                                            <br />
                                        </div>

                                        <!-- result image div -->
                                        <div id="result-img-div">
                                            <!-- Top-right close button -->
                                            <button class="modal-close-btn" onclick="document.getElementById('result-img-div').style.display='none';">&times;</button>

                                            <img id="result-img" alt="Generated Image">
                                            <h5>
                                                To save image, right click on the image above and select "Save Image As..",
                                                or <a id="save-img-link" download="image.png">click here</a>.
                                            </h5>
                                            <!-- Optional bottom-close link -->
                                        </div>

                                    </div>
                                    <style>
                                        #result-img-div {
                                            display: none;
                                            position: fixed;
                                            top: 50%;
                                            left: 50%;
                                            transform: translate(-50%, -50%);
                                            width: 50%;
                                            max-width: 400px;
                                            background: #0f2449;
                                            border: 2px solid black;
                                            border-radius: 15px;
                                            padding: 15px 20px 20px 20px;
                                            z-index: 99999;
                                            text-align: center;
                                            box-shadow: 0 0 20px rgba(0, 0, 0, 0.5);
                                        }

                                        #result-img-div img {
                                            display: block;
                                            width: 100%;
                                            height: auto;
                                            border-radius: 10px;
                                        }

                                        #result-img-div h5 {
                                            color: white;
                                            margin-top: 15px;
                                        }

                                        #result-img-div a#save-img-link {
                                            color: yellow;
                                            text-decoration: underline;
                                        }

                                        .modal-close-btn {
                                            position: absolute;
                                            top: 10px;
                                            right: 15px;
                                            font-size: 22px;
                                            color: #000;
                                            cursor: pointer;
                                            background: #fff;
                                            border: none;
                                            font-weight: bold;
                                            z-index: 100000;
                                            border-radius: 100%;
                                            width: 30px;
                                            height: 30px;
                                            line-height: 1;
                                        }

                                        .close-modal-bottom {
                                            position: absolute;
                                            bottom: 10px;
                                            left: 15px;
                                            color: yellow;
                                            cursor: pointer;
                                            font-size: 16px;
                                        }

                                        @media (max-width: 767px) {
                                            #result-img-div {
                                                width: 90%;
                                            }
                                        }
                                    </style>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-8">
                    <div class="card border-0 shadow-none bg-transparent">
                        <div class="card-body pt-1">
                            <div class="card single-page size customerpage contact mb-0 box-shadow-0">
                                <div class="card-body mb-0">
                                    <div id="canvas-container" class="canvas-container transparent-background"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>


    <script src="<?php echo base_url(); ?>assets/3d_generator/bower_components/bootstrap-fileinput/js/fileinput.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/3d_generator/bower_components/three.js/build/three.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/3d_generator/bower_components/three.js/examples/js/modifiers/SubdivisionModifier.js"></script>
    <script src="<?php echo base_url(); ?>assets/3d_generator/bower_components/three.js/examples/js/controls/OrbitControls.js"></script>
    <script src="<?php echo base_url(); ?>assets/3d_generator/js/jscolor.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/3d_generator/js/renderer.js"></script>

</section>
<script>
    // set default bootstrap-fileinput
    $.fn.fileinput.defaults.showUpload = false;
    $.fn.fileinput.defaults.showCancel = false;
    $.fn.fileinput.defaults.showRemove = false;
    $.fn.fileinput.defaults.showRemove = false;

    // init default covers
    product_texture_images = {
        "texture-front": "<img style='height:200px' class='file-preview-image' src='<?php echo base_url(); ?>assets/3d_generator/img/default_front.png'>",
        "texture-left": "<img style='height:200px' class='file-preview-image' src='<?php echo base_url(); ?>assets/3d_generator/img/default_left.png'>",
        "texture-right": "<img style='height:200px' class='file-preview-image' src='<?php echo base_url(); ?>assets/3d_generator/img/default_right.png'>",
        "texture-back": "<img style='height:200px' class='file-preview-image' src='<?php echo base_url(); ?>assets/3d_generator/img/default_back.png'>",
        "texture-top": "<img style='height:200px; width:160px;' class='file-preview-image' src='<?php echo base_url(); ?>assets/3d_generator/img/default_top.png'>",
    }

    // set previews
    $("#texture-front").fileinput({
        initialPreview: [product_texture_images["texture-front"]],
    });
    $("#texture-left").fileinput({
        initialPreview: [product_texture_images["texture-left"]],
    });
    $("#texture-right").fileinput({
        initialPreview: [product_texture_images["texture-right"]],
    });
    $("#texture-back").fileinput({
        initialPreview: [product_texture_images["texture-back"]],
    });
    $("#texture-top").fileinput({
        initialPreview: [product_texture_images["texture-top"]],
    });

    // convert covers to image instances
    for (var key in product_texture_images) {
        product_texture_images[key] = $(product_texture_images[key])[0];
    }
</script>
<style>
    .canvas-container canvas {
        background: rgb(153, 153, 170);
        width: 731px !important;
        height: 300px;
    }

    .close.fileinput-remove {
        display: none;
    }

    .file-preview-image {
        max-width: 100%;
    }

    .file-caption-name {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
        max-width: 100px;
    }

    .nav-tabs .nav-item.show .nav-link,
    .nav-tabs .nav-link.active {
        border: 0;
        color: #fff !important;
    }

    .sectionTexturesClass {
        width: 720px;
    }

    @media only screen and (max-width: 600px) {
        .sectionTexturesClass {
            width: 290px !important;
        }

        .canvas-container canvas
        {
            width: 100% !important;
        }
    }
</style>