<?php

$this->input->cookie('blog_view', TRUE);
$get_cookie = get_cookie('blog_view');
if ($get_cookie != 'blog_view_' . $blog->id) {
	$cookie = array(
		'name'   => 'blog_view',
		'value'  => 'blog_view_' . $blog->id,
		'expire' => '86400',
		'prefix' => ''
	);
	$blog_count = $blog->view + 1;
	$data1 = array('view' => $blog_count);
	$this->db->where('id', $blog->id);
	$this->db->update('blog', $data1);
	$this->input->set_cookie($cookie);
}

$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
	<script>
		swal("Oops", "<?php echo $errors ?>", "error")
	</script>
	<?php echo $errors ?>
<?php
	$this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
	<script>
		swal("Oops", "<?php echo $error ?>", "error")
	</script>
<?php
	$this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
	<script>
		swal({
			title: "Done!",
			text: "<?php echo $success ?>",
			icon: "success",
		});
	</script>
<?php
	$this->session->unset_userdata('success');
}
?>


<!--Section-->
<section class="sptb">
	<div class="container">
		<div class="row">
			<div class="col-xl-8 col-lg-8 col-md-12">
				<div class="card blog-detail">
					<div class="card-body">
						<div class="item7-card-img br-7 mb-5">
							<img loading="lazy" src="<?php echo base_url() ?><?php echo $blog->image ?>" alt="<?php echo $blog->title ?>" class="w-100">
							<div class="item-card-text-bottom me-0">
								<h4 class="mb-0"><?php echo $category->category_name ?></h4>
							</div>
						</div>
						<a href="javascript:void(0)" class="text-dark">
							<h2 class="font-weight-semibold"><?php echo $blog->title ?></h2>
						</a>
						<div class="item7-card-desc d-md-flex mb-2 mt-3">
							<a href="javascript:void(0)" class="font-weight-semibold fs-16"><i class="fe fe-calendar me-2 text-primary"></i><?php echo date("d-M-Y H:i", strtotime($blog->date)); ?></a>
							<a href="javascript:void(0)" class="font-weight-semibold fs-16"><i class="fe fe-user me-2 text-primary"></i><?php echo ucwords($blog->author) ?></a>
							<div class="ms-auto">
								<a href="javascript:void(0)" class="font-weight-semibold fs-16"><i class="fe fe-message-circle me-2 text-primary"></i><?php echo $blog_comment ?> Comments</a>
							</div>
						</div>
						<?php echo $blog->content ?>
					</div>
				</div>
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Comments</h3>
					</div>
					<div class="card-body">
						<?php $i = 1;
						foreach ($all_main_comment as $key => $main_comment): ?>
							<div class="media mt-0 p-5 border br-7 review-media">
								<div class="d-flex me-3">
									<a href="javascript:void(0)"><img loading="lazy" class="media-object brround avatar-lg" alt="64x64" src="<?php echo front_css() ?>avatar.png"> </a>
								</div>
								<div class="media-body">
									<h4 class="mt-0 mb-1 font-weight-semibold"><?php echo $main_comment->name ?>

									</h4>
									<small class="text-muted fs-14">
										<i class="fa fa-clock-o"></i> <?php echo date("d-M-Y", strtotime($main_comment->created_at)); ?>
									</small>
									<p class="font-13 fs-15 mb-2 mt-2"><?php echo $main_comment->comment ?>
									</p>


								</div>
							</div>
						<?php endforeach; ?>
						<?php //endif; 
						?>

					</div>
				</div>
				<div class="card mb-lg-0">
					<div class="card-header">
						<h3 class="card-title">Write Your Comments</h3>
					</div>
					<div class="card-body">
						<div class="form-group">
							<input type="text" class="form-control" id="name1" placeholder="Your Name">
						</div>
						<div class="form-group">
							<input type="email" class="form-control" id="email" placeholder="Email Course address">
						</div>
						<div class="form-group">
							<textarea class="form-control" name="example-textarea-input" rows="6" placeholder="Write Your Comment"></textarea>
						</div>
						<a href="javascript:void(0)" class="btn btn-primary">Submit</a>
					</div>
				</div>
			</div>
			<!--Rightside Content-->
			<div class="col-xl-4 col-lg-4 col-md-12">
				
				<div class="card">
					<div class="card-header">
						<h3 class="card-title">Blog Categories</h3>
					</div>
					<div class="card-body">
						<div class="list-catergory">
							<div class="item-list">
								<ul class="list-group mb-0">
									<?php foreach ($all_blog_category as $key => $blog_category):
										$total_blog = $this->blog_model->count_blog_by_category($blog_category->id); ?>
										<li class="list-group-item pt-0">
											<a href="<?php echo base_url() ?>blog-category/<?php echo $blog_category->category_name ?>/<?php echo $blog_category->id ?>" class="text-default-dark fs-14 font-weight-bold">
												<i class="fa fa-code bg-primary-light text-primary"></i> <?php echo $blog_category->category_name ?>
												<span class="badgetext badge badge-pill mb-0 mt-1 text-muted font-weight-normal"><?php echo $total_blog ?> Posts</span>
											</a>
										</li>
									<?php endforeach; ?>
								</ul>
							</div>
						</div>
					</div>
				</div>
			
			</div>
		</div>
	</div>
</section>
