<section class="sptb" id="curriculum" style="background-color: #fff;">
    <div class="container">
        <div class="row ">
            <div class="col-md-12 col-lg-12 col-sm-12">
                <div class="section-title">
                    <h2><?php echo $heading['title']; ?></h2>
                    <p class="fs-22 lead mt-5"><?php echo $heading['sub_title']; ?></p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="mb-4">
                    <div class="accordion accordion-flush" id="accordionFlushExample">
                        <?php
                        $sections = $this->course_model->get_section('course', $course->course_id)->result_array();
                        foreach ($sections as $key => $section) : ?>
                            <div class="accordion-item rounded-3 border-0 shadow mb-2 curriculum-section" <?php if ($key >= 2) echo 'style="display:none;"'; ?>>
                                <h2 class="accordion-header">
                                    <button class="accordion-button border-bottom collapsed fw-semibold" type="button" data-bs-toggle="collapse" data-bs-target="#curriculumSectionCol<?php echo $section['id']; ?>" aria-expanded="false" aria-controls="curriculumSectionCol<?php echo $section['id']; ?>">
                                        <div class="row w-100 ms-5">
                                            <div class="col-auto accordion-item-title d-flex flex-column">
                                                <span><?php echo $section['title']; ?></span>
                                            </div>
                                            <div class="col-auto ms-auto pe-0">

                                            </div>
                                            <div class="col-auto ms-auto pe-0 d-flex">
                                                <?php
                                                $this->db->where('section_id', $section['id']);
                                                $lessonIDs = array_column($this->db->get('lesson')->result_array(), 'id');

                                                $all_resource = $this->db->select('b.rc_name')
                                                    ->from('resource_files a')
                                                    ->join('resource_category b', 'b.rc_id = a.category_id')
                                                    ->where_in('a.lesson_id', $lessonIDs)
                                                    ->get()->result();

                                                $resource_counts = [];
                                                foreach ($all_resource as $resource) {
                                                    $resource_counts[$resource->rc_name] = ($resource_counts[$resource->rc_name] ?? 0) + 1;
                                                }

                                                echo implode(' ', array_map(fn($category, $count) => "<span class='ms-auto me-2 ms-3 pe-2 border-end text-14px fw-400 d-flex'><div class='project-count-number me-2'>$count</div><div class='project_name d-flex align-items-center'> $category</div></span>", array_keys($resource_counts), $resource_counts));
                                                ?>


                                                <span class="ms-auto me-2 ms-3 pe-2 border-end text-14px  fw-400 d-flex">
                                                    <div class='project-count-number me-2'> <?php echo $this->course_model->get_lessons('section', $section['id'])->num_rows(); ?> </div>
                                                    <div class='project_name d-flex align-items-center'>Lession</div>
                                                </span>
                                            </div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="curriculumSectionCol<?php echo $section['id']; ?>" class="accordion-collapse collapse" data-bs-parent="#accordionFlushExample">
                                    <div class="accordion-body">
                                        <ul class="ac-lecture">
                                            <?php
                                            $lessons = $this->course_model->get_lessons('section', $section['id'])->result_array();
                                            foreach ($lessons as $lesson) : ?>
                                                <li>
                                                    <?php if ($lesson['video_type'] == 'YouTube' && $lesson['is_free'] == 1) : ?>
                                                        <a href="javascript:void(0)" onclick="openVideoModel('<?php echo $lesson['video_url']; ?>')" class="checkPropagation">
                                                        <?php else : ?>
                                                            <a href="#" class="checkPropagation">
                                                            <?php endif; ?>
                                                            <span class="d-flex  ellipsis-line-2">
                                                                <!-- <i class="fa-regular fa-circle-play"></i> -->
                                                                <?php if ($lesson['lesson_type'] == 'other' || $lesson['lesson_type'] == 'text'): ?>
                                                                    <i class="fa-regular far fa-file-alt me-1"></i>
                                                                    <?php echo get_phrase($lesson['attachment_type']); ?>
                                                                <?php elseif ($lesson['lesson_type'] == 'quiz'): ?>
                                                                    <i class="fa-regular far fa-question-circle me-1"></i><?php echo get_phrase('Quiz'); ?>
                                                                <?php elseif ($lesson['lesson_type'] == 'audio'): ?>
                                                                    <i class="fa-regular far fa-file-audio me-1"></i><?php echo get_phrase('Audio'); ?>
                                                                <?php else: ?>
                                                                    <i class="fa-regular far fa-file-video me-1"></i><?php echo get_phrase('Video'); ?>
                                                                <?php endif; ?>
                                                                <?php echo $lesson['title']; ?></span>

                                                            <?php if ($lesson['lesson_type'] == 'video') : ?>
                                                                <div class="d-flex justify-content-center">
                                                                    <?php if ($lesson['is_free'] == 1): ?>
                                                                        <span class="badge badge-success badge-pill me-3"><i class="fa fa-eye text-white"></i>Preview</span>
                                                                    <?php endif; ?>
                                                                    <div class="lecture-info align-content-center" style="width: 60px"><?php echo substr($lesson['duration'], 3); ?> min</div>
                                                                </div>
                                                            <?php endif; ?>
                                                            </a>
                                                </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php if (count($sections) > 2): ?>
                        <div class="text-center mt-3">
                            <button id="show-more-btn" class="btn btn-primary" onclick="showMoreSections()">Show More</button>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php include 'button.php'; ?>
    </div>
</section>
<style>
    .project-count-number {
        background-color: #000;
        color: #fff;
        border-radius: 50%;
        width: 20px;
        height: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 12px;
        font-weight: 700;
        padding: 12px;
    }
</style>

<script>
    function showMoreSections() {
        document.querySelectorAll('.curriculum-section').forEach(function(section, index) {
            if (index >= 2) {
                section.style.display = 'block';
            }
        });
        document.getElementById('show-more-btn').style.display = 'none';
    }
</script>