<?php
$section = $sections['section_1'] ?? [];

$title  = $section['title'] ?? [];
$points = $section['points'] ?? [];

// Split points into 2 equal columns
$columns = array_chunk($points, ceil(count($points) / 2));
?>

<section class="content-section content-main-setion-1">
    <div class="container">
        <div class="row justify-content-center align-content-center">

            <!-- TITLE -->
            <div class="col-sm-8 text-center">
                <h2 class="mt-0 text-white"><?= $title; ?></h2>
            </div>

            <!-- LEFT COLUMN -->
            <div class="col-12 col-lg-6">
                <div class="content-section-1">
                    <ul class="list-group list-group-flush">
                        <?php if (!empty($columns[0])): ?>
                            <?php foreach ($columns[0] as $point): ?>
                                <li class="list-group-item section-1-li d-flex border-0 p-0">
                                    <span><?= $point; ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

            <!-- RIGHT COLUMN -->
            <div class="col-12 col-lg-6">
                <div class="content-section-1">
                    <ul class="list-group list-group-flush">
                        <?php if (!empty($columns[1])): ?>
                            <?php foreach ($columns[1] as $point): ?>
                                <li class="list-group-item section-1-li d-flex border-0 p-0">
                                    <span><?= $point; ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>

<style>
    .content-main-setion-1 {
        background: radial-gradient(circle at top, #1c2749 0%, #141d39 60%);
    }

    .content-section-1 {
        background: linear-gradient(180deg, rgba(255, 255, 255, 0.08), rgba(255, 255, 255, 0.02));
        border-radius: 18px;
        padding: 25px;
        box-shadow: 0 20px 40px rgba(0, 0, 0, 0.35);
        border: 1px solid rgba(255, 255, 255, 0.08);
    }

    /* BULLET LIST ITEM */
    .section-1-li {
        background: transparent !important;
        margin-bottom: 16px;
        color: #ffffff;
        font-size: 16px;
        align-items: center;
    }

    /* ICON BULLET */
    .section-1-li span {
        position: relative;
        padding-left: 38px;
        display: block;
        line-height: 1.6;
    }

    /* CHECK BULLET CIRCLE */
    .section-1-li span::before {
    content: "✔";
    width: 26px;
    height: 26px;
    background: linear-gradient(145deg, #FFD700, #FFB700);
    color: #4a2e00;
    border-radius: 50%;
    font-size: 13px;
    font-weight: bold;
    display: flex;
    align-items: center;
    justify-content: center;
    position: absolute;
    left: 10px;
    box-shadow: 0 0 12px rgba(255, 215, 0, 0.7);
}

</style>