<?php
$section = $sections['section_2'] ?? [];

$main_title = $section['main_title'] ?? 'Make your Device Manage Everything For you';
$items      = $section['items'] ?? [];
$image      = $section['image'] ?? 'uploads/sections/default.png';

// Split items into 2 equal columns
$columns = array_chunk($items, ceil(count($items) / 2));
?>

<section class="content-section primary-bg">
    <div class="container">
        <div class="row justify-content-between">

            <div class="col-sm-12 text-center">
                <h2 class="mt-0 text-white"><?= $main_title; ?></h2>
            </div>

            <!-- LEFT CONTENT -->
            <div class="col-12 col-lg-8">
                <div class="content">


                    <div class="row">

                        <!-- LEFT LIST -->
                        <div class="col-sm-6">
                            <ul class="list-group list-group-flush section-2">

                                <?php if (!empty($columns[0])): ?>
                                    <?php foreach ($columns[0] as $item): ?>
                                        <li class="list-group-item section-2-li d-flex align-items-center border-0">

                                            <!-- Icon Box -->
                                            <div class="icon-box me-3">
                                                <div class="icon shadow-sm">
                                                    <span class="material-symbols-outlined">tab_inactive</span>
                                                </div>
                                            </div>

                                            <span class="text-white">
                                                <h4 class="text-white mb-2">
                                                    <?= $item['title'] ?? ''; ?>
                                                </h4>
                                                <p>
                                                    <?= $item['description'] ?? ''; ?>
                                                </p>
                                            </span>

                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                            </ul>
                        </div>

                        <!-- RIGHT LIST -->
                        <div class="col-sm-6">
                            <ul class="list-group list-group-flush section-2">

                                <?php if (!empty($columns[1])): ?>
                                    <?php foreach ($columns[1] as $item): ?>
                                        <li class="list-group-item section-2-li d-flex align-items-center border-0">

                                            <!-- Icon Box -->
                                            <div class="icon-box me-3">
                                                <div class="icon shadow-sm">
                                                    <span class="material-symbols-outlined">tab_inactive</span>
                                                </div>
                                            </div>

                                            <span class="text-white">
                                                <h4 class="text-white mb-2">
                                                    <?= $item['title'] ?? ''; ?>
                                                </h4>
                                                <p>
                                                    <?= $item['description'] ?? ''; ?>
                                                </p>
                                            </span>

                                        </li>
                                    <?php endforeach; ?>
                                <?php endif; ?>

                            </ul>
                        </div>

                    </div>
                </div>
            </div>

            <!-- RIGHT IMAGE -->
            <div class="col-12 col-lg-4 d-none d-md-block">
                <img src="<?= base_url($image); ?>" alt="Section Image" class="img-fluid">
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>