<?php
$section = $sections['section_3'] ?? [];

$title  = $section['title'] ?? 'Easily communicate with clients using sApp.';
$points = $section['points'] ?? [];
$image  = $section['image'] ?? 'uploads/default.png';
?>

<section class="content-section">
    <div class="container">
        <div class="row justify-content-between">
            <div class="col-sm-12 text-center">
                <h2 class="mt-0"><?= $title; ?></h2>
            </div>
            <!-- LEFT IMAGE -->
            <div class="col-12 col-lg-6">
                <img src="<?= base_url($image); ?>" alt="Section Image" class="img-fluid">
            </div>

            <!-- RIGHT CONTENT -->
            <div class="col-12 col-lg-6">
                <div class="content">
                    <!-- POINTS LIST -->
                    <ul class="list-group list-group-flush section-3">

                        <?php if (!empty($points)): ?>
                            <?php foreach ($points as $point): ?>
                                <li class="list-group-item d-flex border-0 p-0">

                                    <div class="icon layout-2 align-items-start mt-1 me-2">
                                        <span class="material-symbols-outlined">task_alt</span>
                                    </div>

                                    <span><?= $point; ?></span>

                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>

                    </ul>

                </div>
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>