<?php 
$section = $sections['section_6'] ?? [];

$title = $section['title'] ?? 'Easily communicate with clients using sApp.';
$video = youtube_embed_url($section['video_link'] ?? 'https://www.youtube.com/watch?v=muDpH2Ty2tg');
?>

<section class="content-section primary-bg tech-feature">
    <div class="container">
        <div class="row justify-content-center">

            <!-- TITLE -->
            <div class="col-sm-8 text-center">
                <h2 class="mt-0 text-white"><?= $title; ?></h2>
            </div>

            <!-- VIDEO -->
            <div class="col-12 col-lg-8">
                <iframe 
                    width="100%" 
                    height="480" 
                    src="<?= $video; ?>" 
                    title="YouTube Video"
                    frameborder="0" 
                    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" 
                    referrerpolicy="strict-origin-when-cross-origin" 
                    allowfullscreen>
                </iframe>
            </div>

        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>
