<?php
$section = $sections['pricing_section'] ?? [];

$title = $section['title'] ?? 'Unlock Full Power Of sApp';
$plans = $section['plans'] ?? [];
?>

<section id="pricing" class="price-plan-area primary-bg pb-5">

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 col-md-10 col-lg-7">
                <!-- Intro -->
                <div class="intro text-center mb-4 mt-5">
                    <h2 class="title mt-0 text-white"><?= $title; ?></h2>
                </div>
            </div>
        </div>
        <!-- PRICING PLANS -->
        <div class="row justify-content-center">
            <div class="col-12 col-sm-12 col-lg-12">
                <div class="row items">

                    <?php if (!empty($plans)): ?>
                        <?php foreach ($plans as $plan): ?>

                            <?php
                            // Skip empty plans safely
                            if (empty($plan['name']) || empty($plan['price'])) continue;
                            ?>

                            <div class="col-12 col-md-4 item">
                                <div class="pricing-table text-center wow fadeInLeft" data-aos-duration="2s" data-wow-delay="0.4s">

                                    <!-- PLAN NAME -->
                                    <span class="package-type d-block mt-3"><?= $plan['name']; ?></span>
                                    <h2 class="package-price clip-text text-effect my-3"><small>₹</small><?= number_format($plan['price']); ?></h2>

                                    <!-- FEATURES -->
                                    <ul class="package-list list-group list-group-flush">
                                        <?php if (!empty($plan['features'])): ?>
                                            <?php foreach ($plan['features'] as $feature): ?>
                                                <li class="list-group-item">
                                                    <?= $feature; ?>
                                                </li>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </ul>

                                    <!-- BUTTON -->
                                    <a href="#" class="btn btn-primary">
                                        Choose Plan
                                    </a>

                                </div>
                            </div>

                        <?php endforeach; ?>
                    <?php endif; ?>

                </div>
            </div>
        </div>
    </div>

    <?php include 'cta_button.php'; ?>
</section>