<?php 
$faq = $sections['faq_section'] ?? [];

$heading = $faq['heading'] ?? 'Frequently Asked Questions';
$items   = $faq['items'] ?? [];
?>

<section class="faq pt-5 pb-5 faq-dark">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-12 col-md-10 col-lg-7">
				<div class="intro text-center">
					<h2 class="title mt-0"><?= $heading; ?></h2>
				</div>
			</div>
		</div>

		<div class="row justify-content-center">
			<div class="col-12 col-md-10">
				<div class="accordion" id="faqAccordion">

					<?php if (!empty($items)): ?>
						<?php foreach ($items as $key => $item): 
							$collapseId = 'faq' . ($key + 1);
						?>

					<!-- Item -->
					<div class="faq-item">
						<button class="faq-question <?= $key == 0 ? '' : 'collapsed'; ?>" data-bs-toggle="collapse" data-bs-target="#<?= $collapseId; ?>">
							<?= $item['question'] ?? ''; ?>
							<span class="icon">+</span>
						</button>
						<div id="<?= $collapseId; ?>" class="collapse <?= $key == 0 ? 'show' : ''; ?>" data-bs-parent="#faqAccordion">
							<div class="faq-answer">
								<?= $item['answer'] ?? ''; ?>
							</div>
						</div>
					</div>

						<?php endforeach; ?>
					<?php endif; ?>

				</div>
			</div>
		</div>
	</div>
	<?php include 'cta_button.php'; ?>
</section>

<style>
	.faq-dark .faq-item {
	margin-bottom: 15px;
	border-radius: 8px;
	overflow: hidden;
}

.faq-dark .faq-question {
	width: 100%;
	background: #132c4b;
	color: #fff;
	border: none;
	padding: 18px 20px;
	text-align: left;
	font-size: 19px;
	font-weight: 500;
	display: flex;
	justify-content: space-between;
	align-items: center;
	cursor: pointer;
	border-radius: 6px;
}

.faq-dark .faq-question .icon {
	font-size: 24px;
	font-weight: bold;
	transition: 0.3s;
}

.faq-dark .faq-question:not(.collapsed) {
	background: #0f2340;
}

.faq-dark .faq-question:not(.collapsed) .icon {
	transform: rotate(45deg); /* turns + into × */
}

.faq-dark .faq-answer {
	padding: 18px 20px;
	background: #f5f7fa;
	color: #000;
	font-size: 16px;
	border-radius: 0 0 6px 6px;
}

</style>