<?php $section = $sections['hero_section'] ?? []; ?>

<section id="home" class="hero-section layout-1 has-overlay overlay-gradient pb-5">
    <div class="container">
        <div class="row justify-content-center align-items-center d-flex">
            <div class="col-12 col-md-12 col-lg-12">
                <!-- Hero Content -->
                <div class="hero-content">
                    <?php if ($section['title']): ?>
                        <h1><?php echo $section['title']; ?></h1>
                    <?php endif; ?>
                    <?php if ($section['subtitle']): ?>
                        <p class="pt-3"><?php echo $section['subtitle']; ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <?php if ($section['description']): ?>
                <div class="col-sm-8 text-center">
                    <div class="description">
                        <h3><?php echo $section['description']; ?></h3>
                    </div>
                </div>
            <?php endif; ?>
            <?php if ($section['button_url']): ?>
                <div class="col-12 col-md-12 col-lg-12 mt-4">
                    <!-- Hero Thumb -->
                    <div class="hero-thumb mx-auto" data-aos="fade-left" data-aos-delay="500" data-aos-duration="1000">
                        <iframe width="100%" height="480" src="<?php echo youtube_embed_url($section['button_url'])?>" title="Digital Marketing in 5 Minutes | Digital Marketing for Beginners in Hindi" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php include 'cta_button.php'; ?>
</section>