
<script async src="<?php echo base_url(); ?>assets/front/js//schema_markup.js" type="text/javascript"></script>
<script type="text/javascript">
$(document).ready(function() {
  $.getScript("<?php echo base_url(); ?>assets/front/js/schema_markup.js", function() {
  });
});</script>
<div class="cover-image bg-background" data-bs-image-src="<?php echo base_url()?>uploads/banner1.jpg" style="background: url(&quot;<?php echo base_url()?>uploads/banner1.jpg&quot;) center center;">
				<!--Section-->
	<div>
		<div class="sptb-1">
			<div class="header-text1 mb-0">
				<div class="container">
					<div class="row">
						<h1 class="text-center text-white"><b>Create Structured Data Markup: The Schema Markup Generator</b></h1>
						<p class="text-center text-white">Use this Schema.org based structured data generator tool to easily create FAQ Page, How-to, Article, Job Posting, Local Business, Product, Event and Person JSON-LD markup.</p>
					</div>
				</div>
			</div><!-- /header-text -->
		</div>
	</div><!--/Section-->
</div>

<!--Breadcrumb-->
<div class="relative">
	<div class="shape overflow-hidden text-white">
		<svg viewBox="0 0 2880 48" fill="none" xmsns="http://www.w3.org/2000/svg">
			<path d="M0 48H1437.5H2880V0H2160C1442.5 52 720 0 720 0H0V48Z" fill="<?php echo $visual_setting->color_2?>"></path>
		</svg>
	</div>
</div>
<section class="sptb">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div id="panels" v-cloak="">
                        <span class="lbl_top" style="margin: 0 0 3px; display: inline-block;">Which Schema would you like to create?</span>
                        <br>
                        <select v-model="selected" class="select_ovast">
                           <option v-for="option in options" v-bind:value="option.value">
                              {{ option.text }}
                           </option>
                        </select>
                     </div>
                     <br>
                     <div id="person" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="person-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="person-name">
                           </div>
                           <div class="markup_item">
                              <label for="url">URL</label>
                              <input type="text" class="xt_l" v-model="url" id="url" :class="isValidURL(url) ? 'valid' : 'invalid'">
                           </div>
                           <div class="markup_item">
                              <label for="picture_url">Image URL</label>
                              <input type="text" class="xt_l" v-model="picture_url" id="picture_url" :class="isValidURL(picture_url) ? 'valid' : 'invalid'">
                           </div>
                           <div class="markup_item">
                              <label for="job_title">Job Title</label>
                              <input type="text" class="xt_l" v-model="job_title" id="job_title">
                           </div>
                           <div class="markup_item">
                              <label for="company">Company</label>
                              <input type="text" class="xt_l" v-model="company" id="company">
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Social Profiles</div>
                              <ul>
                                 <li v-for="(profile, idx) in social_profiles">
                                    <label>
                                    <input type="text" placeholder="URL" v-model="profile.url" :class="isValidURL(profile.url) ? 'xt_p valid' : 'xt_p invalid'">
                                    </label>
                                    <button @click="removeProfile(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewProfile">+ Add Profile</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#person textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#person textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#person textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="faq" class="panel" v-cloak="">
                        <div class="f_left">
                           <ul>
                              <li v-for="(q, idx) in questions">
                                 <div class="markup_section_wrap">
                                    <div class="markup_item">
                                       <label>
                                       <span>Question #{{idx+1}}</span>
                                       <input type="text" class="xt_l" v-model="q.question" placeholder="Question">
                                       </label>
                                    </div>
                                    <div class="markup_item">
                                       <label>
                                       <span>Answer #{{idx+1}}</span>
                                       <input type="text" class="xt_p" v-model="q.answer" placeholder="Answer">
                                       <button @click="removeQuestion(idx)">X</button>
                                       </label>
                                    </div>
                                 </div>
                              </li>
                           </ul>
                           <button @click="addNewQuestion">+ Add Question</button>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#faq textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#faq textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#faq textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="howto" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="howto-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="howto-name">
                           </div>
                           <div class="markup_item">
                              <label for="description">Description</label>
                              <input type="text" class="xt_l" v-model="description" id="description">
                           </div>
                           <div class="markup_item">
                              <label for="totalTime">Total Time</label>
                              <input type="text" v-model="totalTime" id="totalTime" placeholder="Minutes">
                           </div>
                           <div class="markup_item">
                              <label for="estimatedCost">Estimated Cost</label>
                              <input type="text" v-model="estimatedCost" id="estimatedCost">
                           </div>
                           <div class="markup_item">
                              <label for="currency">Currency</label>
                              <input type="text" v-model="currency" id="currency">
                           </div>
                           <div class="markup_item">
                              <label for="image">Image URL</label>
                              <input type="text" class="xt_l" v-model="image" id="image" :class="isValidURL(image) ? 'valid' : 'invalid'">
                           </div>
                           <div class="markup_section_wrap">
                              <ul>
                                 <li v-for="(s, idx) in supplies">
                                    <label>
                                    <input type="text" v-model="s.text" placeholder="Supply">
                                    </label>
                                    <button @click="removeSupply(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewSupply">+ Add Supply</button>
                           </div>
                           <div class="markup_section_wrap">
                              <ul>
                                 <li v-for="(t, idx) in tools">
                                    <label>
                                    <input type="text" v-model="t.text" placeholder="Tool">
                                    </label>
                                    <button @click="removeTool(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewTool">+ Add Tool</button>
                           </div>
                           <div class="markup_section_wrap">
                              <ul>
                                 <li v-for="(s, idx) in steps">
                                    <div class="inner_step_wrap">
                                       <div class="inner_title">Step #{{ idx+1 }} <button @click="removeStep(idx)">X</button></div>
                                       <label>
                                       <input type="text" v-model="s.name" placeholder="Name">
                                       </label>
                                       <br>
                                       <label>
                                       <input type="text" v-model="s.url" placeholder="URL" class="xt_l">
                                       </label>
                                       <br>
                                       <label>
                                       <input type="text" v-model="s.image" placeholder="Image URL" class="xt_l">
                                       </label>
                                       <br>
                                       <label>
                                       <textarea cols="30" rows="10" v-model="s.text" placeholder="Instructions"></textarea>
                                       </label>
                                    </div>
                                 </li>
                              </ul>
                              <button @click="addNewStep">+ Add Step</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#howto textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#howto textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#howto textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="article" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label>Article Type</label>
                              <select v-model="selected_article_type">
                                 <option v-for="option in article_type" v-bind:value="option.value">
                                    {{ option.text }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item">
                              <label for="article-url" :class="isValidURL(url) ? 'valid' : 'invalid'">URL</label>
                              <input type="text" class="xt_l" v-model="url" id="article-url" :class="isValidURL(url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="article-headline">Article Headline</label>
                              <input type="text" placeholder="Max of 110 characters" :class="headline.trim().length <= 110 ? 'valid' : 'invalid'" class="xt_l" v-model="headline" id="article-headline">
                              <br>
                              <span :class="headline.trim().length > 110 ? 'error_msg' : ''">{{headline.trim().length}} / 110</span>
                           </div>
                           <div class="markup_item">
                              <label for="article-description">Description</label>
                              <input type="text" class="xt_l" v-model="description" id="article-description">
                           </div>
                           <div class="markup_item">
                              <label for="article-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">Image URL</label>
                              <input type="text" class="xt_l" v-model="image_url" id="article-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(image_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="article-image_width">Image Width</label>
                              <input type="text" placeholder=">= 696px" :class="!image_width.length || image_width >= 696 ? 'valid' : 'invalid'" class="xt_l" v-model="image_width" id="article-image_width">
                           </div>
                           <div class="markup_item">
                              <label for="article-image_height">Image Height</label>
                              <input type="text" class="xt_l" v-model="image_height" id="article-image_height">
                           </div>
                           <div class="markup_item">
                              <label>Author Type</label>
                              <select v-model="selected_author_type">
                                 <option v-for="option in author_type" v-bind:value="option.value">
                                    {{ option.text }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item">
                              <label for="article-author_name">Author Name</label>
                              <input type="text" class="xt_l" v-model="author_name" id="article-author_name">
                           </div>
                           <div class="markup_item">
                              <label for="article-publisher_name">Publisher Name</label>
                              <input type="text" class="xt_l" v-model="publisher_name" id="article-publisher_name">
                           </div>
                           <div class="markup_item">
                              <label for="article-publisher_logo_url" :class="isValidURL(publisher_logo_url) ? 'valid' : 'invalid'">Publisher Logo URL</label>
                              <input type="text" class="xt_l" v-model="publisher_logo_url" id="article-publisher_logo_url" :class="isValidURL(publisher_logo_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(publisher_logo_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="article-publisher_logo_width">Publisher Logo Width</label>
                              <input type="text" class="xt_l" placeholder="<= 600px" :class="publisher_logo_width <= 600 ? 'valid' : 'invalid'" v-model="publisher_logo_width" id="article-publisher_logo_width">
                           </div>
                           <div class="markup_item">
                              <label for="article-publisher_logo_height">Publisher Logo Height</label>
                              <input type="text" class="xt_l" placeholder="<= 60px" :class="publisher_logo_height <= 60 ? 'valid' : 'invalid'" v-model="publisher_logo_height" id="article-publisher_logo_height">
                           </div>
                           <div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label>Date Published</label>
                                 <input type="text" id="article-datepicker-datePublished-btn" placeholder="YYYY-MM-DD" v-model="date_published">
                                 <div id="article-datepicker-datePublished" style="display: none;"></div>
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label>Date Modified</label>
                                 <input type="text" id="article-datepicker-dateModified-btn" placeholder="YYYY-MM-DD" v-model="date_modified">
                                 <div id="article-datepicker-dateModified" style="display: none;"></div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#article textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#article textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#article textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="jobposting" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="jobposting-job_title">Job Title</label>
                              <input type="text" class="xt_l" v-model="job_title" id="jobposting-job_title">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-job_id">Identifier</label>
                              <input type="text" class="xt_l" v-model="job_id" id="jobposting-job_id">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-job_description">Job Description</label>
                              <input type="text" class="xt_l" v-model="job_description" id="jobposting-job_description">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-company_name">Company</label>
                              <input type="text" class="xt_l" v-model="company_name" id="jobposting-company_name">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-company_url" :class="isValidURL(company_url) ? 'valid' : 'invalid'">Company URL</label>
                              <input type="text" class="xt_l" v-model="company_url" id="jobposting-company_url" :class="isValidURL(company_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(company_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-industry">Industry</label>
                              <input type="text" class="xt_l" v-model="industry" id="jobposting-industry">
                           </div>
                           <div class="markup_item">
                              <label>Employment Type</label>
                              <select v-model="selected_employment_type">
                                 <option v-for="option in employment_type" v-bind:value="option.value">
                                    {{ option.text }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-work_hours">Work hours (e.g. 8am-5pm, shift)</label>
                              <input type="text" class="xt_l" v-model="work_hours" id="jobposting-work_hours">
                           </div>
                           <div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label>Date Posted</label>
                                 <input type="text" id="jobposting-datepicker-date_posted-btn" placeholder="YYYY-MM-DD" v-model="date_posted">
                                 <div id="jobposting-datepicker-date_posted" style="display: none;"></div>
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label>Valid Through</label>
                                 <input type="text" id="jobposting-datepicker-valid_through-btn" placeholder="YYYY-MM-DD" v-model="valid_through">
                                 <div id="jobposting-datepicker-valid_through" style="display: none;"></div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-country_code">Country Code</label>
                              <input type="text" class="xt_l" v-model="country_code" id="jobposting-country_code">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-region_code">Region Code</label>
                              <input type="text" class="xt_l" v-model="region_code" id="jobposting-region_code">
                           </div>
                           <div class="markup_item">
                              <input type="checkbox" v-model="remote_job" id="jobposting-remote_job">
                              <label for="jobposting-remote_job" style="display: inline-block;">Remote Job</label>
                           </div>
                           <div v-show="!remote_job">
                              <div class="markup_item">
                                 <label for="jobposting-street">Street</label>
                                 <input type="text" class="xt_l" v-model="street" id="jobposting-street">
                              </div>
                              <div class="markup_item">
                                 <label for="jobposting-city">City</label>
                                 <input type="text" class="xt_l" v-model="city" id="jobposting-city">
                              </div>
                              <div class="markup_item">
                                 <label for="jobposting-zip_code">Zip Code</label>
                                 <input type="text" class="xt_l" v-model="zip_code" id="jobposting-zip_code">
                              </div>
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-min_salary">Salary (or min. salary)</label>
                              <input type="text" class="xt_l" v-model="min_salary" id="jobposting-min_salary">
                           </div>
                           <div v-show="min_salary.trim().length">
                              <div class="markup_item">
                                 <label for="jobposting-max_salary">Max. Salary</label>
                                 <input type="text" class="xt_l" v-model="max_salary" id="jobposting-max_salary">
                              </div>
                              <div class="markup_item">
                                 <label for="jobposting-currency_code">Currency Code</label>
                                 <input type="text" class="xt_l" v-model="currency_code" id="jobposting-currency_code">
                              </div>
                              <div class="markup_item">
                                 <label>Payment Unit</label>
                                 <select v-model="selected_payment_unit">
                                    <option v-for="option in payment_unit" v-bind:value="option.value">
                                       {{ option.text }}
                                    </option>
                                 </select>
                              </div>
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-responsibilities">Responsibilities</label>
                              <input type="text" class="xt_l" v-model="responsibilities" id="jobposting-responsibilities">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-skills">Skills</label>
                              <input type="text" class="xt_l" v-model="skills" id="jobposting-skills">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-qualifications">Qualifications</label>
                              <input type="text" class="xt_l" v-model="qualifications" id="jobposting-qualifications">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-education_requirements">Education Requirements</label>
                              <input type="text" class="xt_l" v-model="education_requirements" id="jobposting-education_requirements">
                           </div>
                           <div class="markup_item">
                              <label for="jobposting-experience_requirements">Experience Requirements</label>
                              <input type="text" class="xt_l" v-model="experience_requirements" id="jobposting-experience_requirements">
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#jobposting textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#jobposting textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#jobposting textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="event" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="event-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="event-name">
                           </div>
                           <div class="markup_item">
                              <label for="event-description">Description</label>
                              <input type="text" class="xt_l" v-model="description" id="event-description">
                           </div>
                           <div class="markup_item">
                              <label for="event-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">Image URL</label>
                              <input type="text" class="xt_l" v-model="image_url" id="event-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(image_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label>Start Date</label>
                                 <input type="text" id="event-datepicker-start_date-btn" placeholder="YYYY-MM-DD" v-model="start_date">
                                 <div id="event-datepicker-start_date" style="display: none;"></div>
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="event-start_time">Start Time</label>
                                 <input type="text" class="" v-model="start_time" id="event-start_time" :class="!start_time || isValidTime(start_time) ? 'valid' : 'invalid'">
                                 <div v-if="start_time && !isValidTime(start_time)" class="error_msg">Invalid Time (00:00 - 23:59)</div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label>End Date</label>
                                 <input type="text" id="event-datepicker-end_date-btn" placeholder="YYYY-MM-DD" v-model="end_date">
                                 <div id="event-datepicker-end_date" style="display: none;"></div>
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="event-end_time">End Time</label>
                                 <input type="text" class="" v-model="end_time" id="event-end_time" :class="!end_time || isValidTime(end_time) ? 'valid' : 'invalid'">
                                 <div v-if="end_time && !isValidTime(end_time)" class="error_msg">Invalid Time (00:00 - 23:59)</div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div class="markup_item">
                              <label>Performer Type</label>
                              <select v-model="selected_performer_type">
                                 <option v-for="option in performer_type" v-bind:value="option.value">
                                    {{ option.text }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item" v-show="selected_performer_type">
                              <label for="event-performer_name">Performer Name</label>
                              <input type="text" class="xt_l" v-model="performer_name" id="event-performer_name">
                           </div>
                           <div class="markup_item">
                              <label for="event-venue_name">Venue Name</label>
                              <input type="text" class="xt_l" v-model="venue_name" id="event-venue_name">
                           </div>
                           <div class="markup_item">
                              <label for="event-street">Street</label>
                              <input type="text" class="xt_l" v-model="street" id="event-street">
                           </div>
                           <div class="markup_item">
                              <label for="event-city">City</label>
                              <input type="text" class="xt_l" v-model="city" id="event-city">
                           </div>
                           <div class="markup_item">
                              <label for="event-zip_code">Zip Code</label>
                              <input type="text" class="xt_l" v-model="zip_code" id="event-zip_code">
                           </div>
                           <div class="markup_item">
                              <label for="event-country_code">Country Code</label>
                              <input type="text" class="xt_l" v-model="country_code" id="event-country_code">
                           </div>
                           <div class="markup_item">
                              <label for="event-region_code">Region Code</label>
                              <input type="text" class="xt_l" v-model="region_code" id="event-region_code">
                           </div>
                           <div class="markup_item">
                              <label for="event-currency_code">Currency Code</label>
                              <input type="text" class="xt_l" v-model="currency_code" id="event-currency_code">
                           </div>
                           <div class="markup_section_wrap">
                              <span v-show="tickets.length" style="font-weight: bold;">Tickets</span>
                              <ul>
                                 <li v-for="(t, idx) in tickets">
                                    <div class="inner_step_wrap">
                                       <span>Ticket {{ (idx+1) }}</span>
                                       <div class="markup_item">
                                          <label>Name
                                          <input type="text" v-model="t.name" placeholder="Name" class="xt_l">
                                          </label>
                                       </div>
                                       <div class="markup_item">
                                          <label>Price
                                          <input type="text" v-model="t.price" placeholder="Price" class="xt_l">
                                          </label>
                                       </div>
                                       <div class="markup_item">
                                          <label>URL
                                          <input type="text" v-model="t.url" placeholder="URL" class="xt_l">
                                          </label>
                                       </div>
                                       <div>
                                          <div class="markup_item f_left" style="width: 50%;">
                                             <label>Availability</label>
                                             <select v-model="t.availability">
                                                <option v-for="option in availability_type" v-bind:value="option.value">
                                                   {{ option.text }}
                                                </option>
                                             </select>
                                          </div>
                                          <div class="markup_item f_left" style="width: 50%;">
                                             <label>Available From</label>
                                             <input type="text" @click="open_datepicker(idx, t)" placeholder="YYYY-MM-DD" v-model="t.available_from">
                                             <div :class="['available_from', idx.toString()]" style="display: none;"></div>
                                          </div>
                                          <div class="clear_div"></div>
                                       </div>
                                       <div class="inner_title"><button @click="removeTicket(idx)">X</button></div>
                                    </div>
                                 </li>
                              </ul>
                              <button @click="addNewTicket">+ Add Ticket</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#event textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#event textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#event textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="localbusiness" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="localbusiness-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="localbusiness-name">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">Image URL</label>
                              <input type="text" class="xt_l" v-model="image_url" id="localbusiness-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(image_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-id" :class="isValidURL(id) ? 'valid' : 'invalid'">Id (URL)</label>
                              <input type="text" class="xt_l" v-model="id" id="localbusiness-id" :class="isValidURL(id) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(id)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-url" :class="isValidURL(url) ? 'valid' : 'invalid'">URL</label>
                              <input type="text" class="xt_l" v-model="url" id="localbusiness-url" :class="isValidURL(url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-phone">Phone</label>
                              <input type="text" class="xt_l" v-model="phone" id="localbusiness-phone">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-price_range">Price Range</label>
                              <input type="text" class="xt_l" v-model="price_range" id="localbusiness-price_range">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-street">Street</label>
                              <input type="text" class="xt_l" v-model="street" id="localbusiness-street">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-city">City</label>
                              <input type="text" class="xt_l" v-model="city" id="localbusiness-city">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-zip_code">Zip Code</label>
                              <input type="text" class="xt_l" v-model="zip_code" id="localbusiness-zip_code">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-country_code">Country Code</label>
                              <input type="text" class="xt_l" v-model="country_code" id="localbusiness-country_code">
                           </div>
                           <div class="markup_item">
                              <label for="localbusiness-region_code">Region Code</label>
                              <input type="text" class="xt_l" v-model="region_code" id="localbusiness-region_code">
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Social Profiles</div>
                              <ul>
                                 <li v-for="(profile, idx) in social_profiles">
                                    <label>
                                    <input type="text" placeholder="URL" v-model="profile.url" :class="isValidURL(profile.url) ? 'xt_p valid' : 'xt_p invalid'">
                                    </label>
                                    <button @click="removeProfile(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewProfile">+ Add Profile</button>
                           </div>
                           <div class="markup_item">
                              <input type="checkbox" v-model="open_24_7" id="localbusiness-open_24_7">
                              <label for="localbusiness-open_24_7" style="display: inline-block;">Open 24/7</label>
                           </div>
                           <div class="markup_section_wrap" v-show="!open_24_7">
                              <span v-show="opening_hours.length" style="font-weight: bold;">Opening Hours</span>
                              <ul>
                                 <li v-for="(h, idx) in opening_hours">
                                    <div class="inner_step_wrap">
                                       <span># {{ (idx+1) }}</span>
                                       <br>
                                       <div>
                                          <div class="markup_item f_left" style="width: 45%;">
                                             <label>Opens At <br>
                                             <input type="text" v-model="h.opens_at" :class="!h.opens_at || isValidTime(h.opens_at) ? 'valid' : 'invalid'">
                                             </label>
                                             <div v-if="h.opens_at && !isValidTime(h.opens_at)" class="error_msg">Invalid Time (00:00 - 23:59)</div>
                                          </div>
                                          <div class="markup_item f_left" style="width: 45%;">
                                             <label>Closes At <br>
                                             <input type="text" v-model="h.closes_at" :class="!h.closes_at || isValidTime(h.closes_at) ? 'valid' : 'invalid'">
                                             </label>
                                             <div v-if="h.closes_at && !isValidTime(h.closes_at)" class="error_msg">Invalid Time (00:00 - 23:59)</div>
                                          </div>
                                          <div class="clear_div"></div>
                                       </div>
                                       <div v-for="day in days_of_week">
                                          <label><input type="checkbox" :value="day" v-model="h.days"> {{ day }}</label>
                                       </div>
                                       <div class="inner_title"><button @click="removeHours(idx)">X</button></div>
                                    </div>
                                 </li>
                              </ul>
                              <button @click="addNewHours">+ Add Opening Hours</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#localbusiness textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#localbusiness textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#localbusiness textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="product" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="product-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="product-name">
                           </div>
                           <div class="markup_item">
                              <label for="product-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">Image URL</label>
                              <input type="text" class="xt_l" v-model="image_url" id="product-image_url" :class="isValidURL(image_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(image_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="product-brand">Brand</label>
                              <input type="text" class="xt_l" v-model="brand" id="product-brand">
                           </div>
                           <div class="markup_item">
                              <label for="product-description">Description</label>
                              <input type="text" class="xt_l" v-model="description" id="product-description">
                           </div>
                           <div class="markup_section_wrap">
                              <div class="f_left" style="width: 48%;">
                                 <div class="item_title">ID Properties</div>
                                 <div class="markup_item">
                                    <label for="product-id_props-sku">sku</label>
                                    <input type="text" class="" v-model="id_properties.sku" id="product-id_props-sku">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-id_props-gtin8">gtin8</label>
                                    <input type="text" class="" v-model="id_properties.gtin8" id="product-id_props-gtin8">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-id_props-gtin13">gtin13</label>
                                    <input type="text" class="" v-model="id_properties.gtin13" id="product-id_props-gtin13">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-id_props-gtin14">gtin14</label>
                                    <input type="text" class="" v-model="id_properties.gtin14" id="product-id_props-gtin14">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-id_props-mpn">mpn</label>
                                    <input type="text" class="" v-model="id_properties.mpn" id="product-id_props-mpn">
                                 </div>
                              </div>
                              <div class="f_left" style="width: 48%;">
                                 <div class="item_title">Aggregate Rating</div>
                                 <div class="markup_item">
                                    <label for="product-agg_rating-value">Aggregate rating value</label>
                                    <input type="text" class="" v-model="agg_rating.value" id="product-agg_rating-value">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-agg_rating-count">Number of ratings</label>
                                    <input type="text" class="" v-model="agg_rating.count" id="product-agg_rating-count">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-agg_rating-best">Highest value allowed</label>
                                    <input type="text" class="" v-model="agg_rating.best" id="product-agg_rating-best">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-agg_rating-worst">Lowest value allowed</label>
                                    <input type="text" class="" v-model="agg_rating.worst" id="product-agg_rating-worst">
                                 </div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div class="markup_item">
                              <label>Offer Type</label>
                              <select v-model="selected_offer_type">
                                 <option v-for="option in offer_type" v-bind:value="option.value">
                                    {{ option.text }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_section_wrap" v-show="selected_offer_type === 'Offer' || selected_offer_type === 'AggregateOffer'">
                              <div class="item_title">{{ selected_offer_type === 'Offer' ? 'Offer' : 'Aggregate Offer' }}</div>
                              <div class="markup_item">
                                 <label for="product-url" :class="isValidURL(url) ? 'valid' : 'invalid'">URL</label>
                                 <input type="text" class="xt_l" v-model="url" id="product-url" :class="isValidURL(url) ? 'valid' : 'invalid'">
                                 <div v-if="!isValidURL(url)" class="error_msg">Invalid URL</div>
                              </div>
                              <div class="markup_item">
                                 <label for="product-currency_code">Currency Code</label>
                                 <input type="text" class="" v-model="currency_code" id="product-currency_code">
                              </div>
                              <div v-show="selected_offer_type === 'Offer'">
                                 <div class="markup_item">
                                    <label for="product-price">Price</label>
                                    <input type="text" class="" v-model="price" id="product-price">
                                 </div>
                                 <div class="markup_item">
                                    <label>Price Valid Until</label>
                                    <input type="text" id="product-datepicker-price_valid_until-btn" placeholder="YYYY-MM-DD" v-model="price_valid_until">
                                    <div id="product-datepicker-price_valid_until" style="display: none;"></div>
                                 </div>
                                 <div class="markup_item">
                                    <label>Condition</label>
                                    <select v-model="selected_condition">
                                       <option v-for="option in condition_types" v-bind:value="option.value">
                                          {{ option.text }}
                                       </option>
                                    </select>
                                 </div>
                                 <div class="markup_item">
                                    <label>Availability</label>
                                    <select v-model="selected_availability">
                                       <option v-for="option in availability_types" v-bind:value="option.value">
                                          {{ option.text }}
                                       </option>
                                    </select>
                                 </div>
                              </div>
                              <div v-show="selected_offer_type === 'AggregateOffer'">
                                 <div class="markup_item">
                                    <label for="product-low_price">Low Price</label>
                                    <input type="text" class="" v-model="low_price" id="product-low_price">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-high_price">High Price</label>
                                    <input type="text" class="" v-model="high_price" id="product-high_price">
                                 </div>
                                 <div class="markup_item">
                                    <label for="product-offer_count">Number Of Offers</label>
                                    <input type="text" class="" v-model="offer_count" id="product-offer_count">
                                 </div>
                              </div>
                           </div>
                           <div class="markup_section_wrap">
                              <span v-show="reviews.length" style="font-weight: bold;">Reviews</span>
                              <ul>
                                 <li v-for="(t, idx) in reviews">
                                    <div class="inner_step_wrap">
                                       <span>Review {{ (idx+1) }}</span>
                                       <div>
                                          <div class="f_left" style="width: 48%;">
                                             <div class="markup_item">
                                                <label>Name</label>
                                                <input type="text" v-model="t.name" placeholder="Name" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Body</label>
                                                <input type="text" v-model="t.body" placeholder="Body" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Rating</label>
                                                <input type="text" v-model="t.rating" placeholder="Rating" class="">
                                             </div>
                                          </div>
                                          <div class="f_left" style="width: 48%;">
                                             <div class="markup_item">
                                                <label>Author</label>
                                                <input type="text" v-model="t.author" placeholder="Author" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Publisher</label>
                                                <input type="text" v-model="t.publisher" placeholder="Publisher" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Date</label>
                                                <input type="text" @click="open_datepicker(idx, t)" placeholder="YYYY-MM-DD" v-model="t.date">
                                                <div :class="['review_date', idx.toString()]" style="display: none;"></div>
                                             </div>
                                          </div>
                                          <div class="clear_div"></div>
                                       </div>
                                       <div class="inner_title"><button @click="removeReview(idx)">X</button></div>
                                    </div>
                                 </li>
                              </ul>
                              <button @click="addNewReview">+ Add Review</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#product textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#product textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#product textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="video" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="video-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="video-name">
                           </div>
                           <div class="markup_item">
                              <label for="video-description">Description</label>
                              <input type="text" class="xt_l" v-model="description" id="video-description">
                           </div>
                           <div class="markup_item">
                              <label>Upload Date</label>
                              <input type="text" id="video-datepicker-upload_date-btn" placeholder="YYYY-MM-DD" v-model="upload_date">
                              <div id="video-datepicker-upload_date" style="display: none;"></div>
                           </div>
                           <div>
                              <div class="item_title">Video Duration</div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="duration_mins">Minutes</label>
                                 <input type="text" v-model="duration.minutes" id="duration_mins" placeholder="Minutes">
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="duration_secs">Seconds</label>
                                 <input type="text" v-model="duration.seconds" id="duration_secs" placeholder="Seconds">
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Thumbnail Url</div>
                              <ul>
                                 <li v-for="(s, idx) in thumbnail_urls">
                                    <label>
                                    <input type="text" v-model="s.text" placeholder="Thumbnail Url" :class="isValidURL(s.text) ? 'valid' : 'invalid'">
                                    </label>
                                    <button @click="removeThumbnailUrl(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewThumbnailUrl">+ Add Thumbnail Url</button>
                           </div>
                           <div class="markup_item">
                              <label for="video-content_url" :class="isValidURL(content_url) ? 'valid' : 'invalid'">Content URL</label>
                              <input type="text" class="xt_l" v-model="content_url" id="video-content_url" :class="isValidURL(content_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(content_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="video-embed_url" :class="isValidURL(embed_url) ? 'valid' : 'invalid'">Embed URL</label>
                              <input type="text" class="xt_l" v-model="embed_url" id="video-embed_url" :class="isValidURL(embed_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(embed_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="video-publisher_name">Publisher Name</label>
                              <input type="text" class="xt_l" v-model="publisher_name" id="video-publisher_name">
                           </div>
                           <div class="markup_item">
                              <label for="video-publisher_logo_url" :class="isValidURL(publisher_logo_url) ? 'valid' : 'invalid'">Publisher Logo URL</label>
                              <input type="text" class="xt_l" v-model="publisher_logo_url" id="video-publisher_logo_url" :class="isValidURL(publisher_logo_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(publisher_logo_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="video-publisher_logo_width">Publisher Logo Width</label>
                              <input type="text" class="xt_l" placeholder="<= 600px" :class="publisher_logo_width <= 600 ? 'valid' : 'invalid'" v-model="publisher_logo_width" id="video-publisher_logo_width">
                           </div>
                           <div class="markup_item">
                              <label for="video-publisher_logo_height">Publisher Logo Height</label>
                              <input type="text" class="xt_l" placeholder="<= 60px" :class="publisher_logo_height <= 60 ? 'valid' : 'invalid'" v-model="publisher_logo_height" id="video-publisher_logo_height">
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#video textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#video textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#video textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="website_sitelinks_searchbox" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="website_sitelinks_searchbox-name">Website Name</label>
                              <input type="text" class="xt_l" v-model="name" id="website_sitelinks_searchbox-name">
                           </div>
                           <div class="markup_item">
                              <label for="website_sitelinks_searchbox-url">URL</label>
                              <input type="text" class="xt_l" v-model="url" id="website_sitelinks_searchbox-url" :class="isValidURL(url) ? 'valid' : 'invalid'">
                           </div>
                           <div class="markup_item">
                              <label for="website_sitelinks_searchbox-search_url">Search URL</label>
                              <input type="text" class="xt_l" v-model="search_url" id="website_sitelinks_searchbox-search_url" :class="isValidURL(search_url) ? 'valid' : 'invalid'" placeholder="Internal site search URL (e.g. https://example.com/search?q=)">
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#website_sitelinks_searchbox textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#website_sitelinks_searchbox textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#website_sitelinks_searchbox textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="recipe" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="recipe-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="recipe-name">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-description">Description</label>
                              <input type="text" class="xt_l" v-model="description" id="recipe-description">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-keywords">Keywords</label>
                              <input type="text" class="xt_l" v-model="keywords" id="recipe-keywords">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-creator">Creator</label>
                              <input type="text" class="xt_l" v-model="creator" id="recipe-creator">
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Images</div>
                              <ul>
                                 <li v-for="(img, idx) in images">
                                    <label>
                                    <input type="text" placeholder="URL" v-model="img.url" :class="isValidURL(img.url) ? 'xt_p valid' : 'xt_p invalid'">
                                    </label>
                                    <button @click="removeImage(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewImage">+ Add Image</button>
                           </div>
                           <div class="markup_item">
                              <label>Category</label>
                              <select v-model="selected_category">
                                 <option v-for="option in category" v-bind:value="option.value">
                                    {{ option.text }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item">
                              <label for="recipe-recipe_cuisine">Cuisine</label>
                              <input type="text" class="xt_l" v-model="recipe_cuisine" id="recipe-recipe_cuisine">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-servings">Servings</label>
                              <input type="text" class="xt_l" v-model="servings" id="recipe-servings">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-prep_time">Preparation (min)</label>
                              <input type="text" class="xt_l" v-model="prep_time" id="recipe-prep_time">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-cook_time">Cooking (min)</label>
                              <input type="text" class="xt_l" v-model="cook_time" id="recipe-cook_time">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-servingSize">Serving Size</label>
                              <input type="text" class="xt_l" v-model="servingSize" id="recipe-servingSize">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-calories">Calories</label>
                              <input type="text" class="xt_l" v-model="calories" id="recipe-calories">
                           </div>
                           <div class="markup_item">
                              <label for="recipe-fatContent">Fat (grams)</label>
                              <input type="text" class="xt_l" v-model="fatContent" id="recipe-fatContent">
                           </div>
                           <div class="markup_section_wrap">
                              <ul>
                                 <li v-for="(t, idx) in instructions">
                                    <label>
                                    <input type="text" v-model="t.text" placeholder="Step">
                                    </label>
                                    <button @click="removeStep(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewStep">+ Add Step</button>
                           </div>
                           <div class="markup_section_wrap">
                              <ul>
                                 <li v-for="(t, idx) in ingredients">
                                    <label>
                                    <input type="text" v-model="t.text" placeholder="Ingredient">
                                    </label>
                                    <button @click="removeIngredient(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewIngredient">+ Add Ingredient</button>
                           </div>
                           <div class="markup_item">
                              <label for="recipe-contentUrl" :class="isValidURL(contentUrl) ? 'valid' : 'invalid'">Video Content URL</label>
                              <input type="text" class="xt_l" v-model="contentUrl" id="recipe-contentUrl" :class="isValidURL(contentUrl) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(contentUrl)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="recipe-embedUrl" :class="isValidURL(embedUrl) ? 'valid' : 'invalid'">Video Embed URL</label>
                              <input type="text" class="xt_l" v-model="embedUrl" id="recipe-embedUrl" :class="isValidURL(embedUrl) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(embedUrl)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label>Date Published</label>
                              <input type="text" id="recipe-datepicker-datePublished-btn" placeholder="YYYY-MM-DD" v-model="datePublished">
                              <div id="recipe-datepicker-datePublished" style="display: none;"></div>
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Aggregate Rating</div>
                              <div class="markup_item">
                                 <label for="recipe-agg_rating-value">Aggregate rating value</label>
                                 <input type="text" class="" v-model="agg_rating.value" id="recipe-agg_rating-value">
                              </div>
                              <div class="markup_item">
                                 <label for="recipe-agg_rating-count">Number of ratings</label>
                                 <input type="text" class="" v-model="agg_rating.count" id="recipe-agg_rating-count">
                              </div>
                              <div class="markup_item">
                                 <label for="recipe-agg_rating-best">Highest value allowed</label>
                                 <input type="text" class="" v-model="agg_rating.best" id="recipe-agg_rating-best">
                              </div>
                              <div class="markup_item">
                                 <label for="recipe-agg_rating-worst">Lowest value allowed</label>
                                 <input type="text" class="" v-model="agg_rating.worst" id="recipe-agg_rating-worst">
                              </div>
                           </div>
                           <div class="markup_section_wrap">
                              <span v-show="reviews.length" style="font-weight: bold;">Reviews</span>
                              <ul>
                                 <li v-for="(t, idx) in reviews">
                                    <div class="inner_step_wrap">
                                       <span>Review {{ (idx+1) }}</span>
                                       <div>
                                          <div class="f_left" style="width: 48%;">
                                             <div class="markup_item">
                                                <label>Name</label>
                                                <input type="text" v-model="t.name" placeholder="Name" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Body</label>
                                                <input type="text" v-model="t.body" placeholder="Body" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Rating</label>
                                                <input type="text" v-model="t.rating" placeholder="Rating" class="">
                                             </div>
                                          </div>
                                          <div class="f_left" style="width: 48%;">
                                             <div class="markup_item">
                                                <label>Author</label>
                                                <input type="text" v-model="t.author" placeholder="Author" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Publisher</label>
                                                <input type="text" v-model="t.publisher" placeholder="Publisher" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Date</label>
                                                <input type="text" @click="open_datepicker(idx, t)" placeholder="YYYY-MM-DD" v-model="t.date">
                                                <div :class="['review_date', idx.toString()]" style="display: none;"></div>
                                             </div>
                                          </div>
                                          <div class="clear_div"></div>
                                       </div>
                                       <div class="inner_title"><button @click="removeReview(idx)">X</button></div>
                                    </div>
                                 </li>
                              </ul>
                              <button @click="addNewReview">+ Add Review</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#recipe textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#recipe textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#recipe textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="organization" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label>Organization Type</label>
                              <select v-model="selected_organization_type" style="width: 100%;" @change="organization_type_changed">
                                 <option v-for="type in organization_types" v-bind:value="type.key">
                                    {{ type.key }} - {{ type.desc }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item" v-show="more_specific_organization_types.length">
                              <label>More Specific Organization Type</label>
                              <select v-model="selected_specific_organization_type" style="width: 100%;">
                                 <option v-for="type in more_specific_organization_types" v-bind:value="type.key">
                                    {{ type.key ? (type.key + ' - ' + type.desc) : type.desc }}
                                 </option>
                              </select>
                           </div>
                           <div class="markup_item">
                              <label for="organization-name">Name</label>
                              <input type="text" class="xt_l" v-model="name" id="organization-name">
                           </div>
                           <div class="markup_item">
                              <label for="organization-alternateName">Alternate Name</label>
                              <input type="text" class="xt_l" v-model="alternateName" id="organization-alternateName">
                           </div>
                           <div class="markup_item">
                              <label for="organization-url" :class="isValidURL(url) ? 'valid' : 'invalid'">URL</label>
                              <input type="text" class="xt_l" v-model="url" id="organization-url" :class="isValidURL(url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="organization-logoUrl" :class="isValidURL(logoUrl) ? 'valid' : 'invalid'">Logo URL</label>
                              <input type="text" class="xt_l" v-model="logoUrl" id="organization-logoUrl" :class="isValidURL(logoUrl) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(logoUrl)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Social Profiles</div>
                              <ul>
                                 <li v-for="(profile, idx) in social_profiles">
                                    <label>
                                    <input type="text" placeholder="URL" v-model="profile.url" :class="isValidURL(profile.url) ? 'xt_p valid' : 'xt_p invalid'" style="min-width: 400px;">
                                    </label>
                                    <button @click="removeProfile(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewProfile">+ Add Profile</button>
                           </div>
                           <div class="markup_section_wrap">
                              <span v-show="contacts.length" style="font-weight: bold;">Contacts</span>
                              <ul>
                                 <li v-for="(t, idx) in contacts">
                                    <div class="inner_step_wrap">
                                       <span>Contact {{ (idx+1) }}</span>
                                       <div>
                                          <div class="f_left" style="width: 48%;">
                                             <div class="markup_item">
                                                <label>Contact Type</label>
                                                <select v-model="t.contact_type">
                                                   <option v-for="option in contact_types" v-bind:value="option.value">
                                                      {{ option.text }}
                                                   </option>
                                                </select>
                                             </div>
                                             <div class="markup_item">
                                                <span class="item_title" style="font-size: 13px;">Options</span>
                                                <div v-for="option in options">
                                                   <label>
                                                   <input type="checkbox" v-bind:value="option.value" v-model="t.options">
                                                   {{ option.text }}
                                                   </label>
                                                </div>
                                             </div>
                                             <div class="markup_item">
                                                <label style="display: inline-block;">Phone</label>
                                                <span class="hint_icon tooltipster tooltipstered" data-hintcontent="Phone number may be entered in any of the following formats: +18005551234 or (425) 123-4567 or ( 33 1) 42 68 53 00"></span>
                                                <br>
                                                <input type="text" v-model="t.phone" placeholder="Phone" class="">
                                             </div>
                                             <div class="markup_item">
                                                <label>Email</label>
                                                <input type="text" v-model="t.email" placeholder="Email" class="">
                                             </div>
                                          </div>
                                          <div class="f_left" style="width: 48%;">
                                             <div class="markup_item markup_section_wrap">
                                                <span class="item_title" style="font-size: 13px;">Areas</span>
                                                <div class="multi-select markup_section_wrap">
                                                   <div v-for="option in areas">
                                                      <label>
                                                      <input type="checkbox" v-bind:value="option.value" v-model="t.areas">
                                                      {{ option.text }}
                                                      </label>
                                                   </div>
                                                </div>
                                             </div>
                                             <div class="markup_item markup_section_wrap">
                                                <span class="item_title" style="font-size: 13px;">Languages</span>
                                                <div class="multi-select markup_section_wrap">
                                                   <div v-for="option in languages">
                                                      <label>
                                                      <input type="checkbox" v-bind:value="option.value" v-model="t.languages">
                                                      {{ option.text }}
                                                      </label>
                                                   </div>
                                                </div>
                                             </div>
                                          </div>
                                          <div class="clear_div"></div>
                                       </div>
                                       <div class="inner_title"><button @click="removeContact(idx)">X</button></div>
                                    </div>
                                 </li>
                              </ul>
                              <button @click="addNewContact">+ Add Contact</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#organization textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#organization textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#organization textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
                     <div id="corona" class="panel" v-cloak="">
                        <div class="f_left">
                           <div class="markup_item">
                              <label for="corona-name">Announcement Name</label>
                              <input type="text" class="xt_l" v-model="name" id="corona-name">
                           </div>
                           <div class="markup_item">
                              <label for="corona-text">Announcement Text</label>
                              <input type="text" class="xt_l" v-model="text" id="corona-text">
                              <!--							<textarea class="xt_l" v-model="text" id="corona-text" rows="10" cols="60"></textarea>-->
                           </div>
                           <div class="markup_item">
                              <label for="corona-quarantineGuidelines_url" :class="isValidURL(quarantineGuidelines_url) ? 'valid' : 'invalid'">Quarantine Guidelines URL</label>
                              <input type="text" class="xt_l" v-model="quarantineGuidelines_url" id="corona-quarantineGuidelines_url" :class="isValidURL(quarantineGuidelines_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(quarantineGuidelines_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div class="markup_item">
                              <label for="corona-diseasePreventionInfo_url" :class="isValidURL(diseasePreventionInfo_url) ? 'valid' : 'invalid'">Disease Prevention Info URL</label>
                              <input type="text" class="xt_l" v-model="diseasePreventionInfo_url" id="corona-diseasePreventionInfo_url" :class="isValidURL(diseasePreventionInfo_url) ? 'valid' : 'invalid'">
                              <div v-if="!isValidURL(diseasePreventionInfo_url)" class="error_msg">Invalid URL</div>
                           </div>
                           <div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="corona-datepicker-date_posted-btn">Date Posted</label>
                                 <input type="text" id="corona-datepicker-date_posted-btn" placeholder="YYYY-MM-DD" v-model="date_posted">
                                 <div id="corona-datepicker-date_posted" style="display: none;"></div>
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="corona-time_posted">Time Posted</label>
                                 <input type="text" placeholder="00:00 - 23:59" class="" v-model="time_posted" id="corona-time_posted" :class="!time_posted || isValidTime(time_posted) ? 'valid' : 'invalid'">
                                 <div v-if="time_posted && !isValidTime(time_posted)" class="error_msg">Invalid Time (00:00 - 23:59)</div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label for="corona-datepicker-date_expires-btn">Date Expires</label>
                                 <input type="text" id="corona-datepicker-date_expires-btn" placeholder="YYYY-MM-DD" v-model="date_expires">
                                 <div id="corona-datepicker-date_expires" style="display: none;"></div>
                              </div>
                              <div class="markup_item f_left" style="width: 50%;">
                                 <label id="corona-time_expires">Time Expires</label>
                                 <input type="text" placeholder="00:00 - 23:59" class="" v-model="time_expires" id="corona-time_expires" :class="!time_expires || isValidTime(time_expires) ? 'valid' : 'invalid'">
                                 <div v-if="time_expires && !isValidTime(time_expires)" class="error_msg">Invalid Time (00:00 - 23:59)</div>
                              </div>
                              <div class="clear_div"></div>
                           </div>
                           <div class="markup_section_wrap">
                              <div class="item_title">Spatial Coverage - Administrative Areas</div>
                              <ul>
                                 <li v-for="(s, idx) in spatialCoverage">
                                    <label>
                                    <input type="text" v-model="s.text" placeholder="San Francisco County, CA">
                                    </label>
                                    <button @click="removeArea(idx)">X</button>
                                 </li>
                              </ul>
                              <button @click="addNewArea">+ Add Area</button>
                           </div>
                        </div>
                        <div class="f_right">
                           <div class="fnbtns_wrap">
                              <button class="copy_script tooltipster" @click="copy_script_text('#corona textarea.schema')" data-hintname="smg-copy">Copy</button>
                              <button class="reset_script tooltipster" @click="reset_script" data-hintname="smg-reset">Reset</button>
                              <button class="structured_data_testing_tool tooltipster" @click="structured_data_testing_tool('#corona textarea.schema')" data-hintname="smg-validate">Validate</button>
                              <button class="rich_results_test tooltipster" @click="rich_results_test('#corona textarea.schema')" data-hintname="smg-test">Test</button>
                           </div>
                           <textarea class="schema" v-model="schemaScript"></textarea>
                        </div>
                        <div class="clear_div"></div>
                     </div>
			</div>
		</div>
	</div>
</section><!--Section-->
 <script type="text/javascript">
            function copy_script_text(selector) {
            	var text = document.querySelector(selector).value;
            	var $temp = $('<textarea>');
            	$('body').append($temp);
            
            	$temp.val(text).select();
            	document.execCommand('copy');
            	$temp.remove();
            }
            
            function structured_data_testing_tool (selector) {
            	var form = $('<form></form>', {
            		target: '_blank',
            		action: 'https://search.google.com/structured-data/testing-tool',
            		method:'POST'
            	}).append($('<input/>', {
            		name: 'code',
            		value: document.querySelector(selector).value,
            		type: 'hidden'
            	}));
            
            	form.appendTo('body');
            	form.submit();
            }
            
            function rich_results_test (selector) {
            	var form = $('<form></form>', {
            		target: '_blank',
            		action: 'https://search.google.com/test/rich-results',
            		method:'POST'
            	}).append($('<input/>', {
            			name: 'code_snippet',
            			value: document.querySelector(selector).value,
            			type: 'hidden'
            		}));
            
            	form.appendTo('body');
            	form.submit();
            }
            
            $(document).ready(function() {
            
            	function isValidURL(url) {
            		if (!url.length) {
            			return true;
            		}
            		var res = url.match(/(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g);
            		return res !== null;
            	}
            
            	function isValidTime(time) {
            		// HH:MM range (00:00 - 23:59)
            		var regex = /^(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$/;
            		return !!regex.exec(time);
            	}
            
            	function formatDate(date) {
            		var yyyy = date.getFullYear();
            		var mm = (date.getMonth()+1).toString().padStart(2, 0);
            		var dd = date.getDate().toString().padStart(2, 0);
            
            		var date_string = yyyy + '-' + mm + '-' + dd;
            
            		return date_string;
            	}
            
            	function loadCodeMirror(e) {
            		return CodeMirror.fromTextArea(e, {
            			readOnly: true,
            			mode: 'javascript',
            			viewportMargin: Infinity,
            			lineNumbers: true
            		});
            	}
            
            	function to_schema_script(schema) {
            		var schema_json = JSON.stringify(schema, null, 2);
            		var schema_script = ['<script type="application/ld+json">', schema_json, '<\/script>'].join('\n');
            
            		return schema_script;
            	}
            
            	var panelsVue = new Vue({
            		el: '#panels',
            		data: {
            			selected: 'article',
            			options: [
            				{ text: 'Article', value: 'article' },
            				{ text: 'Event', value: 'event' },
            				{ text: 'FAQ Page', value: 'faq' },
            				{ text: 'How-to', value: 'howto' },
            				{ text: 'Job Posting', value: 'jobposting' },
            				{ text: 'Local Business', value: 'localbusiness' },
            				{ text: 'Person', value: 'person' },
            				{ text: 'Product (Offer, AggregateRating, Reviews)', value: 'product' },
            				{ text: 'Video', value: 'video' },
            				{ text: 'Website - Sitelinks Searchbox', value: 'website_sitelinks_searchbox' },
            				{ text: 'Recipe', value: 'recipe' },
            				{ text: 'Organization (Logo, Contacts, Social Profile)', value: 'organization' },
            				{ text: 'COVID-19 - Special Announcement', value: 'corona' }
            			]
            		},
            		mounted: function () {
            			this.$nextTick(function () {
            				this.options.sort(this.sort_options);
            				this.select_panel(this.selected);
            			});
            		},
            		watch: {
            			selected: function (val) {
            				this.select_panel(val);
            			}
            		},
            		methods: {
            			select_panel: function (panel_id) {
            				var el = $('#' + panel_id);
            				if (el) {
            					$('.panel').hide();
            					el.show();
            				}
            			},
            			sort_options: function (a, b) {
            				var a_text = a.text.toLowerCase();
            				var b_text = b.text.toLowerCase();
            
            				if (a_text > b_text) { return 1; }
            				if (a_text < b_text) { return -1; }
            				return 0;
            			}
            		}
            
            	});
            
            	var personVue = new Vue({
            		el: '#person',
            		data: {
            			name: '',
            			url: '',
            			picture_url: '',
            			job_title: '',
            			company: '',
            			social_profiles: []
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#person textarea.schema'));
            		},
            		methods: {
            			addNewProfile: function () {
            				this.social_profiles.push({ source: '', url: '' });
            			},
            			removeProfile: function (idx) {
            				this.social_profiles.splice(idx, 1);
            			},
            			reset_script: function () {
            				this.name = '';
            				this.url = '';
            				this.picture_url = '';
            				this.job_title = '';
            				this.company = '';
            				this.social_profiles = [];
            			},
            			isValidURL: isValidURL
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "Person"
            				};
            
            				if (this.name.trim()) {
            					schema.name = this.name.trim()
            				}
            
            				if (this.url.trim()) {
            					schema.url = this.url.trim()
            				}
            
            				if (this.picture_url.trim()) {
            					schema.image = this.picture_url.trim()
            				}
            
            				if (this.job_title.trim()) {
            					schema.jobTitle = this.job_title.trim()
            				}
            
            				if (this.company.trim()) {
            					schema.worksFor = {
            						"@type": "Organization",
            						"name": this.company.trim()
            					}
            				}
            
            				var social_urls = this.social_profiles.map(p => p.url.trim()).filter(Boolean);
            
            				if (social_urls.length) {
            					schema.sameAs = social_urls;
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var faqVue = new Vue({
            		el: '#faq',
            		data: {
            			questions: []
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#faq textarea.schema'));
            			$('#faq').hide();
            		},
            		methods: {
            			addNewQuestion: function () {
            				this.questions.push({ question: '', answer: '' });
            			},
            			removeQuestion: function (idx) {
            				this.questions.splice(idx, 1);
            			},
            			reset_script: function() {
            				this.questions = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "FAQPage"
            				};
            
            				var questions = this.questions.map(q => ({
            					"@type": "Question",
            					"name": q.question.trim(),
            					"acceptedAnswer": {
            						"@type": "Answer",
            						"text": q.answer.trim()
            					}
            				}));
            
            				if (questions.length) {
            					schema.mainEntity = questions
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var howtoVue = new Vue({
            		el: '#howto',
            		data: {
            			name: '',
            			totalTime: '',
            			estimatedCost: '',
            			currency: '',
            			description: '',
            			image: '',
            			supplies: [],
            			tools: [],
            			steps: []
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#howto textarea.schema'));
            			$('#howto').hide();
            		},
            		methods: {
            			addNewSupply: function () {
            				this.supplies.push({ text: '' });
            			},
            			removeSupply: function (idx) {
            				this.supplies.splice(idx, 1);
            			},
            			addNewTool: function () {
            				this.tools.push({ text: '' });
            			},
            			removeTool: function (idx) {
            				this.tools.splice(idx, 1);
            			},
            			addNewStep: function () {
            				this.steps.push({ text: '', image: '', name: '', url: '' });
            			},
            			removeStep: function (idx) {
            				this.steps.splice(idx, 1);
            			},
            			isValidURL: isValidURL,
            			reset_script: function() {
            				this.name = '';
            				this.totalTime = '';
            				this.estimatedCost = '';
            				this.currency = '';
            				this.description = '';
            				this.image = '';
            				this.supplies = [];
            				this.tools = [];
            				this.steps = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "HowTo"
            				};
            
            				if (this.name.trim()) {
            					schema.name = this.name.trim();
            				}
            
            				if (this.description.trim()) {
            					schema.description = this.description.trim();
            				}
            
            				if (this.image.trim()) {
            					schema.image = this.image.trim();
            				}
            
            				if (this.totalTime.trim()) {
            					var mins = this.totalTime.trim();
            					schema.totalTime = "PT" + mins + "M";
            				}
            
            				if (this.currency.trim() || this.estimatedCost.trim()) {
            					schema.estimatedCost = {
            						"@type": "MonetaryAmount",
            						currency: this.currency.trim(),
            						value: this.estimatedCost.trim()
            					};
            				}
            
            				var supplies = this.supplies.map(e => e.text.trim()).filter(Boolean);
            
            				if (supplies.length) {
            					schema.supply = supplies.map(function (s) {
            						return {
            							"@type": "HowToSupply",
            							name: s
            						};
            					});
            				}
            
            				var tools = this.tools.map(e => e.text.trim()).filter(Boolean);
            
            				if (tools.length) {
            					schema.tool = tools.map(function (t) {
            						return {
            							"@type": "HowToTool",
            							name: t
            						};
            					});
            				}
            
            				var steps = this.steps.filter(e => e.text.trim() || e.image.trim() || e.name.trim() || e.url.trim());
            
            				if (steps.length) {
            					schema.step = steps.map(function (s) {
            						var step =  {
            							"@type": "HowToStep",
            							text: s.text.trim()
            						};
            
            						if (s.image.trim()) {
            							step.image = s.image.trim();
            						}
            
            						if (s.name.trim()) {
            							step.name = s.name.trim();
            						}
            
            						if (s.url.trim()) {
            							step.url = s.url.trim();
            						}
            
            						return step;
            					});
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var articleVue = new Vue({
            		el: '#article',
            		data: {
            			url: '',
            			headline: '',
            			description: '',
            			image_url: '',
            			image_width: '',
            			image_height: '',
            			author_name: '',
            			publisher_name: '',
            			publisher_logo_url: '',
            			publisher_logo_width: '',
            			publisher_logo_height: '',
            			date_published: '',	// date_picker
            			date_modified: '',	// date_picker
            
            			article_type: [
            				{ text: 'Article', value: 'Article' },
            				{ text: 'News Article', value: 'NewsArticle' },
            				{ text: 'Blog Posting', value: 'BlogPosting' }
            			],
            			selected_article_type: 'Article',
            
            			author_type: [
            				{ text: 'Person', value: 'Person' },
            				{ text: 'Organization', value: 'Organization' }
            			],
            			selected_author_type: 'Person'
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#article textarea.schema'));
            			$('#article').hide();
            
            			var $published_datepicker = $('#article-datepicker-datePublished');
            			var $modified_datepicker = $('#article-datepicker-dateModified');
            
            			var $published_datepicker_btn = $('#article-datepicker-datePublished-btn');
            			var $modified_datepicker_btn = $('#article-datepicker-dateModified-btn');
            
            			$published_datepicker_btn.on('click', function () {
            				$published_datepicker.toggle()
            			});
            
            			$modified_datepicker_btn.on('click', function () {
            				$modified_datepicker.toggle()
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$published_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.date_published = formatDate(date);
            					$(el).hide();
            				}
            			});
            
            			$modified_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.date_modified = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			reset_script: function() {
            				this.url = '';
            				this.headline = '';
            				this.description = '';
            				this.image_url = '';
            				this.image_width = '';
            				this.image_height = '';
            				this.author_name = '';
            				this.publisher_name = '';
            				this.publisher_logo_url = '';
            				this.publisher_logo_width = '';
            				this.publisher_logo_height = '';
            				this.date_published = '';
            				this.date_modified = '';
            				this.selected_article_type = 'Article';
            				this.selected_author_type = 'Person';
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": this.selected_article_type
            				};
            
            				if (this.url.trim()) {
            					schema.mainEntityOfPage = {
            						"@type": "WebPage",
            						"@id": this.url.trim()
            					};
            				}
            
            				schema.headline = this.headline.trim();
            
            				if (this.description.trim()) {
            					schema.description = this.description.trim();
            				}
            
            				schema.image = {
            					"@type": "ImageObject",
            					"url": this.image_url.trim(),
            					"width": this.image_width,
            					"height":this.image_height
            				};
            
            				schema.author = {
            					"@type": this.selected_author_type,
            					"name": this.author_name.trim()
            				};
            
            				schema.publisher = {
            					"@type": "Organization",
            					"name": this.publisher_name.trim(),
            					"logo": {
            						"@type": "ImageObject",
            						"url": this.publisher_logo_url.trim(),
            						"width": this.publisher_logo_width,
            						"height": this.publisher_logo_height
            					}
            				};
            
            				schema.datePublished = this.date_published;
            
            				if (this.date_modified) {
            					schema.dateModified = this.date_modified;
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var jobpostingVue = new Vue({
            		el: '#jobposting',
            		data: {
            			job_title: '',
            			job_id: '',
            			job_description: '',
            
            			company_name: '',
            			company_url: '',
            			industry: '',
            
            			work_hours: '',
            
            			employment_type: [
            				{ text: 'Select', value: '' },
            				{ text: 'Full Time', value: 'FULL_TIME' },
            				{ text: 'Part Time', value: 'PART_TIME' },
            				{ text: 'Contractor', value: 'CONTRACTOR' },
            				{ text: 'Temporary', value: 'TEMPORARY' },
            				{ text: 'Intern', value: 'INTERN' },
            				{ text: 'Volunteer', value: 'VOLUNTEER' },
            				{ text: 'Per diem', value: 'PER_DIEM' },
            				{ text: 'Other', value: 'OTHER' }
            			],
            			selected_employment_type: '',
            
            			date_posted: '',	// date_picker
            			valid_through: '',	// date_picker
            
            			remote_job: false,
            			country_code: '',
            			region_code: '',
            			street: '',
            			city: '',
            			zip_code: '',
            			min_salary: '',
            			max_salary: '',
            			currency_code: '',
            
            			payment_unit: [
            				{ text: 'Select', value: '' },
            				{ text: 'Hour', value: 'HOUR' },
            				{ text: 'Week', value: 'WEEK' },
            				{ text: 'Month', value: 'MONTH' },
            				{ text: 'Year', value: 'YEAR' }
            			],
            			selected_payment_unit: '',
            			responsibilities: '',
            			skills: '',
            			qualifications: '',
            			education_requirements: '',
            			experience_requirements: ''
            
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#jobposting textarea.schema'));
            			$('#jobposting').hide();
            
            			var $date_posted_datepicker = $('#jobposting-datepicker-date_posted');
            			var $valid_through_datepicker = $('#jobposting-datepicker-valid_through');
            
            			var $date_posted_datepicker_btn = $('#jobposting-datepicker-date_posted-btn');
            			var $valid_through_datepicker_btn = $('#jobposting-datepicker-valid_through-btn');
            
            			$date_posted_datepicker_btn.on('click', function () {
            				$date_posted_datepicker.toggle()
            			});
            
            			$valid_through_datepicker_btn.on('click', function () {
            				$valid_through_datepicker.toggle()
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$date_posted_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.date_posted = formatDate(date);
            					$(el).hide();
            				}
            			});
            
            			$valid_through_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.valid_through = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			reset_script: function() {
            				this.job_title = '';
            				this.job_id = '';
            				this.job_description = '';
            
            				this.company_name = '';
            				this.company_url = '';
            				this.industry = '';
            				this.work_hours = '';
            
            				this.selected_employment_type = '';
            				this.date_posted = '';
            				this.valid_through = '';
            
            				this.remote_job = false;
            				this.country_code = '';
            				this.street = '';
            				this.city = '';
            				this.zip_code = '';
            				this.min_salary = '';
            				this.max_salary = '';
            				this.currency_code = '';
            				this.region_code = '';
            
            				this.selected_payment_unit = '';
            
            				this.responsibilities = '';
            				this.skills = '';
            				this.qualifications = '';
            				this.education_requirements = '';
            				this.experience_requirements = '';
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": 'JobPosting'
            				};
            
            				schema.title = this.job_title.trim();
            				schema.description = this.job_description.trim();
            
            				if (this.job_id.trim()) {
            					schema.identifier = {
            						"@type": "PropertyValue",
            							"name": this.company_name.trim(),
            							"value": this.job_id.trim()
            					};
            				}
            
            				schema.hiringOrganization = {
            					"@type": "Organization",
            					"name": this.company_name.trim()
            				};
            
            				if (this.company_url.trim()) {
            					schema.hiringOrganization.sameAs = this.company_url.trim();
            				}
            
            				if (this.industry.trim()) {
            					schema.industry = this.industry.trim();
            				}
            
            				if (this.work_hours.trim()) {
            					schema.workHours = this.work_hours.trim();
            				}
            
            				if (this.selected_employment_type.trim()) {
            					schema.employmentType = this.selected_employment_type.trim();
            				}
            
            				schema.datePosted = this.date_posted;
            				schema.validThrough = this.valid_through;
            
            				if (this.remote_job) {
            					schema.applicantLocationRequirements = {
            						"@type": "Country",
            						"name": this.country_code.trim()
            					};
            
            					schema.jobLocationType = "TELECOMMUTE";
            				}
            				else {
            					schema.jobLocation = {
            						"@type": "Place",
            						"address": {
            							"@type": "PostalAddress",
            							"streetAddress": this.street.trim(),
            							"addressLocality": this.city.trim(),
            							"postalCode": this.zip_code.trim(),
            							"addressCountry": this.country_code.trim()
            						}
            					};
            
            					if (this.region_code.trim()) {
            						schema.jobLocation.address.addressRegion = this.region_code.trim();
            					}
            				}
            
            
            				if (this.min_salary) {
            					schema.baseSalary = {
            						"@type": "MonetaryAmount",
            						"currency": this.currency_code.trim(),
            						"value": {
            							"@type": "QuantitativeValue",
            							"unitText": this.selected_payment_unit
            						}
            					};
            
            					if (this.max_salary.trim()) {
            						schema.baseSalary.value.minValue = this.min_salary.trim();
            						schema.baseSalary.value.maxValue = this.max_salary.trim();
            					} else {
            						schema.baseSalary.value.value = this.min_salary.trim();
            					}
            				}
            
            				if (this.responsibilities.trim()) {
            					schema.responsibilities = this.responsibilities.trim();
            				}
            
            				if (this.skills.trim()) {
            					schema.skills = this.skills.trim();
            				}
            
            				if (this.qualifications.trim()) {
            					schema.qualifications = this.qualifications.trim();
            				}
            
            
            				if (this.education_requirements.trim()) {
            					schema.educationRequirements = this.education_requirements.trim();
            				}
            
            				if (this.experience_requirements.trim()) {
            					schema.experienceRequirements = this.experience_requirements.trim();
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var eventVue = new Vue({
            		el: '#event',
            		data: {
            			name: '',
            			description: '',
            			image_url: '',
            			start_date: '',
            			end_date: '',
            			start_time: '',
            			end_time: '',
            			performer_type: [
            				{ text: 'Select', value: '' },
            				{ text: 'Person', value: 'Person' },
            				{ text: 'Performing Group', value: 'PerformingGroup' },
            				{ text: 'Music Group', value: 'MusicGroup' },
            				{ text: 'Dance Group', value: 'DanceGroup' },
            				{ text: 'Theater Group', value: 'TheaterGroup' }
            			],
            			selected_performer_type: '',
            			performer_name: '',
            			venue_name: '',
            			street: '',
            			city: '',
            			zip_code: '',
            			country_code: '',
            			region_code: '',
            			currency_code: '',
            			tickets: [],
            			availability_type: [
            				{ text: 'Select', value: '' },
            				{ text: 'In Stock', value: 'https://schema.org/InStock' },
            				{ text: 'Sold Out', value: 'https://schema.org/SoldOut' },
            				{ text: 'Pre Order', value: 'https://schema.org/PreOrder' }
            			]
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#event textarea.schema'));
            			$('#event').hide();
            
            			var $start_date_datepicker = $('#event-datepicker-start_date');
            			var $end_date_datepicker = $('#event-datepicker-end_date');
            
            			var $start_date_datepicker_btn = $('#event-datepicker-start_date-btn');
            			var $end_date_datepicker_btn = $('#event-datepicker-end_date-btn');
            
            			$start_date_datepicker_btn.on('click', function () {
            				$end_date_datepicker.hide();
            				$start_date_datepicker.toggle();
            			});
            
            			$end_date_datepicker_btn.on('click', function () {
            				$start_date_datepicker.hide();
            				$end_date_datepicker.toggle();
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$start_date_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.start_date = formatDate(date);
            					$(el).hide();
            				}
            			});
            
            			$end_date_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.end_date = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			isValidTime: isValidTime,
            			addNewTicket: function () {
            				this.tickets.push({ name: '', price: '', available_from: '', url: '', availability: '' });
            			},
            			removeTicket: function (idx) {
            				this.tickets.splice(idx, 1);
            			},
            			open_datepicker: function (idx, ticket) {
            				var $datepicker = $('.available_from.' + idx);
            
            				var this_vue = this;
            
            				if (!ticket.datepicker) {
            					ticket.datepicker = true;
            
            					$datepicker.DatePicker({
            						inline: true,
            						date: new Date(),
            						calendars: 1,
            						mode: 'single',
            						onChange: function(date, el) {
            							ticket.available_from = formatDate(date);
            							$(el).hide();
            						}
            					});
            				}
            
            				$datepicker.toggle();
            			},
            			reset_script: function() {
            				this.name = '';
            				this.description = '';
            				this.image_url = '';
            				this.start_date = '';
            				this.end_date = '';
            				this.start_time = '';
            				this.end_time = '';
            				this.selected_performer_type = '';
            				this.performer_name = '';
            				this.venue_name = '';
            				this.street = '';
            				this.city = '';
            				this.zip_code = '';
            				this.country_code = '';
            				this.region_code = '';
            				this.currency_code = '';
            				this.tickets = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org",
            					"@type": "Event",
            					"name": this.name.trim()
            				};
            
            				if (this.description.trim()) {
            					schema.description = this.description.trim();
            				}
            
            				if (this.image_url.trim()) {
            					schema.image = this.image_url.trim();
            				}
            
            				schema.startDate = this.start_date;
            
            				if (this.isValidTime(this.start_time)) {
            					schema.startDate = this.start_date + 'T' + this.start_time;
            				}
            
            				if (this.end_date) {
            					schema.endDate = this.end_date;
            
            					if (this.isValidTime(this.end_time)) {
            						schema.endDate = this.end_date + 'T' + this.end_time;
            					}
            				}
            
            				if (this.selected_performer_type) {
            					schema.performer = {
            						"@type": this.selected_performer_type,
            						"name": this.performer_name.trim()
            					};
            				}
            
            				schema.location = {
            					"@type": "Place",
            					"name": this.venue_name.trim(),
            					"address": {
            						"@type": "PostalAddress",
            						"streetAddress": this.street.trim(),
            						"addressLocality": this.city.trim(),
            						"postalCode": this.zip_code.trim(),
            						"addressCountry": this.country_code.trim()
            					}
            				};
            
            				if (this.region_code.trim()) {
            					schema.location.address.addressRegion = this.region_code.trim();
            				}
            
            				if (this.tickets.length) {
            
            					var currency_code = this.currency_code.trim();
            					schema.offers = this.tickets.map(function (t) {
            						return {
            							"@type": "Offer",
            							"name": t.name.trim(),
            							"price": t.price.trim(),
            							"priceCurrency": currency_code,
            							"validFrom": t.available_from.trim(),
            							"url": t.url.trim(),
            							"availability": t.availability.trim()
            						};
            					});
            				}
            
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var localBusinessVue = new Vue({
            		el: '#localbusiness',
            		data: {
            			name: '',
            			image_url: '',
            			id: '',
            			url: '',
            			phone: '',
            			price_range: '',
            			street: '',
            			city: '',
            			zip_code: '',
            			country_code: '',
            			region_code: '',
            			latitude: '',
            			longitude: '',
            			open_24_7: false,
            			social_profiles: [],
            			opening_hours: [],
            			days_of_week: [ 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday' ]
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#localbusiness textarea.schema'));
            			$('#localbusiness').hide();
            		},
            		methods: {
            			isValidURL: isValidURL,
            			isValidTime: isValidTime,
            			addNewProfile: function () {
            				this.social_profiles.push({ source: '', url: '' });
            			},
            			removeProfile: function (idx) {
            				this.social_profiles.splice(idx, 1);
            			},
            			addNewHours: function () {
            				this.opening_hours.push({ opens_at: '', closes_at: '', days: [] });
            			},
            			removeHours: function (idx) {
            				this.opening_hours.splice(idx, 1);
            			},
            			reset_script: function() {
            				this.name = '';
            				this.image_url = '';
            				this.id = '';
            				this.url = '';
            				this.phone = '';
            				this.price_range = '';
            				this.street = '';
            				this.city = '';
            				this.zip_code = '';
            				this.country_code = '';
            				this.region_code = '';
            				this.latitude = '';
            				this.longitude = '';
            				this.open_24_7 = false;
            				this.social_profiles = [];
            				this.opening_hours = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org",
            					"@type": "LocalBusiness",
            					"name": this.name.trim(),
            					"image": this.image_url.trim(),
            					"@id": this.id.trim(),
            					"url": this.url.trim(),
            					"telephone": this.phone.trim(),
            					"address": {
            						"@type": "PostalAddress",
            						"streetAddress": this.street.trim(),
            						"addressLocality": this.city.trim(),
            						"postalCode": this.zip_code.trim(),
            						"addressCountry": this.country_code.trim()
            					}
            				};
            
            				if (this.region_code.trim()) {
            					schema.address.addressRegion = this.region_code.trim();
            				}
            
            				if (this.price_range.trim()) {
            					schema.priceRange = this.price_range.trim();
            				}
            
            				if (this.latitude.trim() || this.longitude.trim()) {
            					schema.geo = {
            						"@type": "GeoCoordinates",
            						"latitude": this.latitude.trim(),
            						"longitude": this.longitude.trim()
            					};
            				}
            
            				var social_urls = this.social_profiles.map(p => p.url.trim()).filter(Boolean);
            
            				if (social_urls.length) {
            					schema.sameAs = social_urls;
            				}
            
            				if (this.open_24_7) {
            					schema.openingHoursSpecification = {
            						"@type": "OpeningHoursSpecification",
            						"dayOfWeek": [
            							"Monday",
            							"Tuesday",
            							"Wednesday",
            							"Thursday",
            							"Friday",
            							"Saturday",
            							"Sunday"
            						],
            						"opens": "00:00",
            						"closes": "23:59"
            					};
            				}
            				else {
            					var opening_hours = this.opening_hours.map(function (h) {
            						return {
            							"@type": "OpeningHoursSpecification",
            							"dayOfWeek": h.days,
            							"opens": h.opens_at.trim(),
            							"closes": h.closes_at.trim()
            						};
            					});
            
            					if (opening_hours.length) {
            						schema.openingHoursSpecification = opening_hours;
            					}
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var productVue = new Vue({
            		el: '#product',
            		data: {
            			name: '',
            			image_url: '',
            			brand: '',
            			description: '',
            			agg_rating: {
            				count: '',
            				value: '',
            				best: '',
            				worst: ''
            			},
            			id_properties: {
            				sku: '',
            				gtin8: '',
            				gtin13: '',
            				gtin14: '',
            				mpn: ''
            			},
            			offer_type: [
            				{ text: 'None', value: '' },
            				{ text: 'Offer', value: 'Offer' },
            				{ text: 'Aggregate Offer', value: 'AggregateOffer' }
            			],
            			selected_offer_type: '',
            
            			url: '',
            			currency_code: '',
            			price: '',
            			low_price: '',
            			high_price: '',
            			offer_count: '',
            			price_valid_until: '', // date
            			condition_types: [
            				{ text: 'Not Specified', value: '' },
            				{ text: 'New', value: 'https://schema.org/NewCondition' },
            				{ text: 'Used', value: 'https://schema.org/UsedCondition' }
            			],
            			selected_availability: '',
            			availability_types: [
            				{ text: 'None', value: '' },
            				{ text: 'In Stock', value: 'https://schema.org/InStock' },
            				{ text: 'Out Of Stock', value: 'https://schema.org/OutOfStock' },
            				{ text: 'Online Only', value: 'https://schema.org/OnlineOnly' },
            				{ text: 'In Store Only', value: 'https://schema.org/InStoreOnly' },
            				{ text: 'Pre Order', value: 'https://schema.org/PreOrder' },
            				{ text: 'Pre Sale', value: 'https://schema.org/PreSale' },
            				{ text: 'Limited Availability', value: 'https://schema.org/LimitedAvailability' },
            				{ text: 'Sold Out', value: 'https://schema.org/SoldOut' },
            				{ text: 'Discontinued', value: 'https://schema.org/Discontinued' }
            			],
            			selected_condition: '',
            			reviews: []
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#product textarea.schema'));
            			$('#product').hide();
            
            			var $price_valid_until_datepicker = $('#product-datepicker-price_valid_until');
            			var $price_valid_until_datepicker_btn = $('#product-datepicker-price_valid_until-btn');
            
            			$price_valid_until_datepicker_btn.on('click', function () {
            				$price_valid_until_datepicker.toggle()
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$price_valid_until_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.price_valid_until = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			addNewReview: function () {
            				this.reviews.push({
            					name: '',
            					body: '',
            					rating: '',
            					date: '',
            					author: '',
            					publisher: ''
            				});
            			},
            			removeReview: function (idx) {
            				this.reviews.splice(idx, 1);
            			},
            			open_datepicker: function (idx, ticket) {
            				var $datepicker = $('.review_date.' + idx);
            
            				var this_vue = this;
            
            				if (!ticket.datepicker) {
            					ticket.datepicker = true;
            
            					$datepicker.DatePicker({
            						inline: true,
            						date: new Date(),
            						calendars: 1,
            						mode: 'single',
            						onChange: function(date, el) {
            							ticket.date = formatDate(date);
            							$(el).hide();
            						}
            					});
            				}
            
            				$datepicker.toggle();
            			},
            			reset_script: function() {
            				this.name = '';
            				this.image_url = '';
            				this.brand = '';
            				this.description = '';
            				this.agg_rating = {
            					count: '',
            					value: '',
            					best: '',
            					worst: ''
            				};
            				this.id_properties = {
            					sku: '',
            					gtin8: '',
            					gtin13: '',
            					gtin14: '',
            					mpn: ''
            				};
            
            				this.selected_offer_type = '';
            				this.url = '';
            				this.currency_code = '';
            				this.price = '';
            				this.low_price = '';
            				this.high_price = '';
            				this.offer_count = '';
            				this.price_valid_until = ''; // date
            
            				this.selected_availability = '';
            				this.selected_condition = '';
            				this.reviews = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "Product",
            					"name": this.name.trim(),
            					"image": this.image_url.trim()
            				};
            
            				if (this.description.trim()) {
            					schema.description = this.description.trim();
            				}
            
            				if (this.brand.trim()) {
            					schema.brand = this.brand.trim();
            				}
            
            				if (this.agg_rating.value.trim()) {
            					schema.aggregateRating = {
            						"@type": "AggregateRating",
            							"ratingValue": this.agg_rating.value.trim(),
            							"bestRating": this.agg_rating.best.trim(),
            							"worstRating": this.agg_rating.worst.trim(),
            							"ratingCount": this.agg_rating.count.trim()
            					};
            				}
            
            				var props = this.id_properties;
            
            				Object.keys(props).forEach(function (key) {
            					var val = props[key].trim();
            					if (val) {
            						schema[key] = val;
            					}
            				});
            
            				if (this.selected_offer_type === 'Offer') {
            					schema.offers = {
            						"@type": "Offer",
            						"url": this.url.trim(),
            						"priceCurrency": this.currency_code.trim(),
            						"price": this.price.trim()
            					};
            
            					if (this.price_valid_until.trim()) {
            						schema.offers.priceValidUntil = this.price_valid_until.trim();
            					}
            
            					if (this.selected_availability.trim()) {
            						schema.offers.availability = this.selected_availability.trim();
            					}
            
            					if (this.selected_condition.trim()) {
            						schema.offers.itemCondition = this.selected_condition.trim();
            					}
            				}
            
            				if (this.selected_offer_type === 'AggregateOffer') {
            					schema.offers = {
            						"@type": "AggregateOffer",
            						"url": this.url.trim(),
            						"priceCurrency": this.currency_code.trim(),
            						"lowPrice": this.low_price.trim()
            					};
            
            					if (this.high_price.trim()) {
            						schema.offers.highPrice = this.high_price.trim();
            					}
            
            					if (this.selected_condition.trim()) {
            						schema.offers.offerCount = this.offer_count.trim();
            					}
            				}
            
            				var reviews = this.reviews.map(function(r) {
            					var e = {
            						"@type": "Review",
            						"reviewBody": r.body.trim(),
            						"author": { "@type": "Person", "name": r.author.trim() }
            					};
            
            					if (r.name.trim()) {
            						e.name = r.name.trim();
            					}
            
            					if (r.date.trim()) {
            						e.datePublished = r.date.trim();
            					}
            
            					if (r.rating.trim()) {
            						e.reviewRating = {
            							"@type": "Rating",
            							"ratingValue": r.rating.trim()
            						};
            					}
            
            					if (r.publisher.trim()) {
            						e.publisher = { "@type": "Organization", "name": r.publisher.trim() };
            					}
            
            					return e;
            				});
            
            				if (reviews.length) {
            					schema.reviews = reviews;
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var videoVue = new Vue({
            		el: '#video',
            		data: {
            			name: '',
            			description: '',
            			content_url: '',
            			embed_url: '',
            			thumbnail_urls: [],
            
            			publisher_name: '',
            			publisher_logo_url: '',
            			publisher_logo_width: '',
            			publisher_logo_height: '',
            
            			upload_date: '',
            			duration: {
            				minutes: '',
            				seconds: ''
            			}
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#video textarea.schema'));
            			$('#video').hide();
            
            			var $upload_date_datepicker = $('#video-datepicker-upload_date');
            			var $upload_date_datepicker_btn = $('#video-datepicker-upload_date-btn');
            
            			$upload_date_datepicker_btn.on('click', function () {
            				$upload_date_datepicker.toggle()
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$upload_date_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.upload_date = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			addNewThumbnailUrl: function () {
            				this.thumbnail_urls.push({ text: '' });
            			},
            			removeThumbnailUrl: function (idx) {
            				this.thumbnail_urls.splice(idx, 1);
            			},
            			reset_script: function() {
            				this.name = '';
            				this.description = '';
            				this.content_url = '';
            				this.embed_url = '';
            				this.thumbnail_urls = [];
            
            				this.publisher_name = '';
            				this.publisher_logo_url = '';
            				this.publisher_logo_width = '';
            				this.publisher_logo_height = '';
            
            				this.upload_date = '';
            
            				this.duration.minutes = '';
            				this.duration.seconds = '';
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org",
            					"@type": "VideoObject",
            					"name": this.name.trim(),
            					"description": this.description.trim(),
            					"thumbnailUrl": this.thumbnail_urls.length ? this.thumbnail_urls.map(function(e) { return e.text.trim(); }) : '',
            					"uploadDate": this.upload_date
            				};
            
            				if (this.content_url.trim()) {
            					schema.contentUrl = this.content_url.trim();
            				}
            
            				if (this.embed_url.trim()) {
            					schema.embedUrl = this.embed_url.trim();
            				}
            
            				if (this.publisher_name) {
            					schema.publisher = {
            						"@type": "Organization",
            						"name": this.publisher_name.trim(),
            						"logo": {
            							"@type": "ImageObject",
            							"url": this.publisher_logo_url.trim(),
            							"width": this.publisher_logo_width.trim(),
            							"height": this.publisher_logo_height.trim()
            						}
            					};
            				}
            
            				if (this.duration.minutes.trim() || this.duration.seconds.trim()) {
            					var mins = this.duration.minutes.trim() || 0;
            					var secs = this.duration.seconds.trim() || 0;
            					schema.duration = "PT" + mins + "M"+ secs + "S";
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var website_sitelinks_searchboxVue = new Vue({
            		el: '#website_sitelinks_searchbox',
            		data: {
            			name: '',
            			url: '',
            			search_url: ''
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#website_sitelinks_searchbox textarea.schema'));
            		},
            		methods: {
            			reset_script: function () {
            				this.name = '';
            				this.url = '';
            				this.search_url = '';
            			},
            			isValidURL: isValidURL
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "WebSite",
            					"name": this.name.trim(),
            					"url": this.url.trim(),
            					"potentialAction": {
            						"@type": "SearchAction",
            						"target": this.search_url.trim() + "{search_term_string}",
            						"query-input": "required name=search_term_string"
            					}
            				};
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var recipeVue = new Vue({
            		el: '#recipe',
            		data: {
            			name: '',
            			description: '',
            
            			keywords: '',
            
            			prep_time: '',
            			cook_time: '',
            
            			creator: '',
            			recipe_cuisine: '',
            			servings: '',
            
            			servingSize: '',
            			calories: '',
            			fatContent: '',
            
            			contentUrl: '',
            			embedUrl: '',
            
            			agg_rating: {
            				count: '',
            				value: '',
            				best: '',
            				worst: ''
            			},
            			category: [
            				{ text: 'None', value: '' },
            				{ text: 'Appetizer', value: 'appetizer' },
            				{ text: 'Entree', value: 'entree' },
            				{ text: 'Dessert', value: 'dessert' },
            			],
            			selected_category: '',
            
            			datePublished: '', // date
            
            			reviews: [],
            
            			ingredients: [],
            			instructions: [],
            			images: [{ url: '' }]
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#recipe textarea.schema'));
            			$('#recipe').hide();
            
            			var $datePublished_datepicker = $('#recipe-datepicker-datePublished');
            			var $datePublished_datepicker_btn = $('#recipe-datepicker-datePublished-btn');
            
            			$datePublished_datepicker_btn.on('click', function () {
            				$datePublished_datepicker.toggle()
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$datePublished_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.datePublished = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			addNewStep: function () {
            				this.instructions.push({ text: '' });
            			},
            			removeStep: function (idx) {
            				this.instructions.splice(idx, 1);
            			},
            			addNewIngredient: function () {
            				this.ingredients.push({ text: '' });
            			},
            			removeIngredient: function (idx) {
            				this.ingredients.splice(idx, 1);
            			},
            			addNewImage: function () {
            				this.images.push({ url: '' });
            			},
            			removeImage: function (idx) {
            				this.images.splice(idx, 1);
            			},
            			format_mins: function (mins) {
            				return "PT" + mins + "M";
            			},
            			addNewReview: function () {
            				this.reviews.push({
            					name: '',
            					body: '',
            					rating: '',
            					date: '',
            					author: '',
            					publisher: ''
            				});
            			},
            			removeReview: function (idx) {
            				this.reviews.splice(idx, 1);
            			},
            			open_datepicker: function (idx, ticket) {
            				var $datepicker = $('.review_date.' + idx);
            
            				var this_vue = this;
            
            				if (!ticket.datepicker) {
            					ticket.datepicker = true;
            
            					$datepicker.DatePicker({
            						inline: true,
            						date: new Date(),
            						calendars: 1,
            						mode: 'single',
            						onChange: function(date, el) {
            							ticket.date = formatDate(date);
            							$(el).hide();
            						}
            					});
            				}
            
            				$datepicker.toggle();
            			},
            			reset_script: function() {
            				this.name = '';
            
            				this.contentUrl = '';
            				this.embedUrl = '';
            
            				this.description = '';
            
            				this.keywords = '';
            				this.prep_time = '';
            				this.cook_time = '';
            				this.creator = '';
            				this.recipe_cuisine = '';
            				this.servings = '';
            
            				this.servingSize = '';
            				this.calories = '';
            				this.fatContent = '';
            
            				this.agg_rating = {
            					count: '',
            					value: '',
            					best: '',
            					worst: ''
            				};
            
            				this.selected_category = '';
            
            				this.datePublished = ''; // date
            
            				this.reviews = [];
            
            				this.ingredients = [];
            				this.instructions = [];
            				this.images = [{ url: '' }];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "Recipe",
            					"name": this.name.trim(),
            					"image": !this.images.length ? "" : this.images.map(function(img) { return img.url.trim(); }),
            					"description": this.description.trim(),
            					"keywords": this.keywords.trim(),
            					"author": {
            						"@type": "Person",
            						"name": this.creator.trim()
            					},
            					"prepTime": this.format_mins(this.prep_time || 0),
            					"cookTime": this.format_mins(this.cook_time || 0),
            					"totalTime": this.format_mins(parseInt(this.prep_time || 0) + parseInt(this.cook_time || 0)),
            					"nutrition": {
            						"@type": "NutritionInformation",
            						"calories": this.calories.trim() ? this.calories.trim() + ' cal' : ''
            					}
            				};
            
            				if (this.datePublished.trim()) {
            					schema.datePublished = this.datePublished;
            				}
            
            				if (this.servingSize.trim()) {
            					schema.nutrition.servingSize = this.servingSize.trim();
            				}
            
            				if (this.fatContent.trim()) {
            					schema.nutrition.fatContent = this.fatContent.trim() + ' g';
            				}
            
            				if (this.description.trim()) {
            					schema.description = this.description.trim();
            				}
            
            				if (this.recipe_cuisine.trim()) {
            					schema.recipeCuisine = this.recipe_cuisine.trim();
            				}
            
            				if (this.servings.trim()) {
            					schema.recipeYield = this.servings.trim();
            				}
            
            				if (this.agg_rating.value.trim()) {
            					schema.aggregateRating = {
            						"@type": "AggregateRating",
            						"ratingValue": this.agg_rating.value.trim(),
            						"bestRating": this.agg_rating.best.trim(),
            						"worstRating": this.agg_rating.worst.trim(),
            						"ratingCount": this.agg_rating.count.trim()
            					};
            				}
            
            				if (this.selected_category) {
            					schema.recipeCategory = this.selected_category;
            				}
            
            				if (this.contentUrl.trim() || this.embedUrl.trim()) {
            					schema.video = {
            						"@type": "VideoObject",
            						"name": this.name.trim(),
            						"description": this.description.trim(),
            						"thumbnailUrl": "",
            						"uploadDate": this.datePublished,
            						"contentUrl": this.contentUrl.trim(),
            						"embedUrl": this.embedUrl.trim()
            					};
            				}
            
            				var ingredients = this.ingredients
            									.map(function (e) { return e.text.trim(); })
            									.filter(Boolean);
            
            				if (ingredients.length) {
            					schema.recipeIngredient = ingredients;
            				}
            
            				var instructions = this.instructions
            										.filter(function (e) { return e.text.trim(); })
            										.map(function (e) {
            											return {
            												"@type": "HowToStep",
            												"text": e.text.trim()
            											};
            										});
            
            				if (instructions.length) {
            					schema.recipeInstructions = instructions;
            				}
            
            				var reviews = this.reviews.map(function(r) {
            					var e = {
            						"@type": "Review",
            						"reviewBody": r.body.trim(),
            						"author": { "@type": "Person", "name": r.author.trim() }
            					};
            
            					if (r.name.trim()) {
            						e.name = r.name.trim();
            					}
            
            					if (r.date.trim()) {
            						e.datePublished = r.date.trim();
            					}
            
            					if (r.rating.trim()) {
            						e.reviewRating = {
            							"@type": "Rating",
            							"ratingValue": r.rating.trim()
            						};
            					}
            
            					if (r.publisher.trim()) {
            						e.publisher = { "@type": "Organization", "name": r.publisher.trim() };
            					}
            
            					return e;
            				});
            
            				if (reviews.length) {
            					schema.reviews = reviews;
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var organizationVue = new Vue({
            		el: '#organization',
            		data: {
            			name: '',
            			alternateName: '',
            			url: '',
            			logoUrl: '',
            			social_profiles: [],
            			organization_types: [
            				{
            					"key": "Organization",
            					"desc": "An organization such as a school, NGO, corporation, club, etc."
            				},
            				{
            					"key": "Airline",
            					"desc": "An organization that provides flights for passengers."
            				},
            				{
            					"key": "Consortium",
            					"desc": "A Consortium is a membership Organization whose members are typically Organizations."
            				},
            				{
            					"key": "Corporation",
            					"desc": "Organization: A business corporation."
            				},
            				{
            					"key": "EducationalOrganization",
            					"desc": "An educational organization.",
            					"more_specific_types": [
            						{
            							"key": "CollegeOrUniversity",
            							"desc": "A college, university, or other third-level educational institution."
            						},
            						{
            							"key": "ElementarySchool",
            							"desc": "An elementary school."
            						},
            						{
            							"key": "HighSchool",
            							"desc": "A high school."
            						},
            						{
            							"key": "MiddleSchool",
            							"desc": "A middle school (typically for children aged around 11-14, although this varies somewhat)."
            						},
            						{
            							"key": "Preschool",
            							"desc": "A preschool."
            						},
            						{
            							"key": "School",
            							"desc": "A school."
            						}
            					]
            				},
            				{
            					"key": "GovernmentOrganization",
            					"desc": "A governmental organization or agency."
            				},
            				{
            					"key": "LibrarySystem",
            					"desc": "A LibrarySystem is a collaborative system amongst several libraries."
            				},
            				{
            					"key": "MedicalOrganization",
            					"desc": "A medical organization (physical or not), such as hospital, institution or clinic.",
            					"more_specific_types": [
            						{
            							"key": "DiagnosticLab",
            							"desc": "A medical laboratory that offers on-site or off-site diagnostic services."
            						},
            						{
            							"key": "VeterinaryCare",
            							"desc": "A vet's office."
            						}
            					]
            				},
            				{
            					"key": "NGO",
            					"desc": "Organization: Non-governmental Organization."
            				},
            				{
            					"key": "NewsMediaOrganization",
            					"desc": "A News/Media organization such as a newspaper or TV station."
            				},
            				{
            					"key": "PerformingGroup",
            					"desc": "A performance group, such as a band, an orchestra, or a circus.",
            					"more_specific_types": [
            						{
            							"key": "DanceGroup ",
            							"desc": "A dance group&#x2014;for example, the Alvin Ailey Dance Theater or Riverdance."
            						},
            						{
            							"key": "MusicGroup",
            							"desc": "A musical group, such as a band, an orchestra, or a choir. Can also be a solo musician."
            						},
            						{
            							"key": "TheaterGroup",
            							"desc": "A theater group or company, for example, the Royal Shakespeare Company or Druid Theatre."
            						}
            					]
            				},
            				{
            					"key": "Project",
            					"desc": "An enterprise (potentially individual but typically collaborative), planned to achieve a particular aim...",
            					"more_specific_types": [
            						{
            							"key": "FundingAgency",
            							"desc": "A FundingAgency is an organization that implements one or more FundingSchemes and manages\n    the granting process (via Grants, typically MonetaryGrants)..."
            						},
            						{
            							"key": "FundingScheme",
            							"desc": "A FundingScheme combines organizational, project and policy aspects of grant-based funding\n    that sets guidelines, principles and mechanisms to support other kinds of projects and activities..."
            						},
            						{
            							"key": "ResearchProject",
            							"desc": "A Research project."
            						}
            					]
            				},
            				{
            					"key": "SportsOrganization",
            					"desc": "Represents the collection of all sports organizations, including sports teams, governing bodies, and sports associations.",
            					"more_specific_types": [
            						{
            							"key": "SportsTeam",
            							"desc": "Organization: Sports team."
            						}
            					]
            				},
            				{
            					"key": "WorkersUnion",
            					"desc": "A Workers Union (also known as a Labor Union, Labour Union, or Trade Union) is an organization that promotes the interests of its worker members by collectively bargaining with management, organizing, and political lobbying."
            				}
            			],
            			more_specific_organization_types: [],
            			selected_organization_type: 'Organization',
            			selected_specific_organization_type: '',
            			contact_types: [
            				{ text: "None", value: "" },
            				{ text: "Customer service", value: "customer service" },
            				{ text: "Technical support", value: "technical support" },
            				{ text: "Billing support", value: "billing support" },
            				{ text: "Bill payment", value: "bill payment" },
            				{ text: "Sales", value: "sales" },
            				{ text: "Reservations", value: "reservations" },
            				{ text: "Credit card support", value: "credit card support" },
            				{ text: "Emergency", value: "emergency" },
            				{ text: "Baggage tracking", value: "baggage tracking" },
            				{ text: "Roadside assistance", value: "roadside assistance" },
            				{ text: "Package tracking", value: "package tracking" }
            			],
            			options: [
            				{ text: "Toll Free", value: "TollFree" },
            				{ text: "Hearing Impaired Supported", value: "HearingImpairedSupported" }
            			],
            			areas: [
            				{ text: "United States of America (the)", value: "US" },
            				{ text: "Canada", value: "CA" },
            				{ text: "United Kingdom of Great Britain and Northern Ireland (the)", value: "GB" },
            				{ text: "Afghanistan", value: "AF" },
            				{ text: "Albania", value: "AL" },
            				{ text: "Algeria", value: "DZ" },
            				{ text: "American Samoa", value: "AS" },
            				{ text: "Andorra", value: "AD" },
            				{ text: "Angola", value: "AO" },
            				{ text: "Anguilla", value: "AI" },
            				{ text: "Antarctica", value: "AQ" },
            				{ text: "Antigua and Barbuda", value: "AG" },
            				{ text: "Argentina", value: "AR" },
            				{ text: "Armenia", value: "AM" },
            				{ text: "Aruba", value: "AW" },
            				{ text: "Australia", value: "AU" },
            				{ text: "Austria", value: "AT" },
            				{ text: "Azerbaijan", value: "AZ" },
            				{ text: "Bahamas (the)", value: "BS" },
            				{ text: "Bahrain", value: "BH" },
            				{ text: "Bangladesh", value: "BD" },
            				{ text: "Barbados", value: "BB" },
            				{ text: "Belarus", value: "BY" },
            				{ text: "Belgium", value: "BE" },
            				{ text: "Belize", value: "BZ" },
            				{ text: "Benin", value: "BJ" },
            				{ text: "Bermuda", value: "BM" },
            				{ text: "Bhutan", value: "BT" },
            				{ text: "Bolivia (Plurinational State of)", value: "BO" },
            				{ text: "Bonaire, Sint Eustatius and Saba", value: "BQ" },
            				{ text: "Bosnia and Herzegovina", value: "BA" },
            				{ text: "Botswana", value: "BW" },
            				{ text: "Bouvet Island", value: "BV" },
            				{ text: "Brazil", value: "BR" },
            				{ text: "British Indian Ocean Territory (the)", value: "IO" },
            				{ text: "Brunei Darussalam", value: "BN" },
            				{ text: "Bulgaria", value: "BG" },
            				{ text: "Burkina Faso", value: "BF" },
            				{ text: "Burundi", value: "BI" },
            				{ text: "Cabo Verde", value: "CV" },
            				{ text: "Cambodia", value: "KH" },
            				{ text: "Cameroon", value: "CM" },
            				{ text: "Cayman Islands (the)", value: "KY" },
            				{ text: "Central African Republic (the)", value: "CF" },
            				{ text: "Chad", value: "TD" },
            				{ text: "Chile", value: "CL" },
            				{ text: "China", value: "CN" },
            				{ text: "Christmas Island", value: "CX" },
            				{ text: "Cocos (Keeling) Islands (the)", value: "CC" },
            				{ text: "Colombia", value: "CO" },
            				{ text: "Comoros (the)", value: "KM" },
            				{ text: "Congo (the Democratic Republic of the)", value: "CD" },
            				{ text: "Congo (the)", value: "CG" },
            				{ text: "Cook Islands (the)", value: "CK" },
            				{ text: "Costa Rica", value: "CR" },
            				{ text: "Croatia", value: "HR" },
            				{ text: "Cuba", value: "CU" },
            				{ text: "Curaçao", value: "CW" },
            				{ text: "Cyprus", value: "CY" },
            				{ text: "Czechia", value: "CZ" },
            				{ text: "Côte d'Ivoire", value: "CI" },
            				{ text: "Denmark", value: "DK" },
            				{ text: "Djibouti", value: "DJ" },
            				{ text: "Dominica", value: "DM" },
            				{ text: "Dominican Republic (the)", value: "DO" },
            				{ text: "Ecuador", value: "EC" },
            				{ text: "Egypt", value: "EG" },
            				{ text: "El Salvador", value: "SV" },
            				{ text: "Equatorial Guinea", value: "GQ" },
            				{ text: "Eritrea", value: "ER" },
            				{ text: "Estonia", value: "EE" },
            				{ text: "Eswatini", value: "SZ" },
            				{ text: "Ethiopia", value: "ET" },
            				{ text: "Falkland Islands (the) [Malvinas]", value: "FK" },
            				{ text: "Faroe Islands (the)", value: "FO" },
            				{ text: "Fiji", value: "FJ" },
            				{ text: "Finland", value: "FI" },
            				{ text: "France", value: "FR" },
            				{ text: "French Guiana", value: "GF" },
            				{ text: "French Polynesia", value: "PF" },
            				{ text: "French Southern Territories (the)", value: "TF" },
            				{ text: "Gabon", value: "GA" },
            				{ text: "Gambia (the)", value: "GM" },
            				{ text: "Georgia", value: "GE" },
            				{ text: "Germany", value: "DE" },
            				{ text: "Ghana", value: "GH" },
            				{ text: "Gibraltar", value: "GI" },
            				{ text: "Greece", value: "GR" },
            				{ text: "Greenland", value: "GL" },
            				{ text: "Grenada", value: "GD" },
            				{ text: "Guadeloupe", value: "GP" },
            				{ text: "Guam", value: "GU" },
            				{ text: "Guatemala", value: "GT" },
            				{ text: "Guernsey", value: "GG" },
            				{ text: "Guinea", value: "GN" },
            				{ text: "Guinea-Bissau", value: "GW" },
            				{ text: "Guyana", value: "GY" },
            				{ text: "Haiti", value: "HT" },
            				{ text: "Heard Island and McDonald Islands", value: "HM" },
            				{ text: "Holy See (the)", value: "VA" },
            				{ text: "Honduras", value: "HN" },
            				{ text: "Hong Kong", value: "HK" },
            				{ text: "Hungary", value: "HU" },
            				{ text: "Iceland", value: "IS" },
            				{ text: "India", value: "IN" },
            				{ text: "Indonesia", value: "ID" },
            				{ text: "Iran (Islamic Republic of)", value: "IR" },
            				{ text: "Iraq", value: "IQ" },
            				{ text: "Ireland", value: "IE" },
            				{ text: "Isle of Man", value: "IM" },
            				{ text: "Israel", value: "IL" },
            				{ text: "Italy", value: "IT" },
            				{ text: "Jamaica", value: "JM" },
            				{ text: "Japan", value: "JP" },
            				{ text: "Jersey", value: "JE" },
            				{ text: "Jordan", value: "JO" },
            				{ text: "Kazakhstan", value: "KZ" },
            				{ text: "Kenya", value: "KE" },
            				{ text: "Kiribati", value: "KI" },
            				{ text: "Korea (the Democratic People's Republic of)", value: "KP" },
            				{ text: "Korea (the Republic of)", value: "KR" },
            				{ text: "Kuwait", value: "KW" },
            				{ text: "Kyrgyzstan", value: "KG" },
            				{ text: "Lao People's Democratic Republic (the)", value: "LA" },
            				{ text: "Latvia", value: "LV" },
            				{ text: "Lebanon", value: "LB" },
            				{ text: "Lesotho", value: "LS" },
            				{ text: "Liberia", value: "LR" },
            				{ text: "Libya", value: "LY" },
            				{ text: "Liechtenstein", value: "LI" },
            				{ text: "Lithuania", value: "LT" },
            				{ text: "Luxembourg", value: "LU" },
            				{ text: "Macao", value: "MO" },
            				{ text: "Madagascar", value: "MG" },
            				{ text: "Malawi", value: "MW" },
            				{ text: "Malaysia", value: "MY" },
            				{ text: "Maldives", value: "MV" },
            				{ text: "Mali", value: "ML" },
            				{ text: "Malta", value: "MT" },
            				{ text: "Marshall Islands (the)", value: "MH" },
            				{ text: "Martinique", value: "MQ" },
            				{ text: "Mauritania", value: "MR" },
            				{ text: "Mauritius", value: "MU" },
            				{ text: "Mayotte", value: "YT" },
            				{ text: "Mexico", value: "MX" },
            				{ text: "Micronesia (Federated States of)", value: "FM" },
            				{ text: "Moldova (the Republic of)", value: "MD" },
            				{ text: "Monaco", value: "MC" },
            				{ text: "Mongolia", value: "MN" },
            				{ text: "Montenegro", value: "ME" },
            				{ text: "Montserrat", value: "MS" },
            				{ text: "Morocco", value: "MA" },
            				{ text: "Mozambique", value: "MZ" },
            				{ text: "Myanmar", value: "MM" },
            				{ text: "Namibia", value: "NA" },
            				{ text: "Nauru", value: "NR" },
            				{ text: "Nepal", value: "NP" },
            				{ text: "Netherlands (the)", value: "NL" },
            				{ text: "New Caledonia", value: "NC" },
            				{ text: "New Zealand", value: "NZ" },
            				{ text: "Nicaragua", value: "NI" },
            				{ text: "Niger (the)", value: "NE" },
            				{ text: "Nigeria", value: "NG" },
            				{ text: "Niue", value: "NU" },
            				{ text: "Norfolk Island", value: "NF" },
            				{ text: "Northern Mariana Islands (the)", value: "MP" },
            				{ text: "Norway", value: "NO" },
            				{ text: "Oman", value: "OM" },
            				{ text: "Pakistan", value: "PK" },
            				{ text: "Palau", value: "PW" },
            				{ text: "Palestine, State of", value: "PS" },
            				{ text: "Panama", value: "PA" },
            				{ text: "Papua New Guinea", value: "PG" },
            				{ text: "Paraguay", value: "PY" },
            				{ text: "Peru", value: "PE" },
            				{ text: "Philippines (the)", value: "PH" },
            				{ text: "Pitcairn", value: "PN" },
            				{ text: "Poland", value: "PL" },
            				{ text: "Portugal", value: "PT" },
            				{ text: "Puerto Rico", value: "PR" },
            				{ text: "Qatar", value: "QA" },
            				{ text: "Republic of North Macedonia", value: "MK" },
            				{ text: "Romania", value: "RO" },
            				{ text: "Russian Federation (the)", value: "RU" },
            				{ text: "Rwanda", value: "RW" },
            				{ text: "Réunion", value: "RE" },
            				{ text: "Saint Barthélemy", value: "BL" },
            				{ text: "Saint Helena, Ascension and Tristan da Cunha", value: "SH" },
            				{ text: "Saint Kitts and Nevis", value: "KN" },
            				{ text: "Saint Lucia", value: "LC" },
            				{ text: "Saint Martin (French part)", value: "MF" },
            				{ text: "Saint Pierre and Miquelon", value: "PM" },
            				{ text: "Saint Vincent and the Grenadines", value: "VC" },
            				{ text: "Samoa", value: "WS" },
            				{ text: "San Marino", value: "SM" },
            				{ text: "Sao Tome and Principe", value: "ST" },
            				{ text: "Saudi Arabia", value: "SA" },
            				{ text: "Senegal", value: "SN" },
            				{ text: "Serbia", value: "RS" },
            				{ text: "Seychelles", value: "SC" },
            				{ text: "Sierra Leone", value: "SL" },
            				{ text: "Singapore", value: "SG" },
            				{ text: "Sint Maarten (Dutch part)", value: "SX" },
            				{ text: "Slovakia", value: "SK" },
            				{ text: "Slovenia", value: "SI" },
            				{ text: "Solomon Islands", value: "SB" },
            				{ text: "Somalia", value: "SO" },
            				{ text: "South Africa", value: "ZA" },
            				{ text: "South Georgia and the South Sandwich Islands", value: "GS" },
            				{ text: "South Sudan", value: "SS" },
            				{ text: "Spain", value: "ES" },
            				{ text: "Sri Lanka", value: "LK" },
            				{ text: "Sudan (the)", value: "SD" },
            				{ text: "Suriname", value: "SR" },
            				{ text: "Svalbard and Jan Mayen", value: "SJ" },
            				{ text: "Sweden", value: "SE" },
            				{ text: "Switzerland", value: "CH" },
            				{ text: "Syrian Arab Republic", value: "SY" },
            				{ text: "Taiwan (Province of China)", value: "TW" },
            				{ text: "Tajikistan", value: "TJ" },
            				{ text: "Tanzania, United Republic of", value: "TZ" },
            				{ text: "Thailand", value: "TH" },
            				{ text: "Timor-Leste", value: "TL" },
            				{ text: "Togo", value: "TG" },
            				{ text: "Tokelau", value: "TK" },
            				{ text: "Tonga", value: "TO" },
            				{ text: "Trinidad and Tobago", value: "TT" },
            				{ text: "Tunisia", value: "TN" },
            				{ text: "Turkey", value: "TR" },
            				{ text: "Turkmenistan", value: "TM" },
            				{ text: "Turks and Caicos Islands (the)", value: "TC" },
            				{ text: "Tuvalu", value: "TV" },
            				{ text: "Uganda", value: "UG" },
            				{ text: "Ukraine", value: "UA" },
            				{ text: "United Arab Emirates (the)", value: "AE" },
            				{ text: "United States Minor Outlying Islands (the)", value: "UM" },
            				{ text: "Uruguay", value: "UY" },
            				{ text: "Uzbekistan", value: "UZ" },
            				{ text: "Vanuatu", value: "VU" },
            				{ text: "Venezuela (Bolivarian Republic of)", value: "VE" },
            				{ text: "Viet Nam", value: "VN" },
            				{ text: "Virgin Islands (British)", value: "VG" },
            				{ text: "Virgin Islands (U.S.)", value: "VI" },
            				{ text: "Wallis and Futuna", value: "WF" },
            				{ text: "Western Sahara", value: "EH" },
            				{ text: "Yemen", value: "YE" },
            				{ text: "Zambia", value: "ZM" },
            				{ text: "Zimbabwe", value: "ZW" },
            				{ text: "Åland Islands", value: "AX" }
            			],
            			languages: [
            				{ text: "English", value: "en" },
            				{ text: "Spanish", value: "es" },
            				{ text: "French", value: "fr" },
            				{ text: "Afar", value: "aa" },
            				{ text: "Abkhazian", value: "ab" },
            				{ text: "Avestan", value: "ae" },
            				{ text: "Afrikaans", value: "af" },
            				{ text: "Akan", value: "ak" },
            				{ text: "Amharic", value: "am" },
            				{ text: "Aragonese", value: "an" },
            				{ text: "Arabic", value: "ar" },
            				{ text: "Assamese", value: "as" },
            				{ text: "Avaric", value: "av" },
            				{ text: "Aymara", value: "ay" },
            				{ text: "Azerbaijani", value: "az" },
            				{ text: "Bashkir", value: "ba" },
            				{ text: "Belarusian", value: "be" },
            				{ text: "Bulgarian", value: "bg" },
            				{ text: "Bihari", value: "bh" },
            				{ text: "Bislama", value: "bi" },
            				{ text: "Bambara", value: "bm" },
            				{ text: "Bengali", value: "bn" },
            				{ text: "Tibetan", value: "bo" },
            				{ text: "Breton", value: "br" },
            				{ text: "Bosnian", value: "bs" },
            				{ text: "Catalan", value: "ca" },
            				{ text: "Chechen", value: "ce" },
            				{ text: "Chamorro", value: "ch" },
            				{ text: "Corsican", value: "co" },
            				{ text: "Cree", value: "cr" },
            				{ text: "Czech", value: "cs" },
            				{ text: "Church Slavic", value: "cu" },
            				{ text: "Chuvash", value: "cv" },
            				{ text: "Welsh", value: "cy" },
            				{ text: "Danish", value: "da" },
            				{ text: "German", value: "de" },
            				{ text: "Divehi", value: "dv" },
            				{ text: "Dzongkha", value: "dz" },
            				{ text: "Ewe", value: "ee" },
            				{ text: "Greek", value: "el" },
            				{ text: "Esperanto", value: "eo" },
            				{ text: "Estonian", value: "et" },
            				{ text: "Basque", value: "eu" },
            				{ text: "Persian", value: "fa" },
            				{ text: "Fulah", value: "ff" },
            				{ text: "Finnish", value: "fi" },
            				{ text: "Fijian", value: "fj" },
            				{ text: "Faroese", value: "fo" },
            				{ text: "Western Frisian", value: "fy" },
            				{ text: "Irish", value: "ga" },
            				{ text: "Scottish Gaelic", value: "gd" },
            				{ text: "Galician", value: "gl" },
            				{ text: "Guarani", value: "gn" },
            				{ text: "Gujarati", value: "gu" },
            				{ text: "Manx", value: "gv" },
            				{ text: "Hausa", value: "ha" },
            				{ text: "Hebrew", value: "he" },
            				{ text: "Hindi", value: "hi" },
            				{ text: "Hiri Motu", value: "ho" },
            				{ text: "Croatian", value: "hr" },
            				{ text: "Haitian", value: "ht" },
            				{ text: "Hungarian", value: "hu" },
            				{ text: "Armenian", value: "hy" },
            				{ text: "Herero", value: "hz" },
            				{ text: "Interlingua", value: "ia" },
            				{ text: "Indonesian", value: "id" },
            				{ text: "Interlingue", value: "ie" },
            				{ text: "Igbo", value: "ig" },
            				{ text: "Sichuan Yi", value: "ii" },
            				{ text: "Inupiaq", value: "ik" },
            				{ text: "Ido", value: "io" },
            				{ text: "Icelandic", value: "is" },
            				{ text: "Italian", value: "it" },
            				{ text: "Inuktitut", value: "iu" },
            				{ text: "Japanese", value: "ja" },
            				{ text: "Javanese", value: "jv" },
            				{ text: "Georgian", value: "ka" },
            				{ text: "Kongo", value: "kg" },
            				{ text: "Kikuyu", value: "ki" },
            				{ text: "Kwanyama", value: "kj" },
            				{ text: "Kazakh", value: "kk" },
            				{ text: "Kalaallisut", value: "kl" },
            				{ text: "Khmer", value: "km" },
            				{ text: "Kannada", value: "kn" },
            				{ text: "Korean", value: "ko" },
            				{ text: "Kanuri", value: "kr" },
            				{ text: "Kashmiri", value: "ks" },
            				{ text: "Kurdish", value: "ku" },
            				{ text: "Komi", value: "kv" },
            				{ text: "Cornish", value: "kw" },
            				{ text: "Kirghiz", value: "ky" },
            				{ text: "Latin", value: "la" },
            				{ text: "Luxembourgish", value: "lb" },
            				{ text: "Ganda", value: "lg" },
            				{ text: "Limburgish", value: "li" },
            				{ text: "Lingala", value: "ln" },
            				{ text: "Lao", value: "lo" },
            				{ text: "Lithuanian", value: "lt" },
            				{ text: "Luba-Katanga", value: "lu" },
            				{ text: "Latvian", value: "lv" },
            				{ text: "Malagasy", value: "mg" },
            				{ text: "Marshallese", value: "mh" },
            				{ text: "Maori", value: "mi" },
            				{ text: "Macedonian", value: "mk" },
            				{ text: "Malayalam", value: "ml" },
            				{ text: "Mongolian", value: "mn" },
            				{ text: "Marathi", value: "mr" },
            				{ text: "Malay", value: "ms" },
            				{ text: "Maltese", value: "mt" },
            				{ text: "Burmese", value: "my" },
            				{ text: "Nauru", value: "na" },
            				{ text: "Norwegian Bokmal", value: "nb" },
            				{ text: "North Ndebele", value: "nd" },
            				{ text: "Nepali", value: "ne" },
            				{ text: "Ndonga", value: "ng" },
            				{ text: "Dutch", value: "nl" },
            				{ text: "Norwegian Nynorsk", value: "nn" },
            				{ text: "Norwegian", value: "no" },
            				{ text: "South Ndebele", value: "nr" },
            				{ text: "Navajo", value: "nv" },
            				{ text: "Chichewa", value: "ny" },
            				{ text: "Occitan", value: "oc" },
            				{ text: "Ojibwa", value: "oj" },
            				{ text: "Oromo", value: "om" },
            				{ text: "Oriya", value: "or" },
            				{ text: "Ossetian", value: "os" },
            				{ text: "Panjabi", value: "pa" },
            				{ text: "Pali", value: "pi" },
            				{ text: "Polish", value: "pl" },
            				{ text: "Pashto", value: "ps" },
            				{ text: "Portuguese", value: "pt" },
            				{ text: "Quechua", value: "qu" },
            				{ text: "Romansh", value: "rm" },
            				{ text: "Kirundi", value: "rn" },
            				{ text: "Romanian", value: "ro" },
            				{ text: "Russian", value: "ru" },
            				{ text: "Kinyarwanda", value: "rw" },
            				{ text: "Sanskrit", value: "sa" },
            				{ text: "Sardinian", value: "sc" },
            				{ text: "Sindhi", value: "sd" },
            				{ text: "Northern Sami", value: "se" },
            				{ text: "Sango", value: "sg" },
            				{ text: "Sinhala", value: "si" },
            				{ text: "Slovak", value: "sk" },
            				{ text: "Slovenian", value: "sl" },
            				{ text: "Samoan", value: "sm" },
            				{ text: "Shona", value: "sn" },
            				{ text: "Somali", value: "so" },
            				{ text: "Albanian", value: "sq" },
            				{ text: "Serbian", value: "sr" },
            				{ text: "Swati", value: "ss" },
            				{ text: "Southern Sotho", value: "st" },
            				{ text: "Sundanese", value: "su" },
            				{ text: "Swedish", value: "sv" },
            				{ text: "Swahili", value: "sw" },
            				{ text: "Tamil", value: "ta" },
            				{ text: "Telugu", value: "te" },
            				{ text: "Tajik", value: "tg" },
            				{ text: "Thai", value: "th" },
            				{ text: "Tigrinya", value: "ti" },
            				{ text: "Turkmen", value: "tk" },
            				{ text: "Tagalog", value: "tl" },
            				{ text: "Tswana", value: "tn" },
            				{ text: "Tonga", value: "to" },
            				{ text: "Turkish", value: "tr" },
            				{ text: "Tsonga", value: "ts" },
            				{ text: "Tatar", value: "tt" },
            				{ text: "Twi", value: "tw" },
            				{ text: "Tahitian", value: "ty" },
            				{ text: "Uighur", value: "ug" },
            				{ text: "Ukrainian", value: "uk" },
            				{ text: "Urdu", value: "ur" },
            				{ text: "Uzbek", value: "uz" },
            				{ text: "Venda", value: "ve" },
            				{ text: "Vietnamese", value: "vi" },
            				{ text: "Volapuk", value: "vo" },
            				{ text: "Walloon", value: "wa" },
            				{ text: "Wolof", value: "wo" },
            				{ text: "Xhosa", value: "xh" },
            				{ text: "Yiddish", value: "yi" },
            				{ text: "Yoruba", value: "yo" },
            				{ text: "Zhuang", value: "za" },
            				{ text: "Chinese", value: "zh" },
            				{ text: "Chinese (Traditional)", value: "zh-Hant" },
            				{ text: "Chinese (Simplified)", value: "zh-Hans" },
            				{ text: "Zulu", value: "zu" }
            			],
            			contacts: []
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#organization textarea.schema'));
            			$('#organization').hide();
            		},
            		methods: {
            			isValidURL: isValidURL,
            			organization_type_changed: function () {
            				var key = this.selected_organization_type;
            				var org = this.organization_types.find(function (o) { return o.key === key; });
            				var more_specific_types = org.more_specific_types || [];
            				if (more_specific_types.length) {
            					more_specific_types.unshift({ key: '', desc: 'None' });
            				}
            				this.more_specific_organization_types = more_specific_types;
            			},
            			addNewProfile: function () {
            				this.social_profiles.push({ source: '', url: '' });
            			},
            			removeProfile: function (idx) {
            				this.social_profiles.splice(idx, 1);
            			},
            			addNewContact: function () {
            				var contact = {
            					phone: '',
            					email: '',
            					contact_type: '',
            					areas: [],
            					languages: [],
            					options: []
            				};
            
            				this.contacts.push(contact);
            				this.$nextTick(initStdTooltips);
            			},
            			removeContact: function (idx) {
            				this.contacts.splice(idx, 1);
            			},
            			reset_script: function() {
            				this.name = '';
            				this.alternateName = '';
            				this.url = '';
            				this.logoUrl = '';
            				this.social_profiles = [];
            				this.selected_organization_type = 'Organization';
            				this.selected_specific_organization_type = '';
            				this.more_specific_organization_types = [];
            				this.contacts = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org",
            					"@type": this.selected_specific_organization_type || this.selected_organization_type,
            					"name": this.name.trim(),
            					"url": this.url.trim(),
            					"logo": this.logoUrl.trim()
            				};
            
            				if (this.alternateName.trim()) {
            					schema.alternateName = this.alternateName.trim();
            				}
            
            				var social_urls = this.social_profiles.map(p => p.url.trim()).filter(Boolean);
            
            				if (social_urls.length) {
            					schema.sameAs = social_urls;
            				}
            
            				var contacts = this.contacts.map(function(r) {
            					var e = {
            						"@type": "ContactPoint",
            						"telephone": r.phone.trim(),
            						"contactType": r.contact_type
            					};
            
            					if (r.email.trim()) {
            						e.email = r.email.trim();
            					}
            
            					if (r.options.length) {
            						e.contactOption = r.options.length === 1 ? r.options[0] : r.options;
            					}
            
            					if (r.areas.length) {
            						e.areaServed = r.areas.length === 1 ? r.areas[0] : r.areas;
            					}
            
            					if (r.languages.length) {
            						e.availableLanguage = r.languages.length === 1 ? r.languages[0] : r.languages;
            					}
            
            					return e;
            				});
            
            				if (contacts.length) {
            					schema.contactPoint = contacts;
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            	var coronaVue = new Vue({
            		el: '#corona',
            		data: {
            			name: '',
            			text: '',
            			date_posted: '',	// date_picker
            			date_expires: '',	// date_picker
            
            			time_posted: '',
            			time_expires: '',
            
            			quarantineGuidelines_url: '',
            			diseasePreventionInfo_url: '',
            
            			spatialCoverage: []
            		},
            		mounted: function(){
            			this.editor = loadCodeMirror(document.querySelector('#corona textarea.schema'));
            			$('#corona').hide();
            
            			var $posted_datepicker = $('#corona-datepicker-date_posted');
            			var $expires_datepicker = $('#corona-datepicker-date_expires');
            
            			var $posted_datepicker_btn = $('#corona-datepicker-date_posted-btn');
            			var $expires_datepicker_btn = $('#corona-datepicker-date_expires-btn');
            
            			$posted_datepicker_btn.on('click', function () {
            				$posted_datepicker.toggle()
            			});
            
            			$expires_datepicker_btn.on('click', function () {
            				$expires_datepicker.toggle()
            			});
            
            			var this_vue = this;
            
            			var current_date = new Date();
            
            			$posted_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.date_posted = formatDate(date);
            					$(el).hide();
            				}
            			});
            
            			$expires_datepicker.DatePicker({
            				inline: true,
            				date: current_date,
            				calendars: 1,
            				mode: 'single',
            				onChange: function(date, el) {
            					this_vue.date_expires = formatDate(date);
            					$(el).hide();
            				}
            			});
            		},
            		methods: {
            			isValidURL: isValidURL,
            			isValidTime: isValidTime,
            			addNewArea: function () {
            				this.spatialCoverage.push({ text: '' });
            			},
            			removeArea: function (idx) {
            				this.spatialCoverage.splice(idx, 1);
            			},
            			reset_script: function() {
            				this.name = '';
            				this.text = '';
            				this.quarantineGuidelines_url = '';
            				this.diseasePreventionInfo_url = '';
            				this.date_posted = '';
            				this.date_expires = '';
            				this.time_posted = '';
            				this.time_expires = '';
            				this.spatialCoverage = [];
            			}
            		},
            		computed: {
            			schemaScript: function () {
            				var schema = {
            					"@context": "https://schema.org/",
            					"@type": "SpecialAnnouncement",
            					name: this.name.trim(),
            					text: this.text.trim(),
            					datePosted: '',
            					expires: '',
            					quarantineGuidelines: this.quarantineGuidelines_url.trim(),
            					diseasePreventionInfo: this.diseasePreventionInfo_url.trim(),
            					category: "https://www.wikidata.org/wiki/Q81068910"
            				};
            
            				if (this.date_posted) {
            					let time = this.isValidTime(this.time_posted) ? this.time_posted : '00:00';
            					schema.datePosted = this.date_posted + 'T' + time;
            				}
            
            				if (this.date_expires) {
            					let time = this.isValidTime(this.time_expires) ? this.time_expires : '00:00';
            					schema.expires = this.date_expires + 'T' + time;
            				}
            
            				var areas = this.spatialCoverage.map(e => e.text.trim()).filter(Boolean);
            
            				if (areas.length) {
            					schema.spatialCoverage = areas.map(function (n) {
            						return {
            							"@type": "AdministrativeArea",
            							name: n
            						};
            					});
            				}
            
            				var schema_script = to_schema_script(schema);
            
            				if (this.editor) {
            					this.editor.setValue(schema_script);
            				}
            
            				return schema_script;
            			}
            		}
            	});
            
            });
         </script>
         <script type="text/javascript">
         var HINTS_ITEMS_Header = {
         	'smg-validate' : 'Send your script to <a href="https://search.google.com/structured-data/testing-tool" target="_blank">Google\'s Structured Data Testing Tool</a>, then click the green arrow button to validate your code','smg-test' : 'Send your script to <a href="https://search.google.com/structured-data/testing-tool/u/0/" target="_blank">Google\'s Rich Results Test Tool</a>, then select the device type and click the Test Code button.','smg-copy' : 'After your code has been validated and tested, click the Copy button to save to your clipboard, then paste the code into your page.','smg-reset' : 'Caution! Clicking this button removes all content you\'ve entered into the form.',
         	'' : ''
         };
         $(document).ready(function(){
         	initTooltips(HINTS_ITEMS_Header);
         });
      </script>
      <div class="g_hide">
         <style>.async-hide { opacity: 0 !important} </style>
      </div>
<style type="text/css">


.f_left {
    float: left
}

.f_right {
    float: right
}

.clear_div {
    clear: both;
    height: 0
}
.exo {
    font-family: 'Exo 2', Trebuchet MS, Segoe UI, sans-serif
}
div.section {
    margin: 0
}

div.section.white {
    margin: 0;
    background-color: #FFF
}
div.section.lblue {
    margin: 0;
    background-color: #378ffb
}
div.section .wrap, header .wrap {
    margin: 0 auto;
    width: 1200px;
    text-align: center
}
div#content.std div.section.white, div#content.std div.section.gray {
    min-height: 550px
}

div#content.std div.section .wrap {
    text-align: left;
    padding: 72px 0 0 0
}
div#content.std div.section.mini {
    min-height: initial
}

div#content.std div.section.mini .wrap {
    padding: 54px 0
}
div#content {
    margin: 100px 0 0 0
}
div#content.std {
    margin: 0
}input, textarea, select {
    padding: 10px;
    color: #333;
    border: #ddd 1px solid;
    display: inline;
    margin-bottom: 2px;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px
}.g_hide {
    display: none;
    z-index: -1
}body {
    background-color: #fff;
    padding: 0;
    margin: 0;
    text-align: center;
    width: 100%;
    font-family: "Open Sans", "Helvetica Neue", Segoe UI, Helvetica, Arial, sans-serif;
    font-weight: 400;
    line-height: 1.8;
    font-size: 12pt
}


.f_left {
    float: left
}

.f_right {
    float: right
}

.clear_div {
    clear: both;
    height: 0
}.exo {
    font-family: 'Exo 2', Trebuchet MS, Segoe UI, sans-serif
}div.section {
    margin: 0
}

div.section.white {
    margin: 0;
    background-color: #FFF
}div.section.lblue {
    margin: 0;
    background-color: #378ffb
}div.section .wrap, header .wrap {
    margin: 0 auto;
    width: 1200px;
    text-align: center
}div#content.std div.section.white, div#content.std div.section.gray {
    min-height: 550px
}

div#content.std div.section .wrap {
    text-align: left;
    padding: 72px 0 0 0
}div#content.std div.section.mini {
    min-height: initial
}

div#content.std div.section.mini .wrap {
    padding: 54px 0
}div#content {
    margin: 100px 0 0 0
}

div#content.home {
    margin: 0
}

div#content.std {
    margin: 0
}.hint_icon, .hint_icon_info {
    display: inline-block;
    width: 10px;
    height: 10px;
    margin: -1px 0
}

.hint_icon {
    background: url(www-img/web/gui/hint_icon_10.png) no-repeat
}
div#content.std div.section .wrap {
    text-align: left
}.select_ovast {
    background-color: #102349;
    background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAoAAAAGCAYAAAD68A/GAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA4hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMDY3IDc5LjE1Nzc0NywgMjAxNS8wMy8zMC0yMzo0MDo0MiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpkMmJlMTdhOS04ZTA0LTRlYzMtOGZhMS1iYjQ2NWYyYjk2OTIiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6MjlDNDNCMEY4OTdFMTFFNjg1REVDRjBEOUY5OTExNDEiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6MjlDNDNCMEU4OTdFMTFFNjg1REVDRjBEOUY5OTExNDEiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTUuNSAoTWFjaW50b3NoKSI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOjgzNDY4MDFiLWJkMGItMWU0My1hODkxLTU1OGZhYjllMjg4NSIgc3RSZWY6ZG9jdW1lbnRJRD0iYWRvYmU6ZG9jaWQ6cGhvdG9zaG9wOmM1NzAzYzBlLWMxYjAtMTE3OS05NThkLWRlNDE0ZGE5NWJkMiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PuJr4FcAAABaSURBVHjaXM2xDYBACIXhZ+MGdKzj1G5xJtq4gRvY4CNyCUDyN/BdbjGzE8DLNvagjrCdrSAc9s/BhCGS2PkMXyi7G87Ibzpfd1yQG6SvMi6ow4mvSPPtE2AAyP6y10asM2UAAAAASUVORK5CYII=);
    background-position: center right 10px;
    background-repeat: no-repeat;
    background-size: 10px 6px;
    -moz-user-select: -moz-none;
    -ms-user-select: none;
    user-select: none;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
/*     border-radius: 20px; */
    line-height: 36px;
    padding: 0 45px 0 15px;
    color: #fff;
    font-family: 'Open Sans';
    font-size: 12pt;
    font-weight: 600;
    cursor: pointer;
    min-width: 0
}.hint_icon, .hint_icon_info {
    display: inline-block;
    width: 10px;
    height: 10px;
    margin: -1px 0
}

.hint_icon {
    background: url(www-img/web/gui/hint_icon_10.png) no-repeat
}.CodeMirror {
    font-family: monospace;
    height: 300px;
    color: #000
}

.CodeMirror-lines {
    padding: 4px 0
}

.CodeMirror pre {
    padding: 0 4px
}

.CodeMirror-scrollbar-filler, .CodeMirror-gutter-filler {
    background-color: #fff
}

.CodeMirror-gutters {
    border-right: 1px solid #ddd;
    background-color: #f7f7f7;
    white-space: nowrap
}

.CodeMirror-linenumber {
    padding: 0 3px 0 5px;
    min-width: 20px;
    text-align: right;
    color: #999;
    white-space: nowrap
}.cm-s-default .cm-string {
    color: #a11
}

.cm-s-default .cm-string-2 {
    color: #f50
}
.CodeMirror {
    position: relative;
    overflow: hidden;
    background: #fff
}

.CodeMirror-scroll {
    overflow: scroll !important;
    margin-bottom: -30px;
    margin-right: -30px;
    padding-bottom: 30px;
    height: 100%;
    outline: none;
    position: relative;
    text-align: left;
}

.CodeMirror-sizer {
    position: relative;
    border-right: 30px solid transparent
}

.CodeMirror-vscrollbar, .CodeMirror-hscrollbar, .CodeMirror-scrollbar-filler, .CodeMirror-gutter-filler {
    position: absolute;
    z-index: 6;
    display: none
}

.CodeMirror-vscrollbar {
    right: 0;
    top: 0;
    overflow-x: hidden;
    overflow-y: scroll
}

.CodeMirror-hscrollbar {
    bottom: 0;
    left: 0;
    overflow-y: hidden;
    overflow-x: scroll
}

.CodeMirror-scrollbar-filler {
    right: 0;
    bottom: 0
}

.CodeMirror-gutter-filler {
    left: 0;
    bottom: 0
}

.CodeMirror-gutters {
    position: absolute;
    left: 0;
    top: 0;
    z-index: 3
}

.CodeMirror-gutter {
    white-space: normal;
    height: 100%;
    display: inline-block;
    margin-bottom: -30px;
    *zoom: 1; *display: inline
}

.CodeMirror-gutter-wrapper {
    position: absolute;
    z-index: 4;
    background: none !important;
    border: none !important
}

.CodeMirror-gutter-background {
    position: absolute;
    top: 0;
    bottom: 0;
    z-index: 4
}

.CodeMirror-gutter-elt {
    position: absolute;
    cursor: default;
    z-index: 4
}

.CodeMirror-gutter-wrapper {
    -webkit-user-select: none;
    -moz-user-select: none;
    user-select: none
}

.CodeMirror-lines {
    cursor: text;
    min-height: 1px
}

.CodeMirror pre {
    -moz-border-radius: 0;
    -webkit-border-radius: 0;
    border-radius: 0;
    border-width: 0;
    background: transparent;
    font-family: inherit;
    font-size: inherit;
    margin: 0;
    white-space: pre;
    word-wrap: normal;
    line-height: inherit;
    color: inherit;
    z-index: 2;
    position: relative;
    overflow: visible;
    -webkit-tap-highlight-color: transparent
}
.CodeMirror-code {
    outline: none
}

.CodeMirror-scroll, .CodeMirror-sizer, .CodeMirror-gutter, .CodeMirror-gutters, .CodeMirror-linenumber {
    -moz-box-sizing: content-box;
    box-sizing: content-box
}

.CodeMirror-measure {
    position: absolute;
    width: 100%;
    height: 0;
    overflow: hidden;
    visibility: hidden
}

.CodeMirror-cursor {
    position: absolute
}

.CodeMirror-measure pre {
    position: static
}

div.CodeMirror-cursors {
    visibility: hidden;
    position: relative;
    z-index: 3
}

div.CodeMirror-dragcursors {
    visibility: visible
}

.CodeMirror-focused div.CodeMirror-cursors {
    visibility: visible
}
.lbl_top {
    color: #666;
    font-size: 12pt;
    font-weight: 600
}

.panel ul {
    list-style: none;
    margin: 7px 0
}

.panel li {
    margin: 0
}

.panel input.xt_l {
    min-width: 504px
}

.panel input.xt_p {
    min-width: 442px
}

.inner_step_wrap {
    margin: 0 0 10px;
    padding: 3px 0 18px;
    border-bottom: 1px dotted #eee
}

.inner_title {
    font-size: 12pt;
    font-weight: 600;
    line-height: 42px;
    color: #07418a
}

.inner_step_wrap textarea {
    display: block;
    min-width: 504px
}


.item_title {
    font-size: 12pt
}

.markup_item label span {
    display: block
}

.fnbtns_wrap {
    margin: 0 0 7px;
    text-align: right
}

.panel button {
    font-family: 'Open Sans';
    font-size: 12pt;
    font-weight: 600;
    color: #fff;
    background-color: #07418a;
    padding: 0 18px;
    cursor: pointer;
    line-height: 38px;
    display: inline-block;
    border: 0;
    margin: 4px 5px 4px 0;
    -webkit-transition-property: background, color;
    -webkit-box-shadow: 0 2px 2px 0 rgba(0, 0, 0, .14), 0 3px 1px -2px rgba(0, 0, 0, .12), 0 1px 5px 0 rgba(0, 0, 0, .2);
    box-shadow: 0 2px 2px 0 rgba(0, 0, 0, .14), 0 3px 1px -2px rgba(0, 0, 0, .12), 0 1px 5px 0 rgba(0, 0, 0, .2);
    transition: all .3s cubic-bezier(.55, 0, .55, .2);
    transition-property: background-color, box-shadow, transform, -webkit-transform
}

.panel button.copy_script {
    background-color: #bb4605
}

.panel button.reset_script {
    background-color: #bb0505
}

.panel button:hover {
    background-color: #0D5AB8
}

.CodeMirror {
    border: 1px solid #eee;
    height: 638px
}

.CodeMirror pre {
    font-size: 9pt
}

.markup_section_wrap {
    margin: 14px 0 0;
    padding: 7px 3px 3px 3px;
    border-top: 1px solid #eee
}

pre {
    overflow-x: auto;
    white-space: pre-wrap;
    white-space: -moz-pre-wrap;
    white-space: -pre-wrap;
    white-space: -o-pre-wrap;
    word-wrap: break-word
}

#corona>.f_left, #corona>.f_right, #organization>.f_left, #organization>.f_right, #recipe>.f_left, #recipe>.f_right, #website_sitelinks_searchbox>.f_left, #website_sitelinks_searchbox>.f_right, #video>.f_left, #video>.f_right, #product>.f_left, #product>.f_right, #localbusiness>.f_left, #localbusiness>.f_right, #jobposting>.f_left, #jobposting>.f_right, #event>.f_left, #event>.f_right, #person>.f_left, #person>.f_right, #faq>.f_left, #faq>.f_right, #howto>.f_left, #howto>.f_right, #article>.f_left, #article>.f_right {
    width: 45%;
    text-align: left;
}

input.invalid {
    color: red;
    border-color: red;
    outline: none
}

.error_msg {
    color: red;
    font-size: 14px
}

#corona .datepicker, #recipe .datepicker, #video .datepicker, #product .datepicker, #article .datepicker, #event .datepicker, #jobposting .datepicker {
    padding: 0
}

.markup_item div.datepicker td.datepickerFuture a {
    color: #000
}

.multi-select {
    max-height: 120px;
    overflow-y: scroll
}
.CodeMirror {
    font-family: monospace;
    height: 300px;
    color: #000
}

.CodeMirror-lines {
    padding: 4px 0
}

.CodeMirror pre {
    padding: 0 4px
}

.CodeMirror-scrollbar-filler, .CodeMirror-gutter-filler {
    background-color: #fff
}

.CodeMirror-gutters {
    border-right: 1px solid #ddd;
    background-color: #f7f7f7;
    white-space: nowrap
}

.CodeMirror-linenumber {
    padding: 0 3px 0 5px;
    min-width: 20px;
    text-align: right;
    color: #999;
    white-space: nowrap
}
[v-cloak] {
    display: none
}

.panel {
    width: 100%;
    min-height: 100px;
    padding: 18px;
    float: left;
    -webkit-box-shadow: 0 1px 11px 0 #ccc;
    -moz-box-shadow: 0 1px 11px 0 #ccc;
    box-shadow: 0 1px 11px 0 #ccc
}

.lbl_top {
    color: #666;
    font-size: 12pt;
    font-weight: 600
}

.panel ul {
    list-style: none;
    margin: 7px 0
}

.panel li {
    margin: 0
}

.panel input.xt_l {
    min-width: 504px
}

.panel input.xt_p {
    min-width: 442px
}

.inner_step_wrap {
    margin: 0 0 10px;
    padding: 3px 0 18px;
    border-bottom: 1px dotted #eee
}

.inner_title {
    font-size: 12pt;
    font-weight: 600;
    line-height: 42px;
    color: #07418a
}

.inner_step_wrap textarea {
    display: block;
    min-width: 504px
}

.markup_item label, .item_title {
    color: #102349;
    font-size: 10pt;
    font-weight: 500;
    line-height: 25px;
    margin: 14px 0 0;
    display: block
}

.item_title {
    font-size: 12pt
}

.markup_item label span {
    display: block
}

.fnbtns_wrap {
    margin: 0 0 7px;
    text-align: right
}

.panel button {
    font-family: 'Open Sans';
    font-size: 12pt;
    font-weight: 600;
    color: #fff;
    background-color: #07418a;
    padding: 0 18px;
    cursor: pointer;
    line-height: 38px;
    display: inline-block;
    border: 0;
    margin: 4px 5px 4px 0;
    -webkit-transition-property: background, color;
    -webkit-box-shadow: 0 2px 2px 0 rgba(0, 0, 0, .14), 0 3px 1px -2px rgba(0, 0, 0, .12), 0 1px 5px 0 rgba(0, 0, 0, .2);
    box-shadow: 0 2px 2px 0 rgba(0, 0, 0, .14), 0 3px 1px -2px rgba(0, 0, 0, .12), 0 1px 5px 0 rgba(0, 0, 0, .2);
    transition: all .3s cubic-bezier(.55, 0, .55, .2);
    transition-property: background-color, box-shadow, transform, -webkit-transform
}

.panel button.copy_script {
    background-color: #bb4605
}

.panel button.reset_script {
    background-color: #bb0505
}
.CodeMirror {
    border: 1px solid #eee;
    height: 638px
}

.CodeMirror pre {
    font-size: 9pt
}

.markup_section_wrap {
    margin: 14px 0 0;
    padding: 7px 3px 3px 3px;
    border-top: 1px solid #eee
}

pre {
    overflow-x: auto;
    white-space: pre-wrap;
    white-space: -moz-pre-wrap;
    white-space: -pre-wrap;
    white-space: -o-pre-wrap;
    word-wrap: break-word
}

#corona>.f_left, #corona>.f_right, #organization>.f_left, #organization>.f_right, #recipe>.f_left, #recipe>.f_right, #website_sitelinks_searchbox>.f_left, #website_sitelinks_searchbox>.f_right, #video>.f_left, #video>.f_right, #product>.f_left, #product>.f_right, #localbusiness>.f_left, #localbusiness>.f_right, #jobposting>.f_left, #jobposting>.f_right, #event>.f_left, #event>.f_right, #person>.f_left, #person>.f_right, #faq>.f_left, #faq>.f_right, #howto>.f_left, #howto>.f_right, #article>.f_left, #article>.f_right {
    width: 45%
}

input.invalid {
    color: red;
    border-color: red;
    outline: none
}

.error_msg {
    color: red;
    font-size: 14px
}

#corona .datepicker, #recipe .datepicker, #video .datepicker, #product .datepicker, #article .datepicker, #event .datepicker, #jobposting .datepicker {
    padding: 0
}

.markup_item div.datepicker td.datepickerFuture a {
    color: #000
}

.multi-select {
    max-height: 120px;
    overflow-y: scroll
}

@media (max-width: 1220px) {
    .panel input.xt_l {
        min-width: initial
    }
}

.cal_icon.gray {
    opacity: .5
}

div.datepicker {
    position: relative;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 12px;
    width: 196px;
    height: 147px;
    position: absolute;
    cursor: default;
    top: 0;
    left: 0;
    display: none
}

.datepickerContainer {
    position: absolute
}

.datepickerBorderT, .datepickerBorderB, .datepickerBorderL, .datepickerBorderR, .datepickerBorderTL, .datepickerBorderTR, .datepickerBorderBL, .datepickerBorderBR {
    display: none
}
div.datepicker table {
    border-collapse: collapse
}

div.datepicker a {
    color: #000;
    text-decoration: none;
    cursor: default;
    outline: none
}

div.datepicker table td {
    text-align: center;
    padding: 0;
    margin: 0
}

div.datepicker th {
    text-align: center;
    color: #666;
    font-weight: 400;
    padding: 0
}

div.datepicker tbody a {
    display: block
}

.datepickerDays a {
    width: 20px;
    line-height: 16px;
    height: 16px;
    padding-right: 2px
}

.datepickerYears a, .datepickerMonths a {
    width: 39px;
    line-height: 36px;
    height: 36px;
    text-align: center
}

.datepickerMonths td:first-child a, .datepickerMonths td:last-child a, .datepickerYears td:first-child a, .datepickerYears td:last-child a {
    width: 38px
}

td.datepickerNotInMonth a {
    color: #666
}

tbody.datepickerDays td.datepickerSelected {
    background: #136A9F
}

tbody.datepickerDays td.datepickerNotInMonth.datepickerSelected {
    background: #17384d
}

tbody.datepickerYears td.datepickerSelected, tbody.datepickerMonths td.datepickerSelected {
    background: #17384d
}

div.datepicker td.datepickerSelected a {
    color: #fff
}

div.datepicker a:hover, div.datepicker a:hover {
    color: #88c5eb
}

div.datepicker td.datepickerNotInMonth a:hover {
    color: #999
}

.datepickerSpace div {
    width: 20px
}

.datepickerBlock {
    vertical-align: top
}

a.datepickerGoNext, a.datepickerGoPrev, a.datepickerMonth {
    text-align: center;
    height: 20px;
    line-height: 20px;
    float: left
}

div.datepicker th a.datepickerGoNext, div.datepicker th a.datepickerGoPrev {
    width: 20px;
    color: #666;
    display: none
}

div.datepicker th a.datepickerMonth {
    width: 114px;
    display: block
}

div.datepicker .datepickerFirstView th a.datepickerGoPrev, div.datepicker .datepickerLastView th a.datepickerGoNext {
    display: block
}

div.datepicker th a.datepickerMonth {
    margin-left: 20px
}

div.datepicker .datepickerFirstView th a.datepickerMonth {
    margin-left: 0
}

table.datepickerViewDays tbody.datepickerMonths, table.datepickerViewDays tbody.datepickerYears {
    display: none
}

table.datepickerViewMonths tbody.datepickerDays, table.datepickerViewMonths tbody.datepickerYears, table.datepickerViewMonths tr.datepickerDoW {
    display: none
}

table.datepickerViewYears tbody.datepickerDays, table.datepickerViewYears tbody.datepickerMonths, table.datepickerViewYears tr.datepickerDoW {
    display: none
}

td.datepickerDisabled a, td.datepickerDisabled.datepickerNotInMonth a {
    color: #555
}

td.datepickerDisabled a:hover {
    color: #333
}

div.datepicker tbody.datepickerDays td.datepickerSpecial a {
    background: #700;
    color: #fff
}

div.datepicker tbody.datepickerDays td.datepickerSpecial.datepickerSelected a {
    background: #a00
}

tbody.datepickerDays td.datepickerNotInMonth.datepickerSelected {
    background-color: transparent
}

div.datepicker td.datepickerNotInMonth a span {
    display: none
}

div.datepicker td.datepickerNotInMonth a:hover span {
    display: none
}

div.datepicker tbody.datepickerDays td.datepickerNotInMonth:hover {
    background-color: transparent
}

.datepicker {
    background-color: #F7F7F7;
    border: 1px solid #CCC;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px;
    padding: 10px
}

.datepickerSpace div {
    width: 2px
}

div.datepicker th {
    background-color: #DDD
}

div.datepicker th a.datepickerMonth {
    color: #008ED6;
    font-weight: 400
}

div.datepicker th {
    color: #000;
    font-weight: 700
}

div.datepicker table thead tr.datepickerDoW th {
    border-bottom: 1px solid #CCC
}

div.datepicker a, div.datepicker a:hover {
    color: #000
}

div.datepicker table.datepickerViewDays, div.datepicker table.datepickerViewMonths, div.datepicker table.datepickerViewYears {
    background-color: #fff
}

div.datepicker table tbody.datepickerDays td {
    border: 1px solid #F7F7F7;
    height: auto
}

tbody.datepickerDays td.datepickerSelected {
    background-color: #07C
}

div.datepicker td.datepickerFuture a {
    color: #DDD
}

div.datepicker tbody.datepickerDays td:hover {
    background-color: #FC3
}

div.datepicker td.datepickerToday a {
    font-weight: 700
}

.datepickerYears a, .datepickerMonths a {
    width: 42px
}

.datepickerMonths td:first-child a, .datepickerYears td:first-child a {
    width: 39px
}

div.datepicker th a.datepickerMonth {
    width: 121px
}

#date-range, .date-range {
    position: relative
}

#date-range-field, .date-range-field, #note_date-range-field {
    direction: ltr;
    width: inherit;
    height: 28px;
    overflow: hidden;
    position: relative;
    cursor: pointer;
    border: #ccc 1px solid;
    background: #f3f3f3;
    background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#fefefe), to(#d8d8d8));
    background-image: -webkit-linear-gradient(top, #fefefe, #d8d8d8);
    background-image: -moz-linear-gradient(top, #fefefe, #d8d8d8);
    background-image: -ms-linear-gradient(top, #fefefe, #d8d8d8);
    background-image: -o-linear-gradient(top, #fefefe, #d8d8d8);
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px;
    transition: all 0.5s ease
}

#date-range-field:hover, .date-range-field:hover, #note_date-range-field:hover {
    background: #ececec;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px
}

#date-range-field a, .date-range-field a {
    color: #B2B2B2;
    text-align: center;
    display: block;
    position: absolute;
    width: 26px;
    height: 25px;
    top: 0;
    right: 0;
    text-decoration: none;
    padding-top: 9px;
    border-radius: 0 3px 3px 0;
    font-size: 6pt
}

#date-range-field span, .date-range-field span, #note_date-range-field span {
    font: bold 8pt Segoe UI, Tahoma;
    position: relative;
    top: 0;
    height: 30px;
    line-height: 30px;
    left: 5px;
    width: 250px;
    text-align: center
}

#alt_datepicker_calendar {
    direction: ltr;
    position: absolute;
    overflow: hidden;
    width: 497px;
    height: 178px;
    background-color: #F7F7F7;
    border: 1px solid #CCC;
    border-radius: 0 3px 3px 3px;
    display: none;
    padding: 10px 0 0 10px;
    z-index: 9999
}

.datepicker-calendar, #comp_datepicker_calendar, #note-datepicker-calendar {
    direction: ltr;
    position: absolute;
    top: 23px;
    right: 0;
    overflow: hidden;
    width: 497px;
    height: 178px;
    background-color: #F7F7F7;
    border: 1px solid #CCC;
    border-radius: 0 3px 3px 3px;
    display: none;
    padding: 10px 0 0 10px;
    z-index: 9999
}

#note-datepicker-calendar {
    display: block;
    position: relative;
    width: 372px;
    height: 150px;
    top: 28px;
    position: absolute;
    display: none
}

#note_date_box {
    position: relative
}

#note_date-range-field {
    width: 250px;
    text-align: center
}

.datepicker-calendar div.datepicker, #note-datepicker-calendar div.datepicker, #alt_datepicker_calendar div.datepicker, #comp_datepicker_calendar div.datepicker {
    background-color: transparent;
    border: none;
    border-radius: 0;
    padding: 0
}

#datepicker-calendar div.inner_options, #note-datepicker-calendar div.inner_options, #alt_datepicker_calendar div.inner_options, #comp_datepicker_calendar div.inner_options {
    float: right;
    padding-top: 150px;
    padding-right: 10px
}
.datepickerBlock {
    vertical-align: top
}

a.datepickerGoNext, a.datepickerGoPrev, a.datepickerMonth {
    text-align: center;
    height: 20px;
    line-height: 20px;
    float: left
}

div.datepicker th a.datepickerGoNext, div.datepicker th a.datepickerGoPrev {
    width: 20px;
    color: #666;
    display: none
}

div.datepicker th a.datepickerMonth {
    width: 114px;
    display: block
}

div.datepicker .datepickerFirstView th a.datepickerGoPrev, div.datepicker .datepickerLastView th a.datepickerGoNext {
    display: block
}

div.datepicker th a.datepickerMonth {
    margin-left: 20px
}

div.datepicker .datepickerFirstView th a.datepickerMonth {
    margin-left: 0
}

table.datepickerViewDays tbody.datepickerMonths, table.datepickerViewDays tbody.datepickerYears {
    display: none
}

table.datepickerViewMonths tbody.datepickerDays, table.datepickerViewMonths tbody.datepickerYears, table.datepickerViewMonths tr.datepickerDoW {
    display: none
}

table.datepickerViewYears tbody.datepickerDays, table.datepickerViewYears tbody.datepickerMonths, table.datepickerViewYears tr.datepickerDoW {
    display: none
}

td.datepickerDisabled a, td.datepickerDisabled.datepickerNotInMonth a {
    color: #555
}
.datepicker {
    background-color: #F7F7F7;
    border: 1px solid #CCC;
    -webkit-border-radius: 2px;
    -moz-border-radius: 2px;
    border-radius: 2px;
    padding: 10px
}

.datepickerSpace div {
    width: 2px
}

div.datepicker th {
    background-color: #DDD
}

div.datepicker th a.datepickerMonth {
    color: #008ED6;
    font-weight: 400
}

div.datepicker th {
    color: #000;
    font-weight: 700
}

div.datepicker table thead tr.datepickerDoW th {
    border-bottom: 1px solid #CCC
}

div.datepicker a, div.datepicker a:hover {
    color: #000
}

div.datepicker table.datepickerViewDays, div.datepicker table.datepickerViewMonths, div.datepicker table.datepickerViewYears {
    background-color: #fff
}

div.datepicker table tbody.datepickerDays td {
    border: 1px solid #F7F7F7;
    height: auto
}

tbody.datepickerDays td.datepickerSelected {
    background-color: #07C
}

div.datepicker td.datepickerFuture a {
    color: #DDD
}

div.datepicker tbody.datepickerDays td:hover {
    background-color: #FC3
}

div.datepicker td.datepickerToday a {
    font-weight: 700
}

.datepickerYears a, .datepickerMonths a {
    width: 42px
}

.datepickerMonths td:first-child a, .datepickerYears td:first-child a {
    width: 39px
}

div.datepicker th a.datepickerMonth {
    width: 121px
}
</style>